/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mdht.uml.cda.ui.internal.Activator;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MDHTPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NONE = "NONE";
    private static final String SELECT_FILTER = "Select Filter By Type";
    private static final String CONSOLURI = "http://www.openhealthtools.org/mdht/uml/cda/consol";
    private static String CARDINALITY_CHECK_BOX_LABEL = "Show multiplicity after the element name in the Properties view";
    private static String CARDINALITY_CHECK_BOX_TOOLTIP = "Show multiplicity after the element name in the Properties view. This does not affect the DITA publication (PDF, Online) - for that, dita-transform.xml needs to be adjusted to say cardinalityAfterElement=\"true\" in <transformToDita>";
    private static String PDF_GEN_DISABLE_CHECK_BOX_LABEL = "Disable built-in PDF generation";
    private static String PDF_GEN_DISABLE_CHECK_BOX_TOOLTIP = "Prevent the automatic generation of PDF  files in the workspace. This also removes the PDF Generation context menu option";
    public static String CARDINALITY_STORE_VALUE = "CardinalityCheckValue";
    public static String PDF_GEN_STORE_VALUE = "DisablePDFCheckValue";
    public static String EXPORT_CD_TRANSLATIONS_VALUE = "ExportCDtranslations";
    public static String OMIT_DOB_STORE_VALUE = "OmitDOBCheckValue";
    public static String OMIT_DOD_STORE_VALUE = "OmitDODCheckValue";
    public static String OMIT_UNITS_STORE_VALUE = "OmitUnitsCheckValue";
    public static String OMIT_VALIDATION_STORE_VALUE = "OmitValidationStoreValue";
    public static String COMBINE_SHEETS_VALUE = "org.eclipse.mdht.cda.xls.combinesheets";
    public static String WORKSHEET_CACHE_VALUE = "org.eclipse.mdht.cda.xls.worksheetcache";
    public static String DOCUMENT_COUNT_VALUE = "org.eclipse.mdht.cda.xls.documentcount";
    public static String CDA_REPORT_FILTERS = "CDAReportDefaultFilter";
    public static String CDA_REPORT_ACTIVE_FILTER = "CDAReportActiveFilter";
    public static final String CDA_REPORT_FILE_NAME_FILTERS = "fileNameFilter";
    public static String RELATED_PERSON_COUNT_VALUE = "org.eclipse.mdht.cda.xls.relatedpersoncount";
    private static String EXPORT_CD_TRANSLATIONS_CHECK_BOX_LABEL = "Include CD Translations in XLS Reports";
    private static String EXPORT_CD_TRANSLATIONS_CHECK_BOX_TOOLTIP = "Include CD Translations in XLS Reports";
    private static String OMIT_DOB_CHECK_BOX_LABEL = "Omit Patient DOB and Name from XLS Reports";
    private static String OMIT_DOB_CHECK_BOX_TOOLTIP = "Do not include Patient DOB and Name in reports";
    private static String OMIT_DOD_CHECK_BOX_LABEL = "Omit Patient DOD from XLS Reports";
    private static String OMIT_DOD_CHECK_BOX_TOOLTIP = "Do not include Patient DOD in reports";
    private static String OMIT_UNITS_CHECK_BOX_TOOLTIP = "Do not include Units of Measure in reports";
    private static String OMIT_UNITS_CHECK_BOX_LABEL = "Omit Quantity Units from XLS Reports";
    private static String OMIT_VALIDATION_CHECK_BOX_LABEL = "Omit CDA Validation from XLS Reports";
    private static String OMIT_VALIDATION_CHECK_BOX_TOOLTIP = "Do not include DCDA Validation in reports";
    private static String COMBINE_SHEETS_CHECK_BOX_LABEL = "Combine Sheets in XLS Reports";
    private static String COMBINE_SHEETS_CHECK_BOX_TOOLTIP = "Combine Sheets based on template hierachy so all versions of template go to same sheet in spreadsheet";
    private Button cardinalityCheckBox;
    private Button disablePdfGenerationCheckBox;
    private Button omitDOBCheckBox;
    private Button exporCDTranslationsCheckBox;
    private Button omitDODCheckBox;
    private Button omitUnitsCheckBox;
    private Text cdaReportFilterText;
    private CCombo cdaReportFilterCombo;
    private Text cdaFileFiltersText;
    private Button omitValidationCheckBox;
    private Button combineSheetsCheckBox;
    private Text worksheetCacheText;
    private Text documentCountText;
    private Text relatedPersonText;
    String cdaReportActivefilter;
    int worksheetCache;
    int documentcount;
    int relatedpersoncount;
    Map<String, List<String>> cdaReportfilters = new HashMap<String, List<String>>();
    FilterListSelectionDialog filterSelectionDialog = null;
    private Button setFilterButton;

    private Button createCheckBox(Composite group, String label, String toolTip) {
        Button button = new Button(group, 16416);
        button.setText(label);
        button.setToolTipText(toolTip);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createAddFilterButton(Composite group, String label, String toolTip) {
        Button button = new Button(group, 16392);
        button.setText(label);
        button.setToolTipText(toolTip);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MDHTPreferences.this.addFilterName("<<FilterName>>", MDHTPreferences.this.cdaReportfilters.keySet());
            }
        });
        return button;
    }

    private Button createFilterButton(Composite group, String label, String toolTip) {
        ILabelProvider lp = new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                EClass ec = (EClass)element;
                String theElementName = ec.getName();
                if (Character.isDigit(theElementName.charAt(theElementName.length() - 1))) {
                    theElementName = theElementName.substring(0, theElementName.length() - 1);
                }
                String[] nameArray = theElementName.split("(?=\\p{Upper})");
                StringBuffer sb = new StringBuffer();
                String[] stringArray = nameArray;
                int n = nameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String seg = stringArray[n2];
                    sb.append(seg).append(" ");
                    ++n2;
                }
                sb.append("(s)");
                return sb.toString();
            }
        };
        this.filterSelectionDialog = new FilterListSelectionDialog(group.getShell(), lp);
        this.filterSelectionDialog.setTitle(SELECT_FILTER);
        this.filterSelectionDialog.setMessage(SELECT_FILTER);
        final HashMap<EClass, HashSet<EClass>> theSectionCache = new HashMap<EClass, HashSet<EClass>>();
        this.getFilterHash(theSectionCache);
        this.filterSelectionDialog.setElements(theSectionCache.keySet().toArray());
        this.filterSelectionDialog.setMultipleSelection(true);
        Button button = new Button(group, 16392);
        button.setText(label);
        button.setToolTipText(toolTip);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String currentSelections = MDHTPreferences.this.cdaReportFilterText.getText();
                ArrayList<EClass> l = new ArrayList<EClass>();
                Object[] objectArray = theSectionCache.keySet().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object x = objectArray[n2];
                    EClass eClass = (EClass)x;
                    if (currentSelections.contains(MDHTPreferences.this.formatFilterName(eClass.getName()))) {
                        l.add(eClass);
                    }
                    ++n2;
                }
                MDHTPreferences.this.filterSelectionDialog.setInitialElementSelections(l);
                switch (MDHTPreferences.this.filterSelectionDialog.open()) {
                    case 0: {
                        if (MDHTPreferences.this.cdaReportfilters.containsKey(MDHTPreferences.this.cdaReportActivefilter)) {
                            MDHTPreferences.this.cdaReportfilters.get(MDHTPreferences.this.cdaReportActivefilter).clear();
                        } else {
                            MDHTPreferences.this.cdaReportfilters.put(MDHTPreferences.this.cdaReportActivefilter, new ArrayList());
                        }
                        objectArray = MDHTPreferences.this.filterSelectionDialog.getResult();
                        n = objectArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            MDHTPreferences.this.cdaReportfilters.get(MDHTPreferences.this.cdaReportActivefilter).add(((EClass)object).getName());
                            ++n2;
                        }
                        MDHTPreferences.this.cdaReportFilterText.setText(MDHTPreferences.this.formatFilterNames(MDHTPreferences.this.cdaReportfilters.get(MDHTPreferences.this.cdaReportActivefilter)));
                        break;
                    }
                    case 1: {
                        MDHTPreferences.this.cdaReportfilters.get(MDHTPreferences.this.cdaReportActivefilter).clear();
                        MDHTPreferences.this.cdaReportFilterText.setText(MDHTPreferences.NONE);
                    }
                }
            }
        });
        return button;
    }

    private String formatFilterNames(List<String> filterNames) {
        StringBuilder formattedFilters = new StringBuilder();
        if (filterNames != null) {
            for (String filter : filterNames) {
                if (formattedFilters.length() > 0) {
                    formattedFilters.append(System.getProperty("line.separator"));
                }
                formattedFilters.append(this.formatFilterName(filter));
            }
        } else {
            formattedFilters.append(NONE);
        }
        return formattedFilters.toString();
    }

    private String formatFilterName(String filterName) {
        StringBuffer formattedFilterName = new StringBuffer();
        if (!StringUtils.isEmpty((String)filterName)) {
            String[] nameArray;
            if (Character.isDigit(filterName.charAt(filterName.length() - 1))) {
                filterName = filterName.substring(0, filterName.length() - 1);
            }
            String[] stringArray = nameArray = filterName.split("(?=\\p{Upper})");
            int n = nameArray.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                formattedFilterName.append(seg).append(" ");
                ++n2;
            }
            formattedFilterName.append("(s)");
        }
        return formattedFilterName.toString();
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "MDHTPreferences");
        Composite composite_textField = this.createComposite(parent, 2);
        this.cardinalityCheckBox = this.createCheckBox(composite_textField, CARDINALITY_CHECK_BOX_LABEL, CARDINALITY_CHECK_BOX_TOOLTIP);
        Composite pdf_composite_textField = this.createComposite(parent, 2);
        this.disablePdfGenerationCheckBox = this.createCheckBox(pdf_composite_textField, PDF_GEN_DISABLE_CHECK_BOX_LABEL, PDF_GEN_DISABLE_CHECK_BOX_TOOLTIP);
        Composite dob_composite_textField = this.createComposite(parent, 2);
        this.omitDOBCheckBox = this.createCheckBox(dob_composite_textField, OMIT_DOB_CHECK_BOX_LABEL, OMIT_DOB_CHECK_BOX_TOOLTIP);
        Composite doD_composite_textField = this.createComposite(parent, 2);
        this.omitDODCheckBox = this.createCheckBox(doD_composite_textField, OMIT_DOD_CHECK_BOX_LABEL, OMIT_DOD_CHECK_BOX_TOOLTIP);
        Composite validateion_composite_textField = this.createComposite(parent, 2);
        this.omitValidationCheckBox = this.createCheckBox(validateion_composite_textField, OMIT_VALIDATION_CHECK_BOX_LABEL, OMIT_VALIDATION_CHECK_BOX_TOOLTIP);
        Composite units_composite_textField = this.createComposite(parent, 2);
        this.omitUnitsCheckBox = this.createCheckBox(units_composite_textField, OMIT_UNITS_CHECK_BOX_LABEL, OMIT_UNITS_CHECK_BOX_TOOLTIP);
        Composite exporCDTranslations_composite_textField = this.createComposite(parent, 2);
        this.exporCDTranslationsCheckBox = this.createCheckBox(exporCDTranslations_composite_textField, EXPORT_CD_TRANSLATIONS_CHECK_BOX_LABEL, EXPORT_CD_TRANSLATIONS_CHECK_BOX_TOOLTIP);
        this.initializeValues();
        Composite filterLabelComposite = this.createComposite(parent, 2);
        Label filterLabel = new Label(filterLabelComposite, 16384);
        filterLabel.setText("Report Section Filters");
        Composite filterComboLabelComposite = this.createComposite(parent, 2);
        Label filterComboLabel = new Label(filterComboLabelComposite, 16384);
        filterComboLabel.setText("Active Filter");
        Composite filter_Combo = this.createComposite(parent, 1);
        this.cdaReportFilterCombo = new CCombo(filter_Combo, 8);
        String[] items = (String[])this.cdaReportfilters.keySet().stream().toArray(String[]::new);
        if (items.length == 0) {
            ArrayList<String> noneList = new ArrayList<String>();
            noneList.add(NONE);
            items = noneList.toArray(new String[0]);
        }
        this.cdaReportFilterCombo.setItems(items);
        this.cdaReportFilterCombo.select(Arrays.asList(this.cdaReportFilterCombo.getItems()).indexOf(this.cdaReportActivefilter));
        this.cdaReportFilterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Logger.log(1, "Selection: " + MDHTPreferences.this.cdaReportFilterCombo.getItem(MDHTPreferences.this.cdaReportFilterCombo.getSelectionIndex()));
                MDHTPreferences.this.cdaReportActivefilter = MDHTPreferences.this.cdaReportFilterCombo.getItem(MDHTPreferences.this.cdaReportFilterCombo.getSelectionIndex());
                MDHTPreferences.this.cdaReportFilterText.setText(MDHTPreferences.this.formatFilterNames(MDHTPreferences.this.cdaReportfilters.get(MDHTPreferences.this.cdaReportActivefilter)));
                if (MDHTPreferences.this.cdaReportActivefilter.equals(MDHTPreferences.NONE) || StringUtils.isEmpty((String)MDHTPreferences.this.cdaReportActivefilter)) {
                    MDHTPreferences.this.setFilterButton.setEnabled(false);
                } else {
                    MDHTPreferences.this.setFilterButton.setEnabled(true);
                }
            }
        });
        Composite filter_text = this.createComposite(parent, 1);
        this.cdaReportFilterText = new Text(filter_text, 19010);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        this.cdaReportFilterText.setLayoutData((Object)gd);
        this.cdaReportFilterText.setEditable(false);
        Composite filter_composite = this.createComposite(parent, 2);
        this.setFilterButton = this.createFilterButton(filter_composite, "Set Section Filters", "Set the Section filters for CDA spreadsheet");
        if (this.cdaReportActivefilter.equals(NONE) || StringUtils.isEmpty((String)this.cdaReportActivefilter)) {
            this.setFilterButton.setEnabled(false);
        } else {
            this.setFilterButton.setEnabled(true);
        }
        Composite addFilter_composite = this.createComposite(parent, 3);
        this.createAddFilterButton(addFilter_composite, "Add Filters", "Add filter for CDA spreadsheet");
        this.cdaReportFilterText.setText(this.formatFilterNames(this.cdaReportfilters.get(this.cdaReportActivefilter)));
        Composite combine_composite_textField = this.createComposite(parent, 2);
        this.combineSheetsCheckBox = this.createCheckBox(combine_composite_textField, COMBINE_SHEETS_CHECK_BOX_LABEL, COMBINE_SHEETS_CHECK_BOX_TOOLTIP);
        IPreferenceStore store = this.getPreferenceStore();
        this.combineSheetsCheckBox.setSelection(store.getBoolean(COMBINE_SHEETS_VALUE));
        Composite filterLabelComposite5 = this.createComposite(parent, 2);
        Label filterLabel5 = new Label(filterLabelComposite5, 16384);
        filterLabel5.setText("Spreadsheet Generation Performance Configurations");
        Composite filterLabelComposite4 = this.createComposite(parent, 2);
        Label filterLabel4 = new Label(filterLabelComposite4, 16384);
        filterLabel4.setText("Set Document Count");
        this.documentCountText = new Text(filterLabelComposite4, 131072);
        this.documentCountText.setToolTipText("SET DOCUMENT COUNT PER SPREADSHEET");
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.widthHint = 200;
        this.documentCountText.setLayoutData((Object)gd2);
        this.documentCountText.setText(String.valueOf(this.documentcount));
        VerifyListener ensureTextContainsOnlyDigits = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                e.doit = string.matches("\\d*");
            }
        };
        this.documentCountText.addVerifyListener(ensureTextContainsOnlyDigits);
        Composite filterLabelComposite1 = this.createComposite(parent, 2);
        Label filterLabel1 = new Label(filterLabelComposite1, 16384);
        filterLabel1.setText("Set Worksheet Cache");
        this.worksheetCacheText = new Text(filterLabelComposite1, 131072);
        this.worksheetCacheText.setToolTipText("SET WORKSHEET MEMORY CACHE");
        GridData gd3 = new GridData(4, 4, false, false);
        gd3.widthHint = 200;
        this.worksheetCacheText.setLayoutData((Object)gd3);
        this.worksheetCacheText.setText(String.valueOf(this.worksheetCache));
        this.worksheetCacheText.addVerifyListener(ensureTextContainsOnlyDigits);
        Composite filterLabelComposite6 = this.createComposite(parent, 2);
        Label relatedpersonLabel = new Label(filterLabelComposite6, 16384);
        relatedpersonLabel.setText("Set Related Person Number");
        this.relatedPersonText = new Text(filterLabelComposite6, 131072);
        this.relatedPersonText.setToolTipText("SET RELATED PERSON NUMBER");
        GridData gd6 = new GridData(4, 4, false, false);
        gd6.widthHint = 200;
        this.relatedPersonText.setLayoutData((Object)gd6);
        this.relatedPersonText.setText(String.valueOf(this.relatedpersoncount));
        this.relatedPersonText.addVerifyListener(ensureTextContainsOnlyDigits);
        return new Composite(parent, 0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.cardinalityCheckBox.setSelection(store.getDefaultBoolean(CARDINALITY_STORE_VALUE));
        this.disablePdfGenerationCheckBox.setSelection(store.getBoolean(PDF_GEN_STORE_VALUE));
        this.omitDOBCheckBox.setSelection(store.getBoolean(OMIT_DOB_STORE_VALUE));
        this.omitDODCheckBox.setSelection(store.getBoolean(OMIT_DOD_STORE_VALUE));
        this.omitUnitsCheckBox.setSelection(store.getBoolean(OMIT_UNITS_STORE_VALUE));
        this.omitValidationCheckBox.setSelection(store.getBoolean(OMIT_VALIDATION_STORE_VALUE));
        this.combineSheetsCheckBox.setSelection(store.getBoolean(COMBINE_SHEETS_VALUE));
        this.exporCDTranslationsCheckBox.setSelection(store.getBoolean(EXPORT_CD_TRANSLATIONS_VALUE));
        this.cdaReportFilterText.setText(NONE);
        this.cdaReportActivefilter = NONE;
        this.worksheetCache = 100000;
        this.documentcount = 1000;
        this.relatedpersoncount = 5;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.cardinalityCheckBox.setSelection(store.getBoolean(CARDINALITY_STORE_VALUE));
        this.disablePdfGenerationCheckBox.setSelection(store.getBoolean(PDF_GEN_STORE_VALUE));
        this.omitDOBCheckBox.setSelection(store.getBoolean(OMIT_DOB_STORE_VALUE));
        this.exporCDTranslationsCheckBox.setSelection(store.getBoolean(EXPORT_CD_TRANSLATIONS_VALUE));
        this.omitDODCheckBox.setSelection(store.getBoolean(OMIT_DOD_STORE_VALUE));
        this.omitUnitsCheckBox.setSelection(store.getBoolean(OMIT_UNITS_STORE_VALUE));
        this.omitValidationCheckBox.setSelection(store.getBoolean(OMIT_VALIDATION_STORE_VALUE));
        MDHTPreferences.filtersFromString(store.getString(CDA_REPORT_FILTERS), this.cdaReportfilters);
        for (String k3 : this.cdaReportfilters.keySet()) {
            Logger.log(1, "LOOPNG " + k3);
            Logger.log(1, "VALUE " + this.cdaReportfilters.get(k3));
        }
        this.cdaReportActivefilter = store.getString(CDA_REPORT_ACTIVE_FILTER);
        if (StringUtils.isEmpty((String)this.cdaReportActivefilter)) {
            this.cdaReportActivefilter = NONE;
        }
        this.worksheetCache = store.getInt(WORKSHEET_CACHE_VALUE);
        this.documentcount = store.getInt(DOCUMENT_COUNT_VALUE);
        this.relatedpersoncount = store.getInt(RELATED_PERSON_COUNT_VALUE);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(CARDINALITY_STORE_VALUE, this.cardinalityCheckBox.getSelection());
        store.setValue(PDF_GEN_STORE_VALUE, this.disablePdfGenerationCheckBox.getSelection());
        store.setValue(OMIT_DOB_STORE_VALUE, this.omitDOBCheckBox.getSelection());
        store.setValue(OMIT_DOD_STORE_VALUE, this.omitDODCheckBox.getSelection());
        store.setValue(EXPORT_CD_TRANSLATIONS_VALUE, this.exporCDTranslationsCheckBox.getSelection());
        store.setValue(OMIT_UNITS_STORE_VALUE, this.omitUnitsCheckBox.getSelection());
        store.setValue(OMIT_VALIDATION_STORE_VALUE, this.omitValidationCheckBox.getSelection());
        store.setValue(COMBINE_SHEETS_VALUE, this.combineSheetsCheckBox.getSelection());
        store.setValue(CDA_REPORT_FILTERS, MDHTPreferences.filtersToString(this.cdaReportfilters));
        store.setValue(CDA_REPORT_FILE_NAME_FILTERS, "C62TXT");
        store.setValue(CDA_REPORT_ACTIVE_FILTER, this.cdaReportActivefilter);
        try {
            this.worksheetCache = Integer.valueOf(this.worksheetCacheText.getText());
        }
        catch (NumberFormatException nfe) {
            this.worksheetCache = 100000;
        }
        store.setValue(WORKSHEET_CACHE_VALUE, this.worksheetCache);
        try {
            this.documentcount = Integer.valueOf(this.documentCountText.getText());
        }
        catch (NumberFormatException nfe) {
            this.documentcount = 1000;
        }
        store.setValue(DOCUMENT_COUNT_VALUE, this.documentcount);
        try {
            this.relatedpersoncount = Integer.valueOf(this.relatedPersonText.getText());
        }
        catch (NumberFormatException nfe) {
            this.relatedpersoncount = 5;
        }
        store.setValue(RELATED_PERSON_COUNT_VALUE, this.relatedpersoncount);
    }

    private static String filtersToString(Map<String, List<String>> map) {
        String mapAsString = map.keySet().stream().map(key -> String.valueOf(key) + "=" + " " + String.join((CharSequence)" ", (Iterable)map.get(key)) + " ").collect(Collectors.joining(", ", " ", " "));
        return mapAsString;
    }

    public static void filtersFromString(String mapAsString, Map<String, List<String>> filters) {
        filters.clear();
        if (mapAsString.contains("=")) {
            Map<String, String> map1 = Arrays.stream(mapAsString.split(",")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0], entry -> entry[1]));
            for (String k : map1.keySet()) {
                String key = StringUtils.trim((String)k);
                filters.put(key, new ArrayList());
                filters.get(key).addAll(Arrays.asList(map1.get(k).split(" ")));
            }
        } else {
            filters.put(NONE, new ArrayList());
            filters.get(NONE).addAll(Arrays.asList(mapAsString.split(" ")));
        }
    }

    void getFilterHash(HashMap<EClass, HashSet<EClass>> theSections) {
        EPackage consolPackage = EPackage.Registry.INSTANCE.getEPackage(CONSOLURI);
        TreeIterator packageContents = consolPackage.eAllContents();
        ArrayList<EClass> packageSections = new ArrayList<EClass>();
        ArrayList<EClass> rootSections = new ArrayList<EClass>();
        while (packageContents.hasNext()) {
            EObject packageObject = (EObject)packageContents.next();
            if (!(packageObject instanceof EClass)) continue;
            EClass eClass = (EClass)packageObject;
            boolean isSection = false;
            for (EClass eClass2 : eClass.getEAllSuperTypes()) {
                if (!"Section".equals(eClass2.getName())) continue;
                isSection = true;
                break;
            }
            if (!isSection) continue;
            packageSections.add(eClass);
        }
        HashSet<EClass> sectionBaseClasses = new HashSet<EClass>();
        for (EClass section : packageSections) {
            for (EClass parentSection : section.getESuperTypes()) {
                sectionBaseClasses.add(parentSection);
            }
        }
        Comparator<EClass> compare = new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(packageSections, compare);
        for (EClass section : packageSections) {
            if (sectionBaseClasses.contains(section)) continue;
            boolean isRealRoot = true;
            for (EClass sectionAgain : packageSections) {
                if (!sectionAgain.getName().startsWith(section.getName()) || sectionAgain.getName().equals(section.getName())) continue;
                isRealRoot = false;
            }
            if (!isRealRoot) continue;
            rootSections.add(section);
        }
        for (EClass ec3 : rootSections) {
            theSections.put(ec3, new HashSet());
            theSections.get(ec3).addAll((Collection<EClass>)ec3.getEAllSuperTypes());
            theSections.get(ec3).add(ec3);
            for (EClass sectionAgain : packageSections) {
                if (!ec3.getName().startsWith(sectionAgain.getName()) || ec3.getName().equals(sectionAgain.getName())) continue;
                theSections.get(ec3).add(sectionAgain);
            }
        }
    }

    private void addFilterName(String initialName, final Set<String> usedNames) {
        InputDialog dlg = new InputDialog(this.getShell(), "Add New Filter", "Enter Filter Name : ", initialName, new IInputValidator(){

            public String isValid(String newText) {
                if ((newText = newText.trim()).isEmpty()) {
                    return "EMPTY";
                }
                if (usedNames.contains(newText)) {
                    return "FILTER EXISTS";
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            this.cdaReportActivefilter = dlg.getValue().trim();
            Logger.log(1, "cdaReportActivefilter >>>" + this.cdaReportActivefilter);
            ArrayList<String> filters = new ArrayList<String>();
            filters.addAll(Arrays.asList(this.cdaReportFilterCombo.getItems()));
            filters.add(this.cdaReportActivefilter);
            for (String filter : filters) {
                Logger.log(1, "filter >>>" + filter);
            }
            this.cdaReportFilterCombo.setItems(filters.toArray(new String[0]));
            this.cdaReportFilterCombo.redraw();
            this.cdaReportFilterCombo.select(Arrays.asList(this.cdaReportFilterCombo.getItems()).indexOf(this.cdaReportActivefilter));
            if (this.cdaReportActivefilter.equals(NONE) || StringUtils.isEmpty((String)this.cdaReportActivefilter)) {
                this.setFilterButton.setEnabled(false);
            } else {
                this.setFilterButton.setEnabled(true);
            }
        }
    }

    private static class FilterListSelectionDialog
    extends ElementListSelectionDialog {
        private static final String SET_FILTER = "Set Filter";
        private static final String CLEAR_FILTER = "Clear Filter";

        public FilterListSelectionDialog(Shell parent, ILabelProvider renderer) {
            super(parent, renderer);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(1).setText(CLEAR_FILTER);
            this.getButton(0).setText(SET_FILTER);
        }
    }
}

