/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.builder;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public static void toggleNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.mdht.uml.cda.ui.org.eclipse.mdht.uml.cda.nature.id".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = "org.eclipse.mdht.uml.cda.ui.org.eclipse.mdht.uml.cda.nature.id";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
            description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[commands.length];
            System.arraycopy(commands, 0, newCommands, 1, commands.length - 1);
            newCommands[0] = commands[commands.length - 1];
            description.setBuildSpec(newCommands);
            if (project.getName().endsWith(".doc")) {
                String generateProject = project.getName().substring(0, project.getName().lastIndexOf(".doc"));
                IProject[] referencedProjects = description.getReferencedProjects();
                boolean hasGenerateReference = false;
                IProject[] iProjectArray = referencedProjects;
                int n = referencedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject rproject = iProjectArray[n2];
                    if (rproject.getName().equals(generateProject)) {
                        hasGenerateReference = true;
                        break;
                    }
                    ++n2;
                }
                if (!hasGenerateReference) {
                    IProject[] newReferencedProjects = new IProject[referencedProjects.length + 1];
                    System.arraycopy(referencedProjects, 0, newReferencedProjects, 0, referencedProjects.length);
                    newReferencedProjects[newReferencedProjects.length - 1] = ResourcesPlugin.getWorkspace().getRoot().getProject(generateProject);
                    description.setReferencedProjects(newReferencedProjects);
                }
            }
            project.setDescription(description, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                ToggleNatureAction.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        this.selection = selection;
        boolean enabled = false;
        if (selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).isEmpty() && structuredSelection.getFirstElement() instanceof IProject) {
            IProject project = (IProject)structuredSelection.getFirstElement();
            try {
                if (project.hasNature("org.eclipse.mdht.uml.cda.ui.org.eclipse.mdht.uml.cda.nature.id") || project.getName().endsWith(".doc")) {
                    enabled = true;
                } else {
                    Manifest projectManifest = new Manifest(CDAUIUtil.getManifest(project).getContents());
                    Attributes attributes = projectManifest.getMainAttributes();
                    String requiredBundles = attributes.getValue("Require-Bundle");
                    if (requiredBundles != null && requiredBundles.contains("org.eclipse.mdht.uml.cda") && CDAUIUtil.getGeneratorModelFile(project) != null) {
                        enabled = true;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        action.setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

