/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ConsolidateTemplatesAction
implements IObjectActionDelegate {
    protected NamedElement namedElement;
    private ResourceSet resourceSet;
    protected Resource sourceResource;
    private Package sourcePackage;
    private Map<Classifier, List<Classifier>> sourceInheritance;
    private String projectName = "consol";
    private String modelPath = "org.eclipse.mdht.uml.cda." + this.projectName + ".model/model/";
    private String consolPath = String.valueOf(this.modelPath) + this.projectName + ".uml";
    private Resource consolResource;
    private Package consolPackage;
    private Map<String, Class> consolMapping;
    private Map<Classifier, List<Classifier>> consolInheritance;
    private String vocabPath = String.valueOf(this.modelPath) + this.projectName + "-vocab.uml";
    private Resource vocabResource;
    private Package vocabPackage;
    private Map<String, Enumeration> vocabMapping;

    public void run(IAction action) {
        try {
            this.sourceInheritance = new HashMap<Classifier, List<Classifier>>();
            this.consolMapping = new HashMap<String, Class>();
            this.consolInheritance = new HashMap<Classifier, List<Classifier>>();
            this.vocabMapping = new HashMap<String, Enumeration>();
            this.resourceSet = this.namedElement.eResource().getResourceSet();
            URI consolURI = URI.createPlatformResourceURI((String)this.consolPath, (boolean)true);
            this.consolResource = this.resourceSet.getResource(consolURI, true);
            this.consolPackage = (Package)this.consolResource.getContents().get(0);
            URI vocabURI = URI.createPlatformResourceURI((String)this.vocabPath, (boolean)true);
            this.vocabResource = this.resourceSet.getResource(vocabURI, true);
            this.vocabPackage = (Package)this.vocabResource.getContents().get(0);
            EcoreUtil.resolveAll((Resource)this.sourcePackage.eResource());
            EcoreUtil.resolveAll((Resource)this.consolPackage.eResource());
            EcoreUtil.resolveAll((Resource)this.vocabPackage.eResource());
            this.mapExistingConsolidation();
            this.mapClassInheritance(this.sourcePackage, this.sourceInheritance);
            this.mapConsolInheritance(this.consolPackage, this.consolInheritance);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.consolPackage);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Consolidate Templates"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ArrayList<NamedElement> eObjectList = new ArrayList<NamedElement>();
                    if (ConsolidateTemplatesAction.this.sourceResource != null) {
                        eObjectList.addAll((Collection<NamedElement>)ConsolidateTemplatesAction.this.sourceResource.getContents());
                    } else {
                        eObjectList.add(ConsolidateTemplatesAction.this.namedElement);
                    }
                    TreeIterator iterator = EcoreUtil.getAllContents(eObjectList);
                    while (iterator != null && iterator.hasNext()) {
                        Object child = iterator.next();
                        if (!(child instanceof Class)) continue;
                        ConsolidateTemplatesAction.this.consolidateClass((Class)child);
                        iterator.prune();
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                ee.printStackTrace();
            }
            this.consolResource.save(null);
            this.vocabResource.save(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class consolidateClass(Class sourceClass) {
        if (CDAModelUtil.isCDAModel((Element)sourceClass)) {
            return sourceClass;
        }
        Class consolidatedClass = this.consolMapping.get(EcoreUtil.getURI((EObject)sourceClass).toString());
        if (consolidatedClass == null) {
            System.out.println("Consolidate: " + sourceClass.getQualifiedName());
            consolidatedClass = this.copyToConsolPackage(sourceClass);
            this.mergeInheritedProperties(sourceClass, consolidatedClass);
            String templateId = null;
            Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)sourceClass, (String)"CDATemplate");
            if (hl7Template != null) {
                templateId = (String)sourceClass.getValue(hl7Template, "templateId");
            }
            if (templateId == null && (templateId = CDAModelUtil.getTemplateId((Class)sourceClass)) != null) {
                hl7Template = CDAProfileUtil.applyCDAStereotype((Element)consolidatedClass, (String)"CDATemplate");
                consolidatedClass.setValue(hl7Template, "templateId", (Object)templateId);
            }
        }
        return consolidatedClass;
    }

    private void mergeInheritedProperties(Class sourceClass, Class umlClass) {
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        List allSourceParents = UMLUtil.getAllGeneralizations((Classifier)sourceClass);
        List allParents = UMLUtil.getAllGeneralizations((Classifier)umlClass);
        ArrayList<Property> allProperties = new ArrayList<Property>();
        ArrayList<Property> allAssociations = new ArrayList<Property>();
        ArrayList<Property> allAttributes = new ArrayList<Property>();
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        Class consolidationStop = null;
        for (Classifier classifier : allParents) {
            if (CDAModelUtil.isCDAModel((Element)classifier)) break;
            Class consolClass = this.consolMapping.get(EcoreUtil.getURI((EObject)classifier).toString());
            if (consolClass != null && consolClass != umlClass) {
                consolidationStop = consolClass;
                break;
            }
            Class consolSpecial = this.findConsolSpecialization((Class)classifier);
            if (consolSpecial == null || consolClass == umlClass) continue;
            consolidationStop = consolSpecial;
            break;
        }
        List<Classifier> consolidatedParents = this.getConsolidatedGeneralizations(umlClass, this.getConsolSource(consolidationStop));
        int i = consolidatedParents.size() - 1;
        while (i >= 0) {
            Class parent = (Class)consolidatedParents.get(i);
            for (Property property : parent.getOwnedAttributes()) {
                if (property.getAssociation() != null) {
                    allAssociations.add(property);
                    continue;
                }
                int index = this.findProperty(allProperties, property.getName());
                if (index >= 0) {
                    allProperties.set(index, property);
                    continue;
                }
                allProperties.add(property);
            }
            --i;
        }
        Iterator propertyIterator = allProperties.iterator();
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            if (!CDAModelUtil.isCDAModel((Element)property) || property.getLower() != 0) continue;
            propertyIterator.remove();
        }
        Iterator associationIterator = allAssociations.iterator();
        while (associationIterator.hasNext()) {
            Property property;
            property = (Property)associationIterator.next();
            if (!CDAModelUtil.isCDAModel((Element)property) || property.getLower() != 0) continue;
            associationIterator.remove();
        }
        ArrayList<Classifier> endTypes = new ArrayList<Classifier>();
        for (Property property : allAssociations) {
            endTypes.add((Classifier)property.getType());
        }
        int index = 0;
        while (index < allAssociations.size()) {
            Classifier classifier = (Classifier)endTypes.get(index);
            boolean hasSubclass = false;
            for (Object specific : UMLUtil.getAllSpecializations((Classifier)classifier)) {
                if (!endTypes.contains(specific)) continue;
                hasSubclass = true;
                break;
            }
            if (!hasSubclass) {
                allProperties.add((Property)allAssociations.get(index));
            }
            ++index;
        }
        int i2 = consolidatedParents.size() - 1;
        while (i2 >= 0) {
            Class parent = (Class)consolidatedParents.get(i2);
            if (!CDAModelUtil.isCDAModel((Element)parent)) {
                for (Constraint constraint : parent.getOwnedRules()) {
                    allConstraints.add(constraint);
                }
            }
            --i2;
        }
        for (Property property : allProperties) {
            if (!CDAModelUtil.isXMLAttribute((Property)property)) continue;
            allAttributes.add(property);
        }
        allProperties.removeAll(allAttributes);
        Collections.sort(allAttributes, new NamedElementComparator());
        for (Property property : allAttributes) {
            if (umlClass.getOwnedAttributes().contains((Object)property)) {
                umlClass.getOwnedAttributes().remove((Object)property);
                umlClass.getOwnedAttributes().add((Object)property);
                continue;
            }
            Property clone = (Property)EcoreUtil.copy((EObject)property);
            umlClass.getOwnedAttributes().add((Object)clone);
            UMLUtil.cloneStereotypes((Element)property, (Element)clone);
        }
        for (Property property : allProperties) {
            Class sourceType;
            Type endType;
            Enumeration mappedValueSet;
            ValueSetVersion valueSetVersion;
            Property mergedProperty = null;
            if (umlClass.getOwnedAttributes().contains((Object)property)) {
                mergedProperty = property;
                umlClass.getOwnedAttributes().remove((Object)property);
                umlClass.getOwnedAttributes().add((Object)mergedProperty);
            } else {
                mergedProperty = (Property)EcoreUtil.copy((EObject)property);
                umlClass.getOwnedAttributes().add((Object)mergedProperty);
                UMLUtil.cloneStereotypes((Element)property, (Element)mergedProperty);
            }
            ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)mergedProperty);
            if (valueSetConstraint != null && (valueSetVersion = valueSetConstraint.getReference()) != null && (mappedValueSet = this.copyToConsolVocab(valueSetVersion.getBase_Enumeration())) != null) {
                ValueSetVersion mappedValueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)mappedValueSet);
                valueSetConstraint.setReference(mappedValueSetVersion);
            }
            if (property.getAssociation() == null || !((endType = property.getType()) instanceof Class)) continue;
            Class consolType = null;
            if (!CDAModelUtil.isCDAModel((Element)endType) && (consolType = this.findConsolSpecialization((Class)endType)) == null && (sourceType = this.findSourceSpecialization((Class)endType)) != null) {
                consolType = this.consolidateClass(sourceType);
            }
            if (consolType == null) {
                consolType = this.consolidateClass((Class)endType);
            }
            mergedProperty.setType((Type)consolType);
            Association assocClone = (Association)umlClass.getNearestPackage().createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
            assocClone.getMemberEnds().add((Object)mergedProperty);
            Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
            ownedEnd.setType((Type)umlClass);
            assocClone.getOwnedEnds().add((Object)ownedEnd);
            UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)assocClone);
        }
        for (Constraint constraint : allConstraints) {
            if (umlClass.getOwnedRules().contains((Object)constraint)) {
                umlClass.getOwnedRules().remove((Object)constraint);
                umlClass.getOwnedRules().add((Object)constraint);
                continue;
            }
            Constraint clone = (Constraint)EcoreUtil.copy((EObject)constraint);
            umlClass.getOwnedRules().add((Object)clone);
            UMLUtil.cloneStereotypes((Element)constraint, (Element)clone);
        }
        ArrayList currentComments = new ArrayList(umlClass.getOwnedComments());
        umlClass.getOwnedComments().clear();
        int i3 = consolidatedParents.size() - 1;
        while (i3 > 0) {
            Classifier parent = consolidatedParents.get(i3);
            ArrayList comments = new ArrayList(parent.getOwnedComments());
            for (Comment comment : comments) {
                Comment clone = (Comment)EcoreUtil.copy((EObject)comment);
                umlClass.getOwnedComments().add((Object)clone);
                UMLUtil.cloneStereotypes((Element)comment, (Element)clone);
            }
            --i3;
        }
        umlClass.getOwnedComments().addAll(currentComments);
        umlClass.getGeneralizations().clear();
        if (consolidationStop != null) {
            umlClass.createGeneralization((Classifier)consolidationStop);
        }
        if (umlClass.getGeneralizations().isEmpty()) {
            umlClass.createGeneralization((Classifier)cdaClass);
        }
        HashSet<Class> substitutions = new HashSet<Class>();
        int i4 = allSourceParents.size() - 1;
        while (i4 >= 0) {
            Class parent = (Class)allSourceParents.get(i4);
            if (!(RIMModelUtil.isRIMModel((Element)parent) || CDAModelUtil.isCDAModel((Element)parent) || substitutions.contains(parent))) {
                umlClass.createSubstitution(null, (Classifier)parent);
                substitutions.add(parent);
            }
            --i4;
        }
    }

    private void mapExistingConsolidation() {
        EAnnotation annotation;
        for (Type consolType : this.consolPackage.getOwnedTypes()) {
            if (!(consolType instanceof Class) || (annotation = consolType.getEAnnotation("sourceClass")) == null || annotation.getReferences().isEmpty()) continue;
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                this.consolMapping.put(EcoreUtil.getURI((EObject)reference).toString(), (Class)consolType);
            }
        }
        for (Type consolType : this.vocabPackage.getOwnedTypes()) {
            if (!(consolType instanceof Enumeration) || (annotation = consolType.getEAnnotation("sourceClass")) == null || annotation.getReferences().isEmpty()) continue;
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Enumeration)) continue;
                this.vocabMapping.put(EcoreUtil.getURI((EObject)reference).toString(), (Enumeration)consolType);
            }
        }
    }

    private Class copyToConsolPackage(Class umlClass) {
        Class mappedClass = this.consolMapping.get(EcoreUtil.getURI((EObject)umlClass).toString());
        if (mappedClass == null) {
            mappedClass = (Class)EcoreUtil.copy((EObject)umlClass);
            this.consolPackage.getOwnedTypes().add((Object)mappedClass);
            UMLUtil.cloneStereotypes((Class)umlClass, (Class)mappedClass);
            this.consolMapping.put(EcoreUtil.getURI((EObject)umlClass).toString(), mappedClass);
            EAnnotation sourceAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            sourceAnnotation.setSource("sourceClass");
            sourceAnnotation.getReferences().add((Object)umlClass);
            mappedClass.getEAnnotations().add((Object)sourceAnnotation);
            for (Property property : umlClass.getOwnedAttributes()) {
                if (property.getAssociation() == null) continue;
                Property mappedProperty = mappedClass.getOwnedAttribute(property.getName(), property.getType());
                Association assocClone = (Association)umlClass.getNearestPackage().createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                assocClone.getMemberEnds().add((Object)mappedProperty);
                Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
                ownedEnd.setType((Type)umlClass);
                assocClone.getOwnedEnds().add((Object)ownedEnd);
                UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)assocClone);
            }
        }
        return mappedClass;
    }

    private Enumeration copyToConsolVocab(Enumeration vocabEnum) {
        Enumeration mappedEnum = this.vocabMapping.get(EcoreUtil.getURI((EObject)vocabEnum).toString());
        if (mappedEnum == null) {
            mappedEnum = (Enumeration)EcoreUtil.copy((EObject)vocabEnum);
            this.vocabPackage.getOwnedTypes().add((Object)mappedEnum);
            UMLUtil.cloneStereotypes((Enumeration)vocabEnum, (Enumeration)mappedEnum);
            this.vocabMapping.put(EcoreUtil.getURI((EObject)vocabEnum).toString(), mappedEnum);
            System.out.println("Consolidate Vocab: " + vocabEnum.getQualifiedName());
            EAnnotation sourceAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            sourceAnnotation.setSource("sourceClass");
            sourceAnnotation.getReferences().add((Object)vocabEnum);
            mappedEnum.getEAnnotations().add((Object)sourceAnnotation);
        }
        return mappedEnum;
    }

    private List<Classifier> getConsolidatedGeneralizations(Class classifier, Class consolidationStop) {
        ArrayList<Classifier> parents = new ArrayList<Classifier>();
        parents.add((Classifier)classifier);
        for (Classifier parent : classifier.getGenerals()) {
            Class special = this.findConsolSpecialization((Class)parent);
            if (special != null) {
                special = this.getConsolSource(special);
            }
            if (consolidationStop != null && (parents.contains(parent) || consolidationStop.equals(parent) || consolidationStop.equals(special))) continue;
            parents.addAll(this.getConsolidatedGeneralizations((Class)parent, consolidationStop));
        }
        return parents;
    }

    private void mapClassInheritance(Package umlPackage, Map<Classifier, List<Classifier>> map) {
        for (Type type : umlPackage.getOwnedTypes()) {
            if (!(type instanceof Class)) continue;
            this.mapClassInheritance((Class)type, map);
        }
    }

    private void mapConsolInheritance(Package umlPackage, Map<Classifier, List<Classifier>> map) {
        for (Type type : umlPackage.getOwnedTypes()) {
            if (!(type instanceof Class)) continue;
            this.mapConsolInheritance((Class)type, map);
        }
    }

    private void mapClassInheritance(Class umlClass, Map<Classifier, List<Classifier>> map) {
        map.put((Classifier)umlClass, UMLUtil.getAllGeneralizations((Classifier)umlClass));
    }

    private void mapConsolInheritance(Class umlClass, Map<Classifier, List<Classifier>> map) {
        EAnnotation annotation = umlClass.getEAnnotation("sourceClass");
        if (annotation != null && !annotation.getReferences().isEmpty()) {
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                map.put((Classifier)umlClass, UMLUtil.getAllGeneralizations((Classifier)((Class)reference)));
            }
        }
    }

    private Class getConsolSource(Class umlClass) {
        EAnnotation annotation;
        if (umlClass != null && (annotation = umlClass.getEAnnotation("sourceClass")) != null && !annotation.getReferences().isEmpty()) {
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                return (Class)reference;
            }
        }
        return null;
    }

    private Class findConsolSpecialization(Class umlClass) {
        Class specific = null;
        for (Classifier classifier : this.consolInheritance.keySet()) {
            if (!this.consolInheritance.get(classifier).contains(umlClass)) continue;
            return (Class)classifier;
        }
        return specific;
    }

    private Class findSourceSpecialization(Class umlClass) {
        Class specific = null;
        for (Classifier classifier : this.sourceInheritance.keySet()) {
            if (!this.sourceInheritance.get(classifier).contains(umlClass)) continue;
            return (Class)classifier;
        }
        return specific;
    }

    private int findProperty(List<Property> properties, String name) {
        if (name != null) {
            int i = 0;
            while (i < properties.size()) {
                if (name.equals(properties.get(i).getName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.sourceResource = null;
        this.namedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof NamedElement) {
                this.namedElement = (NamedElement)selected;
                this.sourcePackage = this.namedElement.getNearestPackage();
            }
        }
        action.setEnabled(this.namedElement != null);
    }
}

