/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.mdht.uml.transform.ecore.TransformInlinedProperties;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class TransformAssociation
extends TransformAbstract {
    private String getName(Class theClass) {
        return theClass != null ? theClass.getQualifiedName() : "CLASS NOT FOUND!";
    }

    protected void logUnsupportedAssociation(Class sourceClass, Class baseSourceClass, Class targetClass, Class baseTargetClass, int level) {
        String message = "Unsupported association: " + this.getName(baseSourceClass) + "(" + this.getName(sourceClass) + ")" + " -> " + this.getName(baseTargetClass) + "(" + this.getName(targetClass) + ")";
        Logger.log(level, message);
    }

    public TransformAssociation(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public Object caseAssociation(Association association) {
        if (this.isRemoved((Element)association)) {
            return null;
        }
        boolean firstOrderAssociation = false;
        Class sourceClass = null;
        Class targetClass = null;
        Property sourceProperty = null;
        for (Property property : association.getMemberEnds()) {
            if (!property.isNavigable()) continue;
            sourceClass = property.getClass_();
            if (!(property.getType() instanceof Class)) break;
            targetClass = (Class)property.getType();
            sourceProperty = property;
            break;
        }
        if (sourceClass == null || targetClass == null || sourceProperty == null) {
            this.removeModelElement((Element)sourceProperty);
            this.removeModelElement((Element)association);
            return null;
        }
        Class baseSourceClass = this.getBaseClass(sourceClass);
        Class baseTargetClass = this.getBaseClass(targetClass);
        if (baseSourceClass == null || baseTargetClass == null) {
            this.logUnsupportedAssociation(sourceClass, baseSourceClass, targetClass, baseTargetClass, 4);
            this.removeModelElement((Element)sourceProperty);
            this.removeModelElement((Element)association);
            return null;
        }
        Class constraintTarget = targetClass;
        if (!this.enableVariation_UseOriginalType()) {
            ArrayList parents = new ArrayList(targetClass.getGenerals());
            while (!parents.isEmpty() && !this.getEcoreProfile().isPrimaryEClass(constraintTarget)) {
                if (!(parents.get(0) instanceof Class)) continue;
                constraintTarget = (Class)parents.remove(0);
            }
        }
        if (!this.getEcoreProfile().isPrimaryEClass(constraintTarget) && TransformInlinedProperties.isInlineClassLocal(constraintTarget)) {
            for (Classifier next : constraintTarget.allParents()) {
                if (!(next instanceof Class) || TransformInlinedProperties.isInlineClassLocal((Class)next)) continue;
                constraintTarget = (Class)next;
                break;
            }
        }
        String baseTargetName = baseTargetClass.getName();
        String baseTargetLowerName = String.valueOf(baseTargetName.substring(0, 1).toLowerCase()) + baseTargetName.substring(1);
        String baseTargetQName = baseTargetClass.getQualifiedName();
        StringBuilder constraintBody = new StringBuilder();
        StringBuilder operationBody = new StringBuilder();
        String constraintTargetQName = this.getConstraintTargetQualifiedName(constraintTarget);
        if (!this.handleSpecialAssociation(constraintBody, operationBody, sourceProperty, sourceClass, targetClass, constraintTargetQName)) {
            String upperComparator;
            String comparator;
            boolean exists;
            boolean isEmpty;
            String[] associationEndOut = new String[1];
            String[] variableDeclarationOut = new String[1];
            if (this.getAssociationEndAndIteratorDeclaration(sourceProperty, sourceClass, baseSourceClass, targetClass, baseTargetClass, associationEndOut, variableDeclarationOut)) {
                firstOrderAssociation = true;
            }
            String associationEnd = associationEndOut[0];
            String variableDeclaration = variableDeclarationOut[0];
            if (associationEnd == null || variableDeclaration == null) {
                this.logUnsupportedAssociation(sourceClass, baseSourceClass, targetClass, baseTargetClass, 4);
                this.removeModelElement((Element)sourceProperty);
                this.removeModelElement((Element)association);
                return null;
            }
            String selector = !TransformInlinedProperties.isInlineClassLocal(targetClass) ? null : TransformInlinedProperties.getInlineFilterLocal(targetClass);
            int upper = sourceProperty.upperBound();
            boolean bl = isEmpty = upper == 0;
            int lower = isEmpty ? 0 : Math.max(this.enableVariation_UseOriginalLowerbound() ? 0 : 1, sourceProperty.getLower());
            boolean open = this.isOpen(association);
            boolean one = !(selector != null && selector.length() != 0 || upper != 1 || !open || this.enableVariation_UseOriginalLowerbound() && lower != 1);
            boolean notEmpty = lower == 1 && upper == -1;
            boolean bl2 = exists = notEmpty && (selector == null || selector.length() == 0) && open;
            if (one || exists || isEmpty || notEmpty) {
                comparator = null;
                upperComparator = null;
            } else if (upper == lower) {
                comparator = " = " + lower;
                upperComparator = null;
            } else if (upper > lower) {
                comparator = lower == 0 ? null : " >= " + lower;
                upperComparator = " <= " + upper;
            } else {
                comparator = " >= " + lower;
                upperComparator = null;
            }
            constraintBody.append(String.valueOf(this.addPrefix(baseSourceClass)) + associationEnd + "->");
            constraintBody.append(one ? "one(" : (exists ? "exists(" : "select("));
            constraintBody.append(variableDeclaration);
            constraintBody.append(" | ");
            String reference = associationEnd;
            if (!firstOrderAssociation && !this.isImplicitAssociation(sourceProperty, sourceClass, targetClass)) {
                reference = String.valueOf(reference) + "." + baseTargetLowerName;
            }
            constraintBody.append("not " + reference + ".oclIsUndefined() and ");
            constraintBody.append(String.valueOf(reference) + ".oclIsKindOf(" + constraintTargetQName + ")");
            this.appendAssociationStereotypeConditions(constraintBody, association, associationEnd, sourceClass, targetClass);
            constraintBody.append(")");
            if (selector != null && selector.length() > 0) {
                constraintBody.append(selector);
            }
            if (isEmpty) {
                constraintBody.append("->isEmpty()");
            } else if (!one && !exists) {
                if (notEmpty) {
                    constraintBody.append("->notEmpty()");
                } else {
                    constraintBody.append("->size()");
                    if (upperComparator == null) {
                        constraintBody.append(comparator);
                    } else if (comparator == null) {
                        constraintBody.append(upperComparator);
                    } else {
                        String select = constraintBody.toString();
                        constraintBody.append(comparator).append(" and ").append(select).append(upperComparator);
                    }
                }
            }
            operationBody.append("self.get" + TransformAssociation.pluralize(baseTargetName) + "()->select(");
            operationBody.append(String.valueOf(baseTargetLowerName) + " : " + baseTargetQName + " | ");
            operationBody.append("not " + baseTargetLowerName + ".oclIsUndefined() and ");
            operationBody.append(String.valueOf(baseTargetLowerName) + ".oclIsKindOf(" + constraintTargetQName + "))");
        }
        IEcoreProfileReflection.ValidationSeverityKind severity = this.getEcoreProfile().getValidationSeverity((Element)association, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
        String constraintName = this.createConstraintName((NamedElement)sourceProperty);
        String validationMessage = this.getEcoreProfile().getValidationMessage((Element)association, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
        if (severity != null) {
            TransformAssociation.setupConstraint(sourceClass, constraintName, constraintBody, false);
            if (severity == IEcoreProfileReflection.ValidationSeverityKind.INFO) {
                this.addValidationInfo(sourceClass, constraintName, validationMessage);
            } else if (severity == IEcoreProfileReflection.ValidationSeverityKind.WARNING) {
                this.addValidationWarning(sourceClass, constraintName, validationMessage);
            } else {
                this.addValidationError(sourceClass, constraintName, validationMessage);
            }
        } else {
            EList elements = sourceProperty.getRedefinedElements();
            if (elements != null && !elements.isEmpty()) {
                TransformAssociation.setupConstraint(sourceClass, constraintName, constraintBody, true);
                this.addValidationError(sourceClass, constraintName, validationMessage);
            }
        }
        if (!(targetClass.getOwner() instanceof Class || firstOrderAssociation || this.transformerOptions.isGenerateDomainInterface())) {
            if (sourceProperty.getUpper() == 1) {
                operationBody.append("->asSequence()->any(true)");
            }
            operationBody.append(".oclAsType(" + constraintTargetQName + ")");
            String operationName = "get";
            if (!UMLUtil.getRedefinedProperties((Property)sourceProperty).isEmpty()) {
                operationName = String.valueOf(operationName) + this.getEcoreProfile().getModelPrefix((NamedElement)sourceProperty);
            }
            operationName = String.valueOf(operationName) + (sourceProperty.getUpper() == 1 ? TransformAssociation.capitalize(sourceProperty.getName()) : TransformAssociation.capitalize(TransformAssociation.pluralize(sourceProperty.getName())));
            Operation operation = sourceClass.createOwnedOperation(operationName, null, null, (Type)constraintTarget);
            operation.setIsQuery(true);
            operation.setUpper(sourceProperty.getUpper());
            Constraint bodyConstraint = operation.createBodyCondition("body");
            bodyConstraint.getConstrainedElements().add((Object)operation);
            OpaqueExpression bodyExpression = (OpaqueExpression)bodyConstraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
            bodyExpression.getLanguages().add((Object)"OCL");
            bodyExpression.getBodies().add((Object)operationBody.toString());
        }
        this.removeModelElement((Element)sourceProperty);
        this.removeModelElement((Element)association);
        return association;
    }

    protected boolean isOpen(Association association) {
        return true;
    }

    protected boolean isImplicitAssociation(Property sourceProperty, Class sourceClass, Class targetClass) {
        return false;
    }

    protected boolean handleSpecialAssociation(StringBuilder constraintBody, StringBuilder operationBody, Property sourceProperty, Class sourceClass, Class targetClass, String constraintTargetQName) {
        return false;
    }

    protected abstract boolean getAssociationEndAndIteratorDeclaration(Property var1, Class var2, Class var3, Class var4, Class var5, String[] var6, String[] var7);

    protected boolean appendAssociationStereotypeConditions(StringBuilder constraintBody, Association association, String associationEnd, Class sourceClass, Class targetClass) {
        return false;
    }

    public String getConstraintTargetQualifiedName(Class constraintTarget) {
        String retVal = constraintTarget.getQualifiedName().replace(constraintTarget.getName(), UML2Util.getValidJavaIdentifier((String)constraintTarget.getName()));
        if (this.enableVariation_UseOriginalType()) {
            return retVal;
        }
        String[] arrStr = retVal.split("::");
        if (arrStr.length > 2) {
            retVal = this.getBaseClass(constraintTarget).getQualifiedName();
        }
        return retVal;
    }

    protected String addPrefix(Class baseSourceClass) {
        return "self.";
    }

    private static void setupConstraint(Class sourceClass, String constraintName, StringBuilder constraintBody, boolean isRemovalOverride) {
        Constraint constraint = sourceClass.createOwnedRule(constraintName, UMLPackage.eINSTANCE.getConstraint());
        constraint.getConstrainedElements().add((Object)sourceClass);
        OpaqueExpression expression = (OpaqueExpression)constraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        expression.getLanguages().add((Object)"OCL");
        expression.getBodies().add((Object)(isRemovalOverride ? "true" : constraintBody.toString()));
    }
}

