/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AnnotationsUtil {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\G\\s*((?>\\\\.|\\S)+)((?:\\s+(?>\\\\.|\\S)+\\s*+=\\s*(['\"])((?>\\\\.|.)*?)\\3)*)");
    private static final Pattern ANNOTATION_DETAIL_PATTERN = Pattern.compile("\\s+((?>\\\\.|\\S)+)\\s*+=\\s*((['\"])((?>\\\\.|.)*?)\\3)");
    private final Element element;
    private final String annotationSource;
    private AnnotationStore store;

    public AnnotationsUtil(Element element, String annotationSource) {
        this.annotationSource = annotationSource;
        this.element = element;
    }

    private AnnotationStore getStore() {
        if (this.store == null) {
            this.store = (AnnotationStore)EcoreUtil.getExistingAdapter((Notifier)this.element, (Object)this.annotationSource);
            if (this.store == null) {
                this.store = new AnnotationStore(this.annotationSource);
                this.element.eAdapters().add((Object)this.store);
            }
        }
        return this.store;
    }

    public String getAnnotation(String key) {
        return this.getStore().getAnnotation(key);
    }

    public void setAnnotation(String key, String value) {
        this.getStore().setAnnotation(key, value);
    }

    public void copyAnnotation(AnnotationsUtil source) {
        this.getStore().copyAnnotation(source);
    }

    public void removeAnnotation(String key) {
        this.getStore().removeAnnotation(key);
    }

    public void addAnnotation(String key, String newValue) {
        this.getStore().addAnnotation(key, newValue);
    }

    static Stereotype getStereotypeKind(Element element) {
        Stereotype stereotype = null;
        if (element instanceof Class) {
            stereotype = EcoreTransformUtil.getEcoreStereotype((EObject)element, "EClass");
        } else if (element instanceof Property) {
            Property property = (Property)element;
            stereotype = property.getType() instanceof DataType ? EcoreTransformUtil.getEcoreStereotype((EObject)element, "EAttribute") : EcoreTransformUtil.getEcoreStereotype((EObject)element, "EReference");
        } else if (element instanceof Package) {
            stereotype = EcoreTransformUtil.getEcoreStereotype((EObject)element, "EPackage");
        }
        return stereotype;
    }

    public void saveAnnotations() {
        this.getStore().save();
    }

    private static final class AnnotationStore
    extends AdapterImpl {
        private final String annotationSource;
        private final Map<String, String> annotations = new LinkedHashMap<String, String>();
        private boolean dirty;
        private Integer annotationIndex = null;

        AnnotationStore(String annotationSource) {
            this.annotationSource = annotationSource;
        }

        public boolean isAdapterForType(Object type) {
            return this.annotationSource.equals(type);
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            Element element = (Element)newTarget;
            this.annotations.clear();
            Stereotype stereotype = AnnotationsUtil.getStereotypeKind(element);
            if (stereotype != null && element.isStereotypeApplied(stereotype)) {
                List annotations = (List)element.getValue(stereotype, "annotations");
                for (String annotation : annotations) {
                    String sourceURI;
                    Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
                    if (!matcher.find() || (sourceURI = matcher.group(1)) == null || !sourceURI.trim().equals(this.annotationSource)) continue;
                    this.annotationIndex = annotations.indexOf(annotation);
                    Matcher detailMatcher = ANNOTATION_DETAIL_PATTERN.matcher(matcher.group(2));
                    while (detailMatcher.find()) {
                        String name = detailMatcher.group(1);
                        String value = detailMatcher.group(4);
                        if (name == null || value == null) continue;
                        this.setAnnotation(name, value.trim());
                    }
                }
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            this.annotations.clear();
            super.unsetTarget(oldTarget);
        }

        String getAnnotation(String key) {
            return this.annotations.get(key);
        }

        void setAnnotation(String key, String value) {
            this.dirty = true;
            this.annotations.put(key, value);
        }

        void copyAnnotation(AnnotationsUtil source) {
            Map<String, String> store = ((AnnotationsUtil)source).getStore().annotations;
            if (!store.isEmpty()) {
                this.dirty = true;
                this.annotations.putAll(store);
            }
        }

        void removeAnnotation(String key) {
            if (this.annotations.containsKey(key)) {
                this.dirty = true;
                this.annotations.remove(key);
            }
        }

        void addAnnotation(String key, String newValue) {
            List<String> valueList = null;
            String values = this.annotations.get(key);
            if (values != null) {
                valueList = Arrays.asList(values.split("\\s+"));
            } else {
                values = "";
            }
            if (valueList == null || !valueList.contains(newValue)) {
                if (values.length() > 0) {
                    values = String.valueOf(values) + " ";
                }
                values = String.valueOf(values) + newValue;
                this.dirty = true;
                this.annotations.put(key, values);
            }
        }

        void save() {
            if (!this.dirty) {
                return;
            }
            Element element = (Element)this.getTarget();
            StringBuilder annotationBuf = new StringBuilder();
            annotationBuf.append(this.annotationSource);
            for (String key : this.annotations.keySet()) {
                String value = this.annotations.get(key);
                String annotation = " " + key + "='" + value + "'";
                annotationBuf.append(annotation);
            }
            Stereotype stereotype = AnnotationsUtil.getStereotypeKind(element);
            if (stereotype != null) {
                String annotation;
                UMLUtil.safeApplyStereotype((Element)element, (Stereotype)stereotype);
                String string = annotation = this.annotations.keySet().isEmpty() ? null : annotationBuf.toString();
                if (this.annotationIndex != null) {
                    List allAnnotations = (List)element.getValue(stereotype, "annotations");
                    if (annotation == null && allAnnotations.size() == 1) {
                        element.setValue(stereotype, "annotations", new ArrayList());
                        this.annotationIndex = null;
                    } else {
                        element.setValue(stereotype, "annotations[" + this.annotationIndex + "]", (Object)annotation);
                    }
                } else if (annotation != null) {
                    List annotationList = (List)element.getValue(stereotype, "annotations");
                    this.annotationIndex = annotationList.size();
                    annotationList.add(annotation);
                    element.setValue(stereotype, "annotations", (Object)annotationList);
                }
            }
            this.dirty = false;
        }
    }
}

