/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class AbstractEcoreProfileReflection
implements IEcoreProfileReflection {
    protected abstract String getValidationSeverityAttributeName();

    protected abstract String getValidationMessageAttributeName();

    protected abstract String getAnnotationURI();

    @Override
    public Stereotype getAppliedValidationStereotype(Element element) {
        return this.getAppliedValidationStereotype(element, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
    }

    @Override
    public boolean hasValidationSupport(Element element) {
        return this.getAppliedValidationStereotype(element) != null;
    }

    @Override
    public IEcoreProfileReflection.ValidationSeverityKind getValidationSeverity(Element element, IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind) {
        String result = null;
        Stereotype stereotype = this.getAppliedValidationStereotype(element, stereotypeKind);
        if (stereotype != null) {
            Object value = element.getValue(stereotype, this.getValidationSeverityAttributeName());
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof EnumerationLiteral) {
                result = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                result = ((Enumerator)value).getName();
            }
        }
        return result == null ? null : IEcoreProfileReflection.ValidationSeverityKind.valueOf(result.toUpperCase());
    }

    @Override
    public String getValidationMessage(Element element, IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind) {
        String result = null;
        Stereotype stereotype = this.getAppliedValidationStereotype(element, stereotypeKind);
        if (stereotype != null) {
            Object value = element.getValue(stereotype, this.getValidationMessageAttributeName());
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof ValueSpecification) {
                result = ((ValueSpecification)value).stringValue();
            } else if (value != null) {
                result = String.valueOf(value);
            }
        }
        if (result == null || result.length() == 0) {
            result = this.getDefaultValidationMessage(element, stereotype);
        }
        return result;
    }

    protected String getDefaultValidationMessage(Element element, Stereotype stereotype) {
        return null;
    }

    @Override
    public AnnotationsUtil annotate(Element element) {
        return new AnnotationsUtil(element, this.getAnnotationURI());
    }

    @Override
    public AnnotationsUtil annotate(Element element, String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return new AnnotationsUtil(element, String.valueOf(this.getAnnotationURI()) + "/" + path);
    }
}

