/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.util.ModelFilter;
import org.eclipse.mdht.uml.transform.AbstractTransformer;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class FilterTransformer
extends AbstractTransformer {
    private ModelFilter modelFilter;
    private Package filteredPackage = null;

    public FilterTransformer() {
        this(new TransformerOptions());
    }

    public FilterTransformer(TransformerOptions options) {
        this.transformerOptions = options;
    }

    public Package getFilteredPackage() {
        return this.filteredPackage;
    }

    @Override
    public void transformModelElement(Element element) {
        if (this.modelFilter == null) {
            this.initialize(element.getNearestPackage());
        }
        try {
            TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
            while (iterator != null && iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                if (!(child instanceof Class)) continue;
                this.modelFilter.filterClass((Class)child);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.logException(e);
        }
    }

    public void initialize(Package sourcePackage) {
        this.filteredPackage = this.initializeModelPackageFrom((Element)sourcePackage, this.transformerOptions.getOutputModelPath(), "filtered", "flat", "Flat");
        this.modelFilter = new ModelFilter(sourcePackage, this.filteredPackage);
    }

    @Override
    public void saveResources() {
    }
}

