/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.mdht.uml.cda.core.profile.Inline;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.TransformInlinedProperties;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class TransformCDAInlineProperties
extends TransformInlinedProperties {
    public TransformCDAInlineProperties(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public String getPath(Class baseSourceClass, Class targetClass, Property sourceProperty) {
        if (CDAModelUtil.isClinicalDocument((Type)baseSourceClass) && CDAModelUtil.isSection((Type)targetClass)) {
            return "getAllSections()";
        }
        if (CDAModelUtil.isSection((Type)baseSourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass)) {
            Class cdaClass = CDAModelUtil.getCDAClass((Classifier)targetClass);
            if (cdaClass != null) {
                if (cdaClass.getName().equals("Act")) {
                    return "getActs()";
                }
                if (cdaClass.getName().equals("Encounter")) {
                    return "getEncounters()";
                }
                if (cdaClass.getName().equals("Observation")) {
                    return "getObservations()";
                }
                if (cdaClass.getName().equals("ObservationMedia")) {
                    return "getObservationMedias()";
                }
                if (cdaClass.getName().equals("Organizer")) {
                    return "getOrganizers()";
                }
                if (cdaClass.getName().equals("Procedure")) {
                    return "getProcedures()";
                }
                if (cdaClass.getName().equals("RegionOfInterest")) {
                    return "getRegionOfInterests()";
                }
                if (cdaClass.getName().equals("SubstanceAdministration")) {
                    return "getSubstanceAdministrations()";
                }
                if (cdaClass.getName().equals("Supply")) {
                    return "getSupplies()";
                }
            }
            return super.getPath(baseSourceClass, targetClass, sourceProperty);
        }
        return super.getPath(baseSourceClass, targetClass, sourceProperty);
    }

    public String getNullSafePath(Class baseSourceClass, Class targetClass, Property sourceProperty) {
        if (this.isHL7Datatype(sourceProperty.getType()) && !CDAProfileUtil.isMandatory((Element)sourceProperty)) {
            return String.valueOf(super.getNullSafePath(baseSourceClass, targetClass, sourceProperty)) + "->select(isNullFlavorUndefined())";
        }
        return super.getNullSafePath(baseSourceClass, targetClass, sourceProperty);
    }

    private boolean isHL7Datatype(Type type) {
        boolean result = false;
        if (type instanceof Classifier) {
            if (CDAModelUtil.isDatatypeModel((Element)type)) {
                result = true;
            } else {
                for (Classifier classifier : UMLUtil.getAllGeneralizations((Classifier)((Classifier)type))) {
                    if (!CDAModelUtil.isDatatypeModel((Element)classifier)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public boolean isInlineClass(Class _class) {
        Inline inline = CDAProfileUtil.getInline((Class)_class);
        if (inline != null) {
            return true;
        }
        return super.isInlineClass(_class);
    }

    public String getInlineFilter(Class inlineClass) {
        Inline inline = CDAProfileUtil.getInline((Class)inlineClass);
        if (inline != null) {
            return inline.getFilter() != null ? inline.getFilter() : "";
        }
        return super.getInlineFilter(inlineClass);
    }
}

