/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.mdht.uml.ui.navigator.internal.l10n.Messages;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class CloseModelAction
extends Action {
    private Element modelElement;
    private ISelectionProvider provider;

    public CloseModelAction(IWorkbenchPage p, ISelectionProvider selectionProvider) {
        this.setText(Messages.CloseModelAction_label);
        this.provider = selectionProvider;
    }

    public boolean isEnabled() {
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && ((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(Element.class);
            }
            if (selected instanceof Package) {
                this.modelElement = (Element)selected;
                return true;
            }
        }
        return false;
    }

    public void run() {
        CloseModelAction.closeModel(this.getResource());
    }

    protected Resource getResource() {
        return this.modelElement.eResource();
    }

    protected static void closeModel(Resource resource) {
        try {
            ModelDocument saveable = ModelManager.getManager().getModelDocument(resource);
            if (saveable != null) {
                if (saveable.isDirty()) {
                    String fileName = resource.getURI().lastSegment();
                    String message = NLS.bind((String)Messages.CloseModelAction_dialogMessage, (Object)fileName);
                    MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), Messages.CloseModelAction_dialogTitle, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int result = dialog.open();
                    if (2 == result) {
                        return;
                    }
                    if (result == 0) {
                        saveable.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                saveable.doClose((IProgressMonitor)new NullProgressMonitor());
                return;
            }
            resource.unload();
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.CloseModelAction_errorMessage, (Object[])new String[]{e.getLocalizedMessage()});
            Logger.logException(message, e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloseModelAction_errorTitle, (String)message);
        }
    }
}

