/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.notation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mdht.uml.common.notation.ClassNotationUtil;
import org.eclipse.mdht.uml.common.notation.IExtendedNotationProvider;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.mdht.uml.common.notation.NotationRegistry;
import org.eclipse.mdht.uml.common.notation.PropertyNotationUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class NotationUtil {
    public static String getPrintString(Element element) {
        INotationProvider provider;
        String text = null;
        if (element != null && (provider = NotationRegistry.INSTANCE.getNotationProvider(element)) != null) {
            text = provider.getPrintString(element);
        }
        if (text == null) {
            if (element instanceof Class) {
                text = ClassNotationUtil.getCustomLabel((Class)element, 10);
            } else if (element instanceof Property) {
                text = PropertyNotationUtil.getCustomLabel((Property)element, 252);
            }
        }
        return text;
    }

    public static Object getElementImage(Element element) {
        INotationProvider provider;
        if (element != null && (provider = NotationRegistry.INSTANCE.getNotationProvider(element)) != null) {
            return provider.getElementImage(element);
        }
        return null;
    }

    public static String getAnnotation(Element element) {
        INotationProvider provider;
        String annotation = null;
        if (element != null && (provider = NotationRegistry.INSTANCE.getNotationProvider(element)) != null) {
            annotation = provider.getAnnotation(element);
        }
        if (annotation == null) {
            if (element instanceof Class) {
                annotation = ClassNotationUtil.getCustomLabel((Class)element, 128);
            } else if (element instanceof Property) {
                annotation = PropertyNotationUtil.getCustomLabel((Property)element, 128);
            }
        }
        return annotation;
    }

    public static String getShortAnnotation(Element element) {
        String annotation = null;
        if (element != null) {
            INotationProvider provider = NotationRegistry.INSTANCE.getNotationProvider(element);
            annotation = provider instanceof IExtendedNotationProvider ? ((IExtendedNotationProvider)provider).getShortAnnotation(element) : NotationUtil.getAnnotation(element);
        }
        return annotation;
    }

    public static Object getAnnotationImage(Element element) {
        INotationProvider provider;
        if (element != null && (provider = NotationRegistry.INSTANCE.getNotationProvider(element)) != null) {
            return provider.getAnnotationImage(element);
        }
        return null;
    }

    public static List<Classifier> getTypeChoice(Property property) {
        INotationProvider provider;
        List<Classifier> types = new ArrayList<Classifier>();
        if (property != null && (provider = NotationRegistry.INSTANCE.getNotationProvider((Element)property)) instanceof IExtendedNotationProvider) {
            types = ((IExtendedNotationProvider)provider).getTypeChoice(property);
        }
        return types;
    }

    public static String getShortDescription(Element element) {
        INotationProvider provider;
        String text = null;
        if (element != null && (provider = NotationRegistry.INSTANCE.getNotationProvider(element)) instanceof IExtendedNotationProvider) {
            text = ((IExtendedNotationProvider)provider).getShortDescription(element);
        }
        return text;
    }
}

