/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.commands;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class AddLocalizedClassCommand
extends AbstractHandler {
    public static String OPT_NESTCLASS = "org.eclipse.mdht.uml.ui.commands.AddLocalizedClassCommand.nestclass";

    private void processSelection(ITreeContentProvider provider, Object selectedItem, boolean createNestClass) {
        NamedElementsStack namedElementsStack = new NamedElementsStack();
        EObject namedElement = AddLocalizedClassCommand.unwrap(selectedItem);
        Object treeElement = selectedItem;
        while (namedElement != null) {
            namedElementsStack.doSwitch(namedElement);
            treeElement = provider.getParent(treeElement);
            namedElement = AddLocalizedClassCommand.unwrap(treeElement);
        }
        if (namedElementsStack.namedElements.size() == 1 && (namedElement = AddLocalizedClassCommand.unwrap(selectedItem)) instanceof Association) {
            Association association = (Association)namedElement;
            for (Property p : association.getMemberEnds()) {
                if (!(p.getOwner() instanceof Class)) continue;
                namedElementsStack.doSwitch((EObject)p.getOwner());
                break;
            }
        }
        while (!namedElementsStack.namedElements.isEmpty() && !(namedElementsStack.namedElements.peek() instanceof Class)) {
            namedElementsStack.namedElements.pop();
        }
        Class owningClass = (Class)namedElementsStack.namedElements.pop();
        while (!namedElementsStack.namedElements.isEmpty() && namedElementsStack.namedElements.peek() instanceof Class) {
            owningClass = (Class)namedElementsStack.namedElements.pop();
        }
        boolean ifFirst = true;
        while (!namedElementsStack.namedElements.isEmpty() && namedElementsStack.namedElements.peek() instanceof Property) {
            Property property = (Property)namedElementsStack.namedElements.pop();
            Class newClass = UMLFactory.eINSTANCE.createClass();
            newClass.setName(property.getType().getName());
            if (!createNestClass && ifFirst) {
                owningClass.getNearestPackage().getOwnedTypes().add((Object)newClass);
            } else {
                owningClass.getNestedClassifiers().add((Object)newClass);
            }
            newClass.createGeneralization((Classifier)property.getType());
            if (ifFirst && property.getOwner().equals(owningClass)) {
                property.setType((Type)newClass);
            } else {
                owningClass.createAssociation(true, property.getAggregation(), property.getName(), property.getLower(), property.getUpper(), (Type)newClass, false, AggregationKind.NONE_LITERAL, "", 0, 1);
            }
            ifFirst = false;
            owningClass = newClass;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        IViewerProvider view = (IViewerProvider)activePart.getAdapter(IViewerProvider.class);
        final TreeViewer tree = (TreeViewer)view.getViewer();
        boolean createNestClass = true;
        final Object selectedObject = selection.getFirstElement();
        final TransactionalEditingDomain editingDomain = AddLocalizedClassCommand.getEditingDomain(selectedObject);
        Job j = new Job("Localise Class (Nested)"){

            public IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Localise Class (Nested)"){

                    protected void doExecute() {
                        AddLocalizedClassCommand.this.processSelection((ITreeContentProvider)tree.getContentProvider(), selectedObject, true);
                    }
                });
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                }
                monitor.done();
                return status;
            }
        };
        j.schedule();
        return null;
    }

    private static EObject unwrap(Object wrapper) {
        Object obj = null;
        if (wrapper instanceof EObject) {
            return (EObject)wrapper;
        }
        if (wrapper instanceof DelegatingWrapperItemProvider) {
            obj = ((DelegatingWrapperItemProvider)wrapper).getValue();
        } else if (wrapper instanceof UMLDomainNavigatorItem) {
            obj = ((UMLDomainNavigatorItem)wrapper).getEObject();
        } else {
            return null;
        }
        return AddLocalizedClassCommand.unwrap(obj);
    }

    private static TransactionalEditingDomain getEditingDomain(Object editingObject) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)AddLocalizedClassCommand.unwrap(editingObject));
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        }
        return editingDomain;
    }

    class NamedElementsStack
    extends UMLSwitch<Deque<NamedElement>> {
        public Deque<NamedElement> namedElements = new ArrayDeque<NamedElement>();

        NamedElementsStack() {
        }

        public Deque<NamedElement> casePackage(Package object) {
            this.namedElements.push((NamedElement)object);
            return this.namedElements;
        }

        public Deque<NamedElement> caseClass(Class object) {
            this.namedElements.push((NamedElement)object);
            return this.namedElements;
        }

        public Deque<NamedElement> caseAssociation(Association object) {
            for (Property p : object.getMemberEnds()) {
                if (!(p.getOwner() instanceof Class)) continue;
                this.namedElements.push((NamedElement)p);
            }
            return this.namedElements;
        }
    }
}

