/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.ChildrenToCopyProvider;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mdht.uml.common.modelfilter.ModelFilterUtil;
import org.eclipse.mdht.uml.common.notation.IExtendedNotationProvider;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.mdht.uml.common.notation.NotationRegistry;
import org.eclipse.mdht.uml.common.notation.NotationUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.command.CommandWrapperWithChildrenToCopy;
import org.eclipse.mdht.uml.edit.internal.Logger;
import org.eclipse.mdht.uml.edit.internal.UMLExtEditPlugin;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.edit.provider.operations.NamedElementOperations;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.edit.providers.PropertyItemProvider;

public class PropertyExtItemProvider
extends PropertyItemProvider
implements ITableItemLabelProvider,
ITableItemFontProvider,
IItemStyledLabelProvider,
ICellModifier {
    public PropertyExtItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        Property property = (Property)object;
        Object elementImage = NotationUtil.getElementImage((Element)property);
        if (elementImage == null) {
            ComposedImage composedImage = (ComposedImage)super.getImage((Object)property);
            if (ModelFilterUtil.isHidden((NamedElement)property)) {
                composedImage.getImages().add(UMLExtEditPlugin.INSTANCE.getImage("full/ovr16/filtered"));
            }
            elementImage = composedImage;
        }
        return elementImage;
    }

    protected String getName(NamedElement namedElement) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        return adapterFactory instanceof UML2ExtendedAdapterFactory && ((UML2ExtendedAdapterFactory)adapterFactory).isShowBusinessNames() ? NamedElementUtil.getBusinessName((NamedElement)namedElement) : namedElement.getName();
    }

    public String getText(Object object) {
        Property property = (Property)object;
        String name = this.getName((NamedElement)property);
        if (name == null || name.length() == 0) {
            name = this.getString("_UI_Property_type");
        }
        StringBuffer label = new StringBuffer();
        label.append(name);
        if (property.getType() != null) {
            label.append(" : ").append(this.getName((NamedElement)property.getType()));
        }
        label.append(this.displayMultiplicity((MultiplicityElement)property));
        String defaultValue = property.getDefault();
        if (defaultValue != null && defaultValue.length() > 0) {
            label.append(" = ");
            label.append(defaultValue);
        }
        return label.toString();
    }

    protected String displayMultiplicity(MultiplicityElement multElement) {
        StringBuffer multDisplay = new StringBuffer();
        if (this.checkDisplayRange(multElement)) {
            multDisplay.append(" [");
            multDisplay.append(multElement.getLower());
            multDisplay.append("..");
            multDisplay.append(multElement.getUpper() == -1 ? "*" : Integer.toString(multElement.getUpper()));
            multDisplay.append("]");
        }
        return multDisplay.toString();
    }

    protected boolean checkDisplayRange(MultiplicityElement multElement) {
        return multElement.getLower() != 1 || multElement.getUpper() != 1;
    }

    public Collection<Object> getChildren(Object object) {
        Property property = (Property)object;
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll((Collection<Object>)property.getOwnedComments());
        EReference propertyTypeRef = UMLPackage.Literals.TYPED_ELEMENT__TYPE;
        if (property.getType() instanceof Class && property.getType().getOwner() instanceof Class) {
            Class propertyType = (Class)property.getType();
            for (Property nestedProperty : propertyType.getOwnedAttributes()) {
                children.add(this.wrap((EObject)property, (EStructuralFeature)propertyTypeRef, nestedProperty, -1));
            }
            for (Object next : propertyType.getGeneralizations()) {
                children.add(this.wrap((EObject)propertyType, (EStructuralFeature)propertyTypeRef, next, -1));
            }
        }
        children.addAll((Collection<Object>)property.getClientDependencies());
        return children;
    }

    public Collection<EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
            this.childrenFeatures.add(UMLPackage.Literals.ELEMENT__OWNED_COMMENT);
            this.childrenFeatures.add(UMLPackage.Literals.PROPERTY__DEFAULT_VALUE);
        }
        return this.childrenFeatures;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(StructuralFeature.class)) {
            case 15: 
            case 19: 
            case 21: 
            case 35: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Property property = (Property)object;
        Type type = property.getType();
        switch (columnIndex) {
            case 0: {
                return this.getImage(property);
            }
            case 1: {
                IItemLabelProvider provider;
                if (type == null) break;
                Object image = null;
                INotationProvider notationProvider = NotationRegistry.INSTANCE.getNotationProvider((Element)property);
                if (notationProvider instanceof IExtendedNotationProvider) {
                    image = ((IExtendedNotationProvider)notationProvider).getElementTypeImage((Element)type);
                } else if (notationProvider != null) {
                    image = notationProvider.getElementImage((Element)type);
                }
                if (image == null && (provider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)type, IItemLabelProvider.class)) != null) {
                    image = provider.getImage((Object)type);
                }
                return image;
            }
            case 5: {
                return NotationUtil.getAnnotationImage((Element)property);
            }
        }
        return null;
    }

    public String getColumnText(Object object, int columnIndex) {
        Property property = (Property)object;
        switch (columnIndex) {
            case 0: {
                return this.getName((NamedElement)property);
            }
            case 1: {
                return property.getType() == null ? null : this.getName((NamedElement)property.getType());
            }
            case 2: {
                return PropertyExtItemProvider.displayColumnMultiplicity((MultiplicityElement)property);
            }
            case 3: {
                if (AggregationKind.NONE_LITERAL == property.getAggregation()) {
                    return "";
                }
                return property.getAggregation().getName();
            }
            case 4: {
                if (VisibilityKind.PUBLIC_LITERAL == property.getVisibility()) {
                    return "";
                }
                return property.getVisibility().getName();
            }
            case 5: {
                return NotationUtil.getAnnotation((Element)property);
            }
            case 6: {
                String text = null;
                if (property.getDefaultValue() != null) {
                    text = property.getDefaultValue().stringValue();
                }
                if (text == null) {
                    text = NotationUtil.getShortDescription((Element)property);
                }
                return text == null ? "" : text;
            }
        }
        return null;
    }

    public Object getFont(Object object) {
        return null;
    }

    public Object getFont(Object object, int columnIndex) {
        Property property = (Property)object;
        switch (columnIndex) {
            case 0: {
                if (property.upperBound() != 0) break;
                return BOLD_ITALIC_FONT;
            }
        }
        return null;
    }

    public Object getStyledText(Object object) {
        StyledString.Style strikeoutStyle = StyledString.Style.newBuilder().setStrikedout(true).toStyle();
        return new StyledString(this.getText(object), strikeoutStyle);
    }

    protected static String displayColumnMultiplicity(MultiplicityElement multElement) {
        if (multElement == null) {
            return "";
        }
        StringBuffer multDisplay = new StringBuffer();
        multDisplay.append(multElement.getLower());
        multDisplay.append("..");
        multDisplay.append(multElement.getUpper() == -1 ? "*" : Integer.toString(multElement.getUpper()));
        return multDisplay.toString();
    }

    public boolean canModify(Object element, String property) {
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return true;
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return true;
        }
        if ("multiplicity".equals(property)) {
            return true;
        }
        if (IUMLTableProperties.AGGREGATION_PROPERTY.equals(property)) {
            return true;
        }
        if (IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            return true;
        }
        if ("annotation".equals(property)) {
            return false;
        }
        return IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property);
    }

    public Object getValue(Object element, String property) {
        Property umlProperty = (Property)element;
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return umlProperty.getName();
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return umlProperty.getType();
        }
        if ("multiplicity".equals(property)) {
            return PropertyExtItemProvider.displayColumnMultiplicity((MultiplicityElement)umlProperty);
        }
        if (IUMLTableProperties.AGGREGATION_PROPERTY.equals(property)) {
            return new Integer(umlProperty.getAggregation().getValue());
        }
        if (IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            return new Integer(umlProperty.getVisibility().getValue());
        }
        if (IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property)) {
            if (umlProperty.getDefaultValue() != null) {
                return umlProperty.getDefaultValue().stringValue();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, final String property, final Object value) {
        final Property umlProperty = (Property)element;
        if (IUMLTableProperties.NAME_PROPERTY.equals(property) || IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            NamedElementOperations.modify(element, property, value);
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)umlProperty);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (IUMLTableProperties.TYPE_PROPERTY.equals(property) && value instanceof Classifier) {
                        this.setLabel("Set Type");
                        umlProperty.setType((Type)((Classifier)value));
                    } else if (IUMLTableProperties.AGGREGATION_PROPERTY.equals(property) && value instanceof Integer) {
                        this.setLabel("Set Aggregation");
                        umlProperty.setAggregation(AggregationKind.get((int)((Integer)value)));
                    } else if (IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property) && value instanceof String) {
                        String newValue;
                        this.setLabel("Set Default Value");
                        if (umlProperty.getDefaultValue() != null) {
                            umlProperty.getDefaultValue().destroy();
                        }
                        if ((newValue = (String)value) != null && newValue.trim().length() > 0) {
                            LiteralString literal = UMLFactory.eINSTANCE.createLiteralString();
                            literal.setValue(newValue);
                            umlProperty.setDefaultValue((ValueSpecification)literal);
                        }
                    } else if ("multiplicity".equals(property) && value instanceof String) {
                        this.setLabel("Set Multiplicity");
                        PropertyExtItemProvider.setMultiplicity((MultiplicityElement)umlProperty, value.toString());
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected static void setMultiplicity(MultiplicityElement multiplicityElement, String value) {
        int lower = 1;
        int upper = 1;
        StringTokenizer stk = new StringTokenizer(value, ". ");
        if (stk.hasMoreTokens()) {
            lower = PropertyExtItemProvider.parseMultiplicityRangeToken(stk.nextToken());
            if (!stk.hasMoreTokens()) {
                if (lower == -1) {
                    lower = 0;
                    upper = -1;
                } else {
                    upper = lower;
                }
            } else {
                upper = PropertyExtItemProvider.parseMultiplicityRangeToken(stk.nextToken());
                if (stk.hasMoreTokens()) {
                    throw new IllegalArgumentException("illegal range specification: " + value);
                }
            }
        }
        if (multiplicityElement.getLowerValue() != null) {
            multiplicityElement.getLowerValue().destroy();
        }
        if (multiplicityElement.getUpperValue() != null) {
            multiplicityElement.getUpperValue().destroy();
        }
        multiplicityElement.setUpper(upper);
        multiplicityElement.setLower(lower);
    }

    protected static int parseMultiplicityRangeToken(String token) {
        block3: {
            try {
                if (!token.equalsIgnoreCase("n") && !token.equals("*") && !token.equalsIgnoreCase("unbounded")) break block3;
                return -1;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("illegal range bound: " + token);
            }
        }
        return Integer.parseInt(token);
    }

    protected Command wrapCommand(Command command, Object object, java.lang.Class<? extends Command> commandClass, CommandParameter commandParameter, CommandParameter oldCommandParameter) {
        Object result = super.wrapCommand(command, object, commandClass, commandParameter, oldCommandParameter);
        if (result != command && command instanceof ChildrenToCopyProvider) {
            result = new CommandWrapperWithChildrenToCopy((Command)result, (ChildrenToCopyProvider)command);
        }
        return result;
    }
}

