/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TransformAbstract;
import org.eclipse.mdht.uml.cda.dita.internal.Logger;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;

public class TransformValueSet
extends TransformAbstract {
    public TransformValueSet(DitaTransformerOptions options) {
        super(options);
    }

    public String getDefinition(Enumeration enumeration) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<section id=\"definition\">");
        this.appendDefinition(pw, enumeration);
        this.appendConcepts(pw, enumeration);
        pw.println("</section>");
        return sw.toString();
    }

    private void appendBody(PrintWriter writer, Enumeration umlEnumeration) {
        writer.println("<body>");
        writer.println("<!-- THIS IS GENERATED CONTENT, DO NOT EDIT -->");
        writer.println("<section id=\"definition\">");
        this.appendDefinition(writer, umlEnumeration);
        this.appendConcepts(writer, umlEnumeration);
        writer.println("</section>");
        writer.println("</body>");
        writer.println("</topic>");
    }

    private void appendConcepts(PrintWriter writer, Enumeration umlEnumeration) {
        String codeSystemName = null;
        ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)umlEnumeration);
        if (valueSetVersion != null && valueSetVersion.getCodeSystem() != null && !valueSetVersion.getCodeSystem().eIsProxy()) {
            codeSystemName = valueSetVersion.getCodeSystem().getBase_Enumeration().getName();
        }
        if (!umlEnumeration.getOwnedLiterals().isEmpty()) {
            writer.println(this.getTableType());
            if (this.transformerOptions.isIncludeUsageNotes()) {
                writer.println("<tgroup cols=\"4\">");
                writer.println("<colspec colname=\"col1\" colwidth=\"1*\"/>");
                writer.println("<colspec colname=\"col2\" colwidth=\"1*\"/>");
                writer.println("<colspec colname=\"col3\" colwidth=\"1*\"/>");
                writer.println("<colspec colname=\"col4\" colwidth=\"2*\"/>");
                writer.println("<thead><row>");
                writer.println("<entry>Code</entry><entry>Code System</entry><entry>Print Name</entry><entry>Usage Note</entry>");
                writer.println("</row></thead><tbody>");
            } else {
                writer.println("<tgroup cols=\"3\">");
                writer.println("<colspec colname=\"col1\" colwidth=\"1*\"/>");
                writer.println("<colspec colname=\"col2\" colwidth=\"1*\"/>");
                writer.println("<colspec colname=\"col3\" colwidth=\"2*\"/>");
                writer.println("<thead><row>");
                writer.println("<entry>Code</entry><entry>Code System</entry><entry>Print Name</entry>");
                writer.println("</row></thead><tbody>");
            }
            for (EnumerationLiteral literal : umlEnumeration.getOwnedLiterals()) {
                ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)literal);
                writer.print("<row>");
                writer.print("<entry>" + literal.getName() + "</entry>");
                writer.print("<entry>");
                if (valueSetCode != null && valueSetCode.getCodeSystem() != null) {
                    if (valueSetCode.getCodeSystem().getBase_Enumeration() != null) {
                        writer.print(valueSetCode.getCodeSystem().getBase_Enumeration().getName());
                    } else {
                        Logger.log(4, "VALUE SET LITERAL MISSING CODE SYSTEM " + valueSetVersion.getFullName() + "  " + valueSetCode.getBase_EnumerationLiteral().getName());
                        writer.print("MISSING");
                    }
                } else if (codeSystemName != null) {
                    writer.print(codeSystemName);
                }
                writer.print("</entry>");
                writer.print("<entry>");
                if (valueSetCode != null && valueSetCode.getConceptName() != null) {
                    writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetCode.getConceptName()));
                }
                writer.print("</entry>");
                if (this.transformerOptions.isIncludeUsageNotes()) {
                    writer.print("<entry>");
                    if (valueSetCode != null && valueSetCode.getUsageNote() != null) {
                        writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetCode.getUsageNote()));
                    }
                    writer.print("</entry>");
                }
                writer.println("</row>");
            }
            writer.println("</tbody></tgroup></table>");
        }
    }

    private String getTableType() {
        return this.transformerOptions.isNoVerticalLinesInTables() ? "<table frame=\"topbot\" rowsep=\"1\">" : "<table frame=\"all\" rowsep=\"1\" colsep=\"1\">";
    }

    private void appendDefinition(PrintWriter writer, Enumeration umlEnumeration) {
        writer.println(this.getTableType());
        writer.println("<tgroup cols=\"2\">");
        writer.println("<colspec colname=\"col1\" colwidth=\"1*\"/>");
        writer.println("<colspec colname=\"col2\" colwidth=\"4*\"/>");
        writer.println("<tbody>");
        ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)umlEnumeration);
        if (valueSetVersion != null) {
            String valueSetId = valueSetVersion.getIdentifier() != null ? valueSetVersion.getIdentifier() : "(OID not specified)";
            writer.print("<row><entry>Value Set</entry><entry>");
            writer.print(umlEnumeration.getName());
            writer.print(" - " + valueSetId);
            writer.println("</entry></row>");
            if (valueSetVersion.getCodeSystem() != null) {
                if (valueSetVersion.getCodeSystem().eIsProxy()) {
                    System.err.println("Cannot load Code System ref from: " + umlEnumeration.getQualifiedName());
                } else {
                    String codeSystemId = valueSetVersion.getCodeSystem().getIdentifier() != null ? valueSetVersion.getCodeSystem().getIdentifier() : "(OID not specified)";
                    writer.print("<row><entry>Code System</entry><entry>");
                    writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetVersion.getCodeSystem().getBase_Enumeration().getName()));
                    writer.print(" - " + codeSystemId);
                    writer.println("</entry></row>");
                }
            }
            if (valueSetVersion.getVersion() != null) {
                writer.print("<row><entry>Version</entry><entry>");
                writer.print(valueSetVersion.getVersion());
                writer.println("</entry></row>");
            }
            if (valueSetVersion.getSource() != null) {
                writer.print("<row><entry>Source</entry><entry>");
                writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetVersion.getSource()));
                writer.println("</entry></row>");
            }
            if (valueSetVersion.getUrl() != null) {
                writer.print("<row><entry>Source URL</entry><entry>");
                writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetVersion.getUrl()));
                writer.println("</entry></row>");
            }
            if (valueSetVersion.getDefinition() != null) {
                writer.print("<row><entry>Definition</entry><entry>");
                writer.print(CDAModelUtil.fixNonXMLCharacters((String)valueSetVersion.getDefinition()));
                writer.println("</entry></row>");
            }
        } else {
            writer.print("<row><entry>Value Set</entry><entry>");
            writer.print(umlEnumeration.getName());
            writer.println("</entry></row>");
        }
        for (Comment comment : umlEnumeration.getOwnedComments()) {
            writer.print("<row><entry>Description</entry><entry>");
            writer.println(comment.getBody());
            writer.println("</entry></row>");
        }
        writer.println("</tbody></tgroup></table>");
    }

    private static void appendHeader(PrintWriter writer, Enumeration umlEnumeration) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        writer.println("<topic id=\"classId\" xml:lang=\"en-us\">");
        writer.print("<title>");
        writer.print(TransformAbstract.getPublicationName((NamedElement)umlEnumeration));
        writer.println("</title>");
        ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)umlEnumeration);
        String valueSetId = valueSetVersion != null && valueSetVersion.getIdentifier() != null ? valueSetVersion.getIdentifier() : "not specified";
        writer.println("<prolog id=\"prolog\">");
        if (valueSetVersion != null) {
            writer.println("<resourceid id=\"" + valueSetId + "\"/>");
        }
        writer.println("</prolog>");
    }

    public Object caseEnumeration(Enumeration umlEnumeration) {
        String fileName;
        block11: {
            fileName = String.valueOf(TransformValueSet.normalizeCodeName(umlEnumeration.getName())) + ".dita";
            if (this.transformerOptions.getValueSetList().contains(fileName)) {
                return umlEnumeration;
            }
            String pathFolder = "terminology";
            IPath filePath = this.transformerOptions.getOutputPath().append(pathFolder).addTrailingSeparator().append(fileName);
            File file = filePath.toFile();
            PrintWriter writer = null;
            try {
                file.createNewFile();
                writer = new PrintWriter(file);
                TransformValueSet.appendHeader(writer, umlEnumeration);
                this.appendBody(writer, umlEnumeration);
            }
            catch (FileNotFoundException e) {
                Logger.logException(e);
                if (writer != null) {
                    writer.close();
                }
                break block11;
            }
            catch (IOException e1) {
                try {
                    Logger.logException(e1);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            if (writer != null) {
                writer.close();
            }
        }
        this.transformerOptions.getValueSetList().add(fileName);
        return umlEnumeration;
    }
}

