/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceComment;
import traceability.TraceDiffs;
import traceability.TraceabilityFactory;
import traceability.presentation.ReuseURIEditorInput;
import traceability.presentation.TraceUtils;
import traceability.presentation.TraceabilityEditorPlugin;
import traceability.presentation.TraceabilityModelWizard;
import traceability.presentation.Tracing;
import traceability.presentation.table.TraceabilityViewer;
import traceability.presentation.table.TraceabilityViewerContentProvider;
import traceability.presentation.table.TraceabilityViewerFactory;
import traceability.presentation.table.TraceabilityViewerLabelProvider;
import traceability.provider.TraceabilityItemProviderAdapterFactory;
import traceability.util.TraceabilityUtils;

public abstract class TraceabilityEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IDoubleClickListener,
ISelectionListener,
ISetSelectionTarget {
    public static final List<String> FILE_EXTENSION_FILTERS = TraceabilityEditor.prefixExtensions(TraceabilityModelWizard.FILE_EXTENSIONS, "*.");
    public Collection<TraceabilityViewer> ALL_TABLES = new ArrayList<TraceabilityViewer>();
    public boolean traceabilityFilters_EQ = false;
    public boolean traceabilityFilters_NEQ = true;
    public boolean traceabilityFilters_PLUS = true;
    public boolean traceabilityFilters_MINUS = true;
    public boolean traceabilityFilters_ERR = false;
    public boolean traceabilityFilters_ALL = false;
    public boolean traceabilityFilters_TREE = true;
    public static String DIFF_UNEQUAL = "\u01c2";
    public static String DIFF_EQUAL = "=";
    public static final Color COLOR_UNEQUAL = new Color((Device)Display.getDefault(), 255, 255, 0);
    public static final Color COLOR_PLUS = new Color((Device)Display.getDefault(), 202, 255, 202);
    public static final Color COLOR_MINUS = new Color((Device)Display.getDefault(), 255, 202, 202);
    public static final Color COLOR_SEARCHFOREGROUND = new Color((Device)Display.getDefault(), 255, 255, 255);
    public static final Color COLOR_SEARCHBACKGROUND = new Color((Device)Display.getDefault(), 0, 150, 0);
    public static final Color COLOR_SELECTED = new Color((Device)Display.getDefault(), 218, 218, 218);
    public static final Color COLOR_HOT = new Color((Device)Display.getDefault(), 234, 234, 234);
    public static final Color COLOR_LINK = new Color((Device)Display.getDefault(), 0, 0, 155);
    public EObject newTraceSource;
    public String newTraceSourceLabel;
    public XViewerColumn newTraceSourceColumn;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ListViewer listViewer;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewerWithColumns;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == TraceabilityEditor.this.contentOutlinePage) {
                    TraceabilityEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)TraceabilityEditor.this);
                    TraceabilityEditor.this.setCurrentViewer((Viewer)TraceabilityEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (TraceabilityEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    TraceabilityEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)TraceabilityEditor.this);
                    TraceabilityEditor.this.handleActivate();
                }
            } else if (p == TraceabilityEditor.this) {
                TraceabilityEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = TraceabilityEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            TraceabilityEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            TraceabilityEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!TraceabilityEditor.this.updateProblemIndication) return;
                        TraceabilityEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TraceabilityEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            TraceabilityEditor.this.resourceToDiagnosticMap.remove(target);
            if (TraceabilityEditor.this.updateProblemIndication) {
                TraceabilityEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TraceabilityEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected boolean showDiffControls;
    protected TraceDiffs traceDiffs;
    protected int tabEMFTree;
    protected Tracing tracing;

    private static List<String> prefixExtensions(List<String> extensions, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String extension : extensions) {
            result.add(String.valueOf(prefix) + extension);
        }
        return Collections.unmodifiableList(result);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.mdht.metamodel.traceability.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    TraceabilityEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)this.getString("_UI_FileConflict_label"), (String)this.getString("_WARN_FileConflict"));
    }

    public TraceabilityEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new TraceabilityItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                TraceabilityEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TraceabilityEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            TraceabilityEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).TraceabilityEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap()){
            {
                this.resourceSet = new AdapterFactoryEditingDomain.AdapterFactoryEditingDomainResourceSet(this){

                    public Resource getResource(URI uri, boolean loadOnDemand) {
                        if (uri.toString().contains("///")) {
                            uri = URI.createURI((String)uri.toString().replace("///", "/"));
                        }
                        return super.getResource(uri, loadOnDemand);
                    }
                };
            }
        };
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (TraceabilityEditor.this.currentViewer != null) {
                        TraceabilityEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            TraceabilityViewer v;
            ISelection sel;
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        TraceabilityEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            if (this.currentViewer instanceof TraceabilityViewer && viewer == this.selectionViewer && !(sel = (v = (TraceabilityViewer)this.currentViewer).getSelection()).isEmpty() && sel instanceof StructuredSelection && v.getClickedColumn() != null) {
                StructuredSelection structuredSelection = (StructuredSelection)sel;
                XViewerColumn xCol = (XViewerColumn)v.getClickedColumn().getData();
                EObject ob = this.getColumnSpecificElement(xCol, structuredSelection.getFirstElement());
                if (v.tracing.getTraceDiff(ob) != null) {
                    this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)v.tracing.getTraceDiff(ob)));
                } else if (v.tracing.getTrace(ob) != null) {
                    this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)v.tracing.getTrace(ob)));
                } else if (ob instanceof LogEntry) {
                    this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)ob));
                }
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            if (this.getEditorInput() instanceof ReuseURIEditorInput) {
                ReuseURIEditorInput tempURIEditorInput = (ReuseURIEditorInput)this.getEditorInput();
                this.editingDomain.getResourceSet().getResources().addAll((Collection)tempURIEditorInput.getResourceSet().getResources());
            }
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.mdht.metamodel.traceability.editor", 0, TraceabilityEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.mdht.metamodel.traceability.editor", 0, TraceabilityEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            for (EObject eObject : ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents()) {
                if (!(eObject instanceof TraceDiffs)) continue;
                this.traceDiffs = (TraceDiffs)eObject;
                this.showDiffControls = true;
            }
            this.createViews();
            if (!this.includeView("EMF Tree")) {
                this.tabEMFTree = -1;
            } else {
                ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                    public Viewer createViewer(Composite composite) {
                        Tree tree = new Tree(composite, 2);
                        TreeViewer newTreeViewer = new TreeViewer(tree);
                        return newTreeViewer;
                    }

                    public void requestActivation() {
                        super.requestActivation();
                        TraceabilityEditor.this.setCurrentViewer(this.getViewer());
                    }
                };
                viewerPane.createControl(this.getContainer());
                PlatformUI.getWorkbench().getHelpSystem().setHelp(viewerPane.getControl(), "org.eclipse.mdht.metamodel.traceability.editor.EMFTree");
                this.selectionViewer = (TreeViewer)viewerPane.getViewer();
                this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
                this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
                this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
                viewerPane.setTitle((Object)this.editingDomain.getResourceSet());
                new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
                this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        TraceUtils.doubleClick(event, TraceabilityEditor.this);
                    }
                });
                this.createContextMenuFor((StructuredViewer)this.selectionViewer);
                int pageIndex = this.addPage(viewerPane.getControl());
                this.setPageText(pageIndex, this.getString("_UI_SelectionPage_label"));
                this.tabEMFTree = pageIndex;
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TraceabilityEditor.this.getPageCount() > 0) {
                        TraceabilityEditor.this.setActivePage(0);
                    }
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    TraceabilityEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TraceabilityEditor.this.updateProblemIndication();
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected abstract void createViews();

    protected int createView(String tabName, final int autoExpandLevel, String help, final XViewerColumn ... columns) {
        if (!this.includeView(tabName)) {
            return -1;
        }
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1840));
        if (help != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mdht.metamodel.traceability.editor." + help);
        }
        TraceabilityViewer viewer = new TraceabilityViewer(this, composite, 67586, new TraceabilityViewerFactory(this.getNamespace(), autoExpandLevel != -1, this.getAllColumns(), columns));
        this.ALL_TABLES.add(viewer);
        if (autoExpandLevel != -1) {
            viewer.setAutoExpandLevel(autoExpandLevel);
        }
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new TraceabilityViewerContentProvider(viewer){

            @Override
            protected void organizeTree() {
                if (autoExpandLevel == -1 || columns.length == 0) {
                    return;
                }
                TraceabilityEditor.this.organizeTreeForColumn(columns[0], this.parents);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new TraceabilityViewerLabelProvider(viewer));
        this.createFilters(composite, viewer);
        int pageIndex = this.addPage((Control)composite);
        this.setPageText(pageIndex, tabName);
        return pageIndex;
    }

    public abstract String getNamespace();

    protected abstract void organizeTreeForColumn(XViewerColumn var1, List<Object> var2);

    protected boolean includeView(String tabName) {
        String showTraceViews = System.getProperty("showTraceViews");
        if (showTraceViews != null) {
            String normalizedShowTraceViews = showTraceViews.replace(" ", "").toLowerCase();
            String normalizedTabName = tabName.replace(" ", "").toLowerCase();
            if (!Arrays.asList(normalizedShowTraceViews.split(",")).contains(normalizedTabName)) {
                return false;
            }
        }
        return true;
    }

    public void updateTables() {
        for (TraceabilityViewer table : this.ALL_TABLES) {
            if (table.getControl().isDisposed()) continue;
            table.updateRows();
        }
    }

    private void createFilters(Composite composite, final TraceabilityViewer viewer) {
        composite.setData((Object)viewer);
        Composite traceabilityFilters = new Composite(composite, 0);
        GridLayout layout = new GridLayout(10, false);
        layout.horizontalSpacing = 50;
        traceabilityFilters.setLayout((Layout)layout);
        final Button errButton = viewer.errButton = new Button(traceabilityFilters, 32);
        errButton.setToolTipText("Show rows with errors only (see Error column)");
        errButton.setText("E");
        errButton.setSelection(this.traceabilityFilters_ERR);
        errButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceabilityEditor.this.traceabilityFilters_ERR = errButton.getSelection();
                TraceabilityEditor.this.updateTables();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)errButton, "org.eclipse.mdht.metamodel.traceability.editor.tablecustomization");
        final Button allButton = viewer.allButton = new Button(traceabilityFilters, 32);
        allButton.setToolTipText("Show all values (i.e. do not blank out repetitions)");
        allButton.setText("A");
        allButton.setSelection(this.traceabilityFilters_ALL);
        allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceabilityEditor.this.traceabilityFilters_ALL = allButton.getSelection();
                TraceabilityEditor.this.updateTables();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)allButton, "org.eclipse.mdht.metamodel.traceability.editor.tablecustomization");
        final Button treeButton = viewer.treeButton = new Button(traceabilityFilters, 32);
        treeButton.setToolTipText("Enable trees");
        treeButton.setText("T");
        treeButton.setSelection(this.traceabilityFilters_TREE);
        treeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TraceabilityEditor.this.traceabilityFilters_TREE = treeButton.getSelection();
                TraceabilityEditor.this.updateTables();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)treeButton, "org.eclipse.mdht.metamodel.traceability.editor.tablecustomization");
        if (this.showDiffControls) {
            final Button equalButton = viewer.equalButton = new Button(traceabilityFilters, 32);
            equalButton.setToolTipText("Show traces common in all models with equal attribute values");
            equalButton.setText(DIFF_EQUAL);
            equalButton.setSelection(this.traceabilityFilters_EQ);
            equalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TraceabilityEditor.this.traceabilityFilters_EQ = equalButton.getSelection();
                    TraceabilityEditor.this.updateTables();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)equalButton, "org.eclipse.mdht.metamodel.traceability.editor.tracedifffiltering");
            final Button unequalButton = viewer.unequalButton = new Button(traceabilityFilters, 32);
            unequalButton.setToolTipText("Show traces common in all models but differing in at least attribute value");
            unequalButton.setText(DIFF_UNEQUAL);
            unequalButton.setSelection(this.traceabilityFilters_NEQ);
            unequalButton.setBackground(COLOR_UNEQUAL);
            unequalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TraceabilityEditor.this.traceabilityFilters_NEQ = unequalButton.getSelection();
                    TraceabilityEditor.this.updateTables();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)unequalButton, "org.eclipse.mdht.metamodel.traceability.editor.tracedifffiltering");
            final Button plusButton = viewer.plusButton = new Button(traceabilityFilters, 32);
            if (this.traceDiffs.getComparedTraces().size() > 0) {
                plusButton.setToolTipText("Show traces of " + TraceUtils.withoutTags(TraceabilityUtils.getProjectName((EObject)((EObject)this.traceDiffs.getComparedTraces().get(0)))));
            }
            plusButton.setText("+");
            plusButton.setSelection(this.traceabilityFilters_PLUS);
            plusButton.setBackground(COLOR_PLUS);
            plusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TraceabilityEditor.this.traceabilityFilters_PLUS = plusButton.getSelection();
                    TraceabilityEditor.this.updateTables();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)plusButton, "org.eclipse.mdht.metamodel.traceability.editor.tracedifffiltering");
            final Button minusButton = viewer.minusButton = new Button(traceabilityFilters, 32);
            if (1 < this.traceDiffs.getComparedTraces().size()) {
                minusButton.setToolTipText("Show traces of " + TraceUtils.withoutTags(TraceabilityUtils.getProjectName((EObject)((EObject)this.traceDiffs.getComparedTraces().get(1)))));
            }
            minusButton.setText("-");
            minusButton.setSelection(this.traceabilityFilters_MINUS);
            minusButton.setBackground(COLOR_MINUS);
            minusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TraceabilityEditor.this.traceabilityFilters_MINUS = minusButton.getSelection();
                    TraceabilityEditor.this.updateTables();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)minusButton, "org.eclipse.mdht.metamodel.traceability.editor.tracedifffiltering");
        }
        Composite filterControls = new Composite(traceabilityFilters, 0);
        layout = new GridLayout(4, false);
        layout.horizontalSpacing = 6;
        filterControls.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)filterControls, "org.eclipse.mdht.metamodel.traceability.editor.filterexpression");
        Label label = new Label(filterControls, 0);
        label.setText("Filter:");
        GridData gd = new GridData(131072, 0, false, false);
        label.setLayoutData((Object)gd);
        final Text filterText = new Text(filterControls, 2052);
        gd = new GridData(131072, 0, false, false);
        gd.widthHint = 100;
        filterText.setLayoutData((Object)gd);
        final Button regularExpression = new Button(filterControls, 32);
        filterText.setToolTipText("Filter rows by a search string");
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                boolean filterRealTime = false;
                if (e.keyCode == 13 || e.keyCode == 0x1000050 || filterRealTime) {
                    viewer.setFilterText(filterText.getText(), regularExpression.getSelection());
                    viewer.expandAll();
                }
            }
        });
        this.fixClipboardOperations(filterText);
        regularExpression.setText("RE");
        regularExpression.setToolTipText("Enable as regular expression");
        regularExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        regularExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.setFilterText(filterText.getText(), regularExpression.getSelection());
            }
        });
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        String query = resource.getURI().query();
        if (query != null) {
            String[] stringArray = query.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String queryPart = stringArray[n2];
                String[] pair = queryPart.split("=");
                if (pair.length == 2) {
                    String name = pair[0];
                    String value = pair[1];
                    if ("filter".equals(name)) {
                        filterText.setText(value);
                        viewer.setFilterText(filterText.getText(), regularExpression.getSelection());
                    }
                    if ("re".equals(name)) {
                        regularExpression.setSelection(Boolean.valueOf(value).booleanValue());
                        viewer.setFilterText(filterText.getText(), regularExpression.getSelection());
                    }
                }
                ++n2;
            }
        }
        filterControls = new Composite(traceabilityFilters, 0);
        layout = new GridLayout(4, false);
        layout.horizontalSpacing = 6;
        filterControls.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)filterControls, "org.eclipse.mdht.metamodel.traceability.editor.searchexpression");
        label = new Label(filterControls, 0);
        label.setText("Search:");
        gd = new GridData(131072, 0, false, false);
        label.setLayoutData((Object)gd);
        filterText = new Text(filterControls, 2052);
        gd = new GridData(131072, 0, false, false);
        gd.widthHint = 100;
        filterText.setLayoutData((Object)gd);
        filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 262144 && event.keyCode == 103) {
                    ++viewer.searchRowsIndex;
                    if (viewer.searchRowsIndex == viewer.searchRows.size()) {
                        viewer.searchRowsIndex = 0;
                    }
                    if (viewer.searchRowsIndex < viewer.searchRows.size()) {
                        viewer.setSelection((ISelection)new StructuredSelection(viewer.searchRows.get(viewer.searchRowsIndex)), true);
                    }
                    event.doit = false;
                }
            }
        });
        this.fixClipboardOperations(filterText);
        regularExpression = new Button(filterControls, 32);
        filterText.setToolTipText("Search rows by a search string");
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                boolean filterRealTime = false;
                if (e.keyCode == 13 || e.keyCode == 0x1000050 || filterRealTime) {
                    viewer.setSearchText(filterText.getText(), regularExpression.getSelection());
                }
            }
        });
        regularExpression.setText("RE");
        regularExpression.setToolTipText("Enable as regular expression");
        regularExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        regularExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.setSearchText(filterText.getText(), regularExpression.getSelection());
            }
        });
    }

    private void fixClipboardOperations(final Text text) {
        text.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (((event.stateMask & 0x40000) == 262144 || (event.stateMask & 0x400000) == 0x400000) && event.keyCode == 118) {
                    text.paste();
                }
                if (((event.stateMask & 0x40000) == 262144 || (event.stateMask & 0x400000) == 0x400000) && event.keyCode == 99) {
                    text.copy();
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, this.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        Composite composite;
        super.pageChange(pageIndex);
        Object selectedPage = this.getSelectedPage();
        if (selectedPage instanceof Composite && (composite = (Composite)selectedPage).getData() instanceof Viewer) {
            Viewer viewer = (Viewer)composite.getData();
            if (viewer.getInput() == null) {
                viewer.setInput(this.getOrCreateTracing());
            }
            this.setCurrentViewer(viewer);
        }
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    protected final Object getOrCreateTracing() {
        if (this.tracing == null) {
            this.tracing = this.createTracing();
        }
        return this.tracing;
    }

    protected Tracing createTracing() {
        Tracing result = new Tracing(this.getInput());
        return result;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    TraceabilityEditor.this.contentOutlineViewer = this.getTreeViewer();
                    TraceabilityEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    TraceabilityEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)TraceabilityEditor.this.adapterFactory));
                    TraceabilityEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)TraceabilityEditor.this.adapterFactory));
                    TraceabilityEditor.this.contentOutlineViewer.setInput((Object)TraceabilityEditor.this.editingDomain.getResourceSet());
                    TraceabilityEditor.this.createContextMenuFor((StructuredViewer)TraceabilityEditor.this.contentOutlineViewer);
                    if (!TraceabilityEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        TraceabilityEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(TraceabilityEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    TraceabilityEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    TraceabilityEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TraceabilityEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

            public void setSelectionToViewer(List<?> selection) {
                TraceabilityEditor.this.setSelectionToViewer(selection);
                TraceabilityEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                TraceabilityEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : TraceabilityEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !TraceabilityEditor.this.isPersisted(resource) || TraceabilityEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            TraceabilityEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        TraceabilityEditor.this.resourceToDiagnosticMap.put(resource, TraceabilityEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            TraceabilityEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        new ResourceDialog(this.getSite().getShell(), null, 0){

            protected boolean isSave() {
                return true;
            }

            protected boolean processResources() {
                List uris = this.getURIs();
                if (uris.size() > 0) {
                    URI uri = (URI)uris.get(0);
                    TraceabilityEditor.this.doSaveAs(uri, (IEditorInput)new URIEditorInput(uri));
                    return true;
                }
                return false;
            }
        }.open();
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(this.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(TraceabilityEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(TraceabilityEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    protected String getString(String key) {
        return TraceabilityEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return TraceabilityEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.getActivePage() != -1) {
            TraceUtils.doubleClick(event, this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TraceUtils.selectionChanged(part, selection, this);
    }

    public void selectReveal(ISelection selection) {
        this.setSelectionToViewer(((IStructuredSelection)selection).toList());
    }

    public void activateEMFTree() {
        if (this.tabEMFTree != -1) {
            this.setActivePage(this.tabEMFTree);
        }
    }

    protected Resource getInput() {
        return (Resource)this.editingDomain.getResourceSet().getResources().get(0);
    }

    public void openElement(Object element, XViewerColumn xCol, Object toOpen) {
        if (toOpen instanceof EObject) {
            EObject eObject = (EObject)toOpen;
            if (this.getInput() == eObject.eResource()) {
                this.activateEMFTree();
            } else {
                TraceUtils.doubleClickFromSelf(Arrays.asList(eObject));
            }
        }
    }

    public List<XViewerColumn> getCols() {
        return Collections.emptyList();
    }

    protected abstract List<XViewerColumn> getAllColumns();

    public <T> T findType(Class<T> cls, Object element) {
        return this.tracing.findType(cls, element);
    }

    public abstract XViewerColumn getRedirectedColumn(Object var1, XViewerColumn var2);

    public XViewerColumn getSourceColumn(XViewerColumn viewerColumn) {
        return viewerColumn;
    }

    public abstract Object getCellData(XViewerColumn var1, Object var2);

    public Action manageComment(XViewerColumn xCol, EObject eObject, Trace trace, EObject fnarrowDown) {
        return null;
    }

    protected IInputValidator getCommentValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.trim().length() == 0 ? " " : null;
            }
        };
    }

    protected void setComment(Trace trace, String comment, XViewerColumn clinicalSafetyIssue_Col, EObject narrowDown) {
        TraceComment tc = TraceabilityFactory.eINSTANCE.createTraceComment();
        tc.setComment(comment);
        tc.setDate(new Date());
        tc.setUsername(TraceabilityUtils.getUsername());
        tc.setColumn(clinicalSafetyIssue_Col.getId());
        tc.setNarrowDown(narrowDown);
        trace.getComments().add((Object)tc);
        try {
            trace.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateTables();
    }

    public abstract List<XViewerColumn> excludedColsFromDiffing();

    public XViewerColumn getColForDiffing(XViewerColumn xCol) {
        return xCol;
    }

    public boolean isErrorCol(XViewerColumn xCol) {
        return false;
    }

    public abstract String getLabel(Object var1, XViewerColumn var2, int var3);

    public List<XViewerColumn> alwaysPrintColumns() {
        return Collections.emptyList();
    }

    public String adjustStyledText(XViewerColumn col, Object element, String text) {
        return text;
    }

    public EObject getNarrowDown(XViewerColumn xCol, Object element) {
        XViewerColumn sCol = this.getSourceColumn(xCol);
        int index = this.getCols().indexOf(sCol);
        Object narrowDown = null;
        if (index != -1 && index + 1 < this.getCols().size()) {
            XViewerColumn narrowDownCol = this.getCols().get(index + 1);
            narrowDown = this.getCellData(narrowDownCol, element);
        }
        EObject fnarrowDown = narrowDown instanceof EObject ? (EObject)narrowDown : null;
        return fnarrowDown;
    }

    public EObject getColumnSpecificElement(XViewerColumn viewerColumn, Object element) {
        Object obj = this.getCellData(this.getSourceColumn(viewerColumn), element);
        if (obj instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }

    public Image getImage(Object element) {
        EObject eObject;
        Adapter provider;
        if (element instanceof EObject && (provider = this.adapterFactory.adapt((Notifier)(eObject = (EObject)element), IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            IItemLabelProvider iItemLabelProvider = (IItemLabelProvider)provider;
            return ExtendedImageRegistry.INSTANCE.getImage(iItemLabelProvider.getImage((Object)eObject));
        }
        return null;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

