/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class GreenDatatypesUtil {
    public static final String GREEN_DATATYPES_FILE_NAME = "green_datatypes.uml";
    private Package greenDatatypes = null;

    public void loadGreenDatatypesFromBase(ResourceSet resourceSet, URI uriBase) {
        URI greenURI = uriBase.appendSegment(GREEN_DATATYPES_FILE_NAME);
        Resource resource = resourceSet.getResource(greenURI, true);
        if (resource.getContents().size() > 0) {
            this.greenDatatypes = (Package)resource.getContents().get(0);
        }
    }

    public Classifier getGreenTypeFor(Classifier classifier) {
        Classifier greenType = null;
        if (this.greenDatatypes != null) {
            String greenTypeName = this.mapToGreenType(classifier.getName());
            if (this.greenDatatypes != null) {
                greenType = (Classifier)this.greenDatatypes.getOwnedType(greenTypeName, false, UMLPackage.eINSTANCE.getClassifier(), false);
            }
        }
        return greenType;
    }

    public String mapToGreenType(String typeName) {
        String greenTypeName = null;
        greenTypeName = "AD".equals(typeName) ? "PostalAddress" : ("ED".equals(typeName) ? "EncapsulatedData" : ("CD".equals(typeName) ? "ConceptDescriptor" : ("CE".equals(typeName) ? "CodedWithEquivalents" : ("CS".equals(typeName) ? "CodedSimpleValue" : ("II".equals(typeName) ? "InstanceIdentifier" : ("ON".equals(typeName) ? "OrganizationName" : ("PN".equals(typeName) ? "PersonName" : ("PQ".equals(typeName) ? "PhysicalQuantity" : ("INT".equals(typeName) ? "IntegerNumber" : ("IVL_INT".equals(typeName) ? "IntervalOfInteger" : ("MO".equals(typeName) ? "MonetaryAmount" : ("TS".equals(typeName) ? "Timestamp" : ("IVL_TS".equals(typeName) ? "IntervalOfTimestamps" : ("SXCM_TS".equals(typeName) ? "IntervalOfTimestamps" : ("TEL".equals(typeName) ? "TelecomAddress" : ("RTO_PQ_PQ".equals(typeName) ? "Ratio" : typeName))))))))))))))));
        return greenTypeName;
    }
}

