/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import org.apache.commons.lang.StringUtils;

public abstract class CDATemplateComputeBuilder {
    private String templateVersion;
    private boolean markup = false;
    private String ruleIds;
    private String multiplicity;
    private String content;

    public static String getMultiplicityRange(String multiplicity) {
        if (multiplicity == null) {
            return "1..1";
        }
        return multiplicity.trim();
    }

    public CDATemplateComputeBuilder setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
        return this;
    }

    public CDATemplateComputeBuilder setRuleIds(String ruleIds) {
        this.ruleIds = ruleIds != null && !ruleIds.trim().isEmpty() ? " ( " + ruleIds + " )" : "";
        return this;
    }

    public CDATemplateComputeBuilder setRequireMarkup(Boolean markup) {
        this.markup = markup;
        return this;
    }

    public CDATemplateComputeBuilder setMultiplicity(String multiplicityRange) {
        this.multiplicity = multiplicityRange.trim();
        return this;
    }

    public CDATemplateComputeBuilder compute() {
        StringBuilder content = new StringBuilder();
        content.append(this.getSeverityContain());
        content.append(this.getMultiplicityText());
        content.append(this.addTemplateIdMultiplicity());
        content.append(this.ruleIds);
        content.append(" such that it ");
        if (this.markup) {
            content.append("<ol><li>");
        }
        content.append(this.getSeverityContain());
        content.append("exactly one");
        content.append(this.addRootMultiplicity());
        if (this.markup) {
            content.append("</li>");
        }
        if (!StringUtils.isEmpty((String)this.templateVersion)) {
            if (this.markup) {
                content.append(" <li>");
            } else {
                content.append(" and ");
            }
            content.append(this.getSeverityContain());
            content.append("exactly one");
            content.append(this.addTemplateVersion());
            if (this.markup) {
                content.append("</li>");
            }
        }
        if (this.markup) {
            content.append("</ol>");
        }
        this.content = content.toString();
        return this;
    }

    public String toString() {
        if (this.content == null) {
            return super.toString();
        }
        return this.content;
    }

    public abstract String addTemplateIdMultiplicity();

    public abstract String addRootMultiplicity();

    public abstract String addTemplateVersion();

    private String getSeverityContain() {
        StringBuilder content = new StringBuilder();
        if (this.markup) {
            content.append("<b>");
        }
        content.append("SHALL");
        if (this.markup) {
            content.append("</b>");
        }
        content.append(" contain ");
        return content.toString();
    }

    private String getMultiplicityText() {
        if ("[1..1]".equals(this.multiplicity)) {
            return "exactly one";
        }
        if ("[1..*]".equals(this.multiplicity)) {
            return "at least one";
        }
        System.err.println("Used unexpected multiplicity " + this.multiplicity);
        return "";
    }
}

