/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.common.util.ModelConsolidator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class CDAModelConsolidator
extends ModelConsolidator {
    private Package vocabPackage;
    private Map<String, Enumeration> vocabMapping;

    public CDAModelConsolidator() {
        this.vocabMapping = new HashMap<String, Enumeration>();
    }

    public CDAModelConsolidator(Package sourcePackage, Package consolPackage, Package vocabPackage) {
        this.initialize(sourcePackage, consolPackage);
        this.initializeVocab(vocabPackage);
    }

    public CDAModelConsolidator(Package sourcePackage, Package consolPackage) {
        this.initialize(sourcePackage, consolPackage);
        this.vocabMapping = new HashMap<String, Enumeration>();
    }

    public void initializeVocab(Package vocabPackage) {
        this.vocabPackage = vocabPackage;
        this.vocabMapping = new HashMap<String, Enumeration>();
        if (vocabPackage != null) {
            EcoreUtil.resolveAll((Resource)vocabPackage.eResource());
        }
    }

    public boolean isBaseModel(Element element) {
        return CDAModelUtil.isCDAModel(element);
    }

    protected boolean isReferenceModel(Element element) {
        return RIMModelUtil.isRIMModel(element);
    }

    protected Class getBaseModelClass(Classifier subClass) {
        return CDAModelUtil.getCDAClass(subClass);
    }

    protected Property getBaseModelProperty(Property property) {
        return CDAModelUtil.getCDAProperty(property);
    }

    public Class consolidateClass(Class sourceClass) {
        Class consolidatedClass = super.consolidateClass(sourceClass);
        if (consolidatedClass != null) {
            String templateId = null;
            Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)sourceClass, "CDATemplate");
            if (hl7Template != null) {
                templateId = (String)sourceClass.getValue(hl7Template, "templateId");
            }
            if (templateId == null && (templateId = CDAModelUtil.getTemplateId(sourceClass)) != null) {
                hl7Template = CDAProfileUtil.applyCDAStereotype((Element)consolidatedClass, "CDATemplate");
                consolidatedClass.setValue(hl7Template, "templateId", (Object)templateId);
            }
        }
        return consolidatedClass;
    }

    protected void mergeInheritedProperties(Class sourceClass, Class umlClass) {
        super.mergeInheritedProperties(sourceClass, umlClass);
        for (Property mergedProperty : umlClass.getOwnedAttributes()) {
            Enumeration mappedValueSet;
            ValueSetVersion valueSetVersion;
            ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)mergedProperty);
            if (valueSetConstraint == null || (valueSetVersion = valueSetConstraint.getReference()) == null || (mappedValueSet = this.copyToConsolVocab(valueSetVersion.getBase_Enumeration())) == null) continue;
            ValueSetVersion mappedValueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)mappedValueSet);
            valueSetConstraint.setReference(mappedValueSetVersion);
        }
    }

    protected void mapExistingConsolidation() {
        super.mapExistingConsolidation();
        if (this.vocabPackage != null) {
            for (Type consolType : this.vocabPackage.getOwnedTypes()) {
                EAnnotation annotation;
                if (!(consolType instanceof Enumeration) || (annotation = consolType.getEAnnotation("sourceClass")) == null || annotation.getReferences().isEmpty()) continue;
                for (EObject reference : annotation.getReferences()) {
                    if (!(reference instanceof Enumeration)) continue;
                    this.vocabMapping.put(EcoreUtil.getURI((EObject)reference).toString(), (Enumeration)consolType);
                }
            }
        }
    }

    private Enumeration copyToConsolVocab(Enumeration vocabEnum) {
        if (this.vocabPackage != null) {
            Enumeration mappedEnum = this.vocabMapping.get(EcoreUtil.getURI((EObject)vocabEnum).toString());
            if (mappedEnum == null) {
                mappedEnum = (Enumeration)EcoreUtil.copy((EObject)vocabEnum);
                this.vocabPackage.getOwnedTypes().add((Object)mappedEnum);
                UMLUtil.cloneStereotypes((Enumeration)vocabEnum, (Enumeration)mappedEnum);
                this.vocabMapping.put(EcoreUtil.getURI((EObject)vocabEnum).toString(), mappedEnum);
                EAnnotation sourceAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                sourceAnnotation.setSource("sourceClass");
                sourceAnnotation.getReferences().add((Object)vocabEnum);
                mappedEnum.getEAnnotations().add((Object)sourceAnnotation);
            }
            return mappedEnum;
        }
        return null;
    }
}

