/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.profile.CDAFactory;
import org.eclipse.mdht.uml.cda.core.profile.Inline;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.profile.PropertyValidation;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.TextValue;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.ModelStatus;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.PropertyComparator;
import org.eclipse.mdht.uml.common.util.PropertyList;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.VisibilityKind;

public class CDACommonUtils {
    private static final String PLUGIN = "org.eclipse.mdht.uml.cda.core";
    public static Map<NamedElement, String> propertyStepCache = new WeakHashMap<NamedElement, String>();
    private static Map<Property, CodeSystemConstraint> cachedCodeSystemConstraint = new WeakHashMap<Property, CodeSystemConstraint>();
    private static Map<Property, Property> cacheCDAProperty = new WeakHashMap<Property, Property>();
    private static Map<Property, TextValue> cacheTextValue = new WeakHashMap<Property, TextValue>();
    private static Map<Class, String> cacheTemplateId = new WeakHashMap<Class, String>();
    private static Map<Classifier, Classifier> cacheCDAType = new WeakHashMap<Classifier, Classifier>();
    private static Map<Classifier, Integer> cacheMainSection = new WeakHashMap<Classifier, Integer>();
    private static Map<EObject, SortedSet<Class>> cacheCDAContents = new WeakHashMap<EObject, SortedSet<Class>>();
    private static Map<Element, Boolean> cacheDatatypeModel = new WeakHashMap<Element, Boolean>();
    private static Map<NamedElement, String> cacheBusinessName = new WeakHashMap<NamedElement, String>();
    public static Map<EObject, EObject> cachePropertyForClass = new WeakHashMap<EObject, EObject>();
    public static Map<EObject, EObject> cacheClassForProperty = cachePropertyForClass;

    public static Collection<EObject> getAllContents(Resource res) {
        return CDACommonUtils.getAllContents(res, EObject.class);
    }

    public static <T extends EObject> Collection<T> getAllContents(Collection<?> res, java.lang.Class<T> clazz) {
        TreeIterator it = EcoreUtil.getAllContents(res, (boolean)true);
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add((EObject)o);
        }
        return result;
    }

    public static <T extends EObject> Collection<T> getAllContents(Resource res, java.lang.Class<T> clazz) {
        return CDACommonUtils.getAllContents(Arrays.asList(res), clazz);
    }

    public static Collection<EObject> getAllContents(Collection<?> res) {
        return CDACommonUtils.getAllContents(res, EObject.class);
    }

    public static void stringToFile(String content, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes(Charset.forName("UTF-8")));
        out.close();
    }

    public static String stringFromFile(File sourceLocation) throws IOException {
        return CDACommonUtils.toString(new FileInputStream(sourceLocation));
    }

    public static String toString(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
        return new String(out.toByteArray(), "UTF-8");
    }

    public static void stringToFileIfGenerated(String content, File file) throws IOException {
        if (!file.exists() || !CDACommonUtils.stringFromFile(file).contains("<!--NOT GENERATED-->")) {
            CDACommonUtils.stringToFile(content, file);
        }
    }

    public static String withoutTags(String text) {
        int i2;
        int i;
        while ((i = text.indexOf("<")) != -1 && (i2 = text.indexOf(">")) > i) {
            text = String.valueOf(text.substring(0, i)) + text.substring(i2 + 1);
        }
        return text;
    }

    public static String getConformance(Element element) {
        return CDACommonUtils.getConformance(element, true, false);
    }

    public static String getConformance(Element element, boolean markup, boolean appendNestedConformanceRules) {
        Enumeration enumeration;
        ValueSetVersion version;
        EnumerationLiteral enumerationLiteral;
        ValueSetCode code;
        String result = null;
        if (element instanceof Property) {
            Property property = (Property)element;
            result = CDAModelUtil.computeConformanceMessage(property, markup, null, appendNestedConformanceRules);
        }
        if (element instanceof Constraint) {
            Constraint constraint = (Constraint)element;
            result = CDAModelUtil.computeConformanceMessage(constraint, markup);
        }
        if (element instanceof Class) {
            Class class1 = (Class)element;
            Property property = CDACommonUtils.getOverallPropertyReference(class1);
            result = property != null ? CDAModelUtil.computeConformanceMessage(property, markup, null, appendNestedConformanceRules) : "";
        }
        if (element instanceof EnumerationLiteral && (code = TermProfileUtil.getValueSetCode((EnumerationLiteral)(enumerationLiteral = (EnumerationLiteral)element))) != null) {
            result = code.getConceptName();
        }
        if (element instanceof Enumeration && (version = TermProfileUtil.getValueSetVersion((Enumeration)(enumeration = (Enumeration)element))) != null) {
            result = version.getIdentifier();
        }
        return result;
    }

    public static String getPDFSection(Element element, boolean fullSection, boolean level2) {
        Resource resource;
        String uri;
        int index;
        int incr = Integer.getInteger("MDHT_SECTION_INCREMENT", 0);
        if (incr == 0 && element.eResource() != null && element.eResource().getResourceSet() != null && (index = (uri = (resource = (Resource)element.eResource().getResourceSet().getResources().get(0)).getURI().toString()).indexOf(".model/")) != -1) {
            try {
                uri = String.valueOf(uri.substring(0, index)) + ".doc/dita/spec-book.ditamap";
                InputStream inputStream = new URL(uri).openConnection().getInputStream();
                String specBook = CDACommonUtils.toString(inputStream);
                index = specBook.indexOf("<chapter format=\"ditamap\" href=\"content/content.ditamap\"/>");
                if (index != -1) {
                    incr = StringUtils.countMatches((String)specBook.substring(0, index), (String)"<chapter") - 1;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        String result = "";
        Element eObject = element;
        while (eObject != null && !(eObject instanceof Package)) {
            String step = "?";
            if (eObject instanceof Class) {
                Class class1 = (Class)eObject;
                int mainSection = CDACommonUtils.getMainSection(class1);
                if (mainSection != -1) {
                    step = String.valueOf(mainSection + incr) + "." + (CDACommonUtils.getCDAContents(class1).indexOf(class1) + 1);
                    if (!fullSection || level2) {
                        return String.valueOf(step) + " " + CDACommonUtils.getBusinessName((NamedElement)class1);
                    }
                    if (fullSection) {
                        result = String.valueOf(step) + "." + result;
                        break;
                    }
                } else {
                    Property property = CDACommonUtils.getOverallPropertyReference(class1);
                    if (property != null) {
                        step = CDACommonUtils.getPropertyStep(CDACommonUtils.getClassReference((EObject)property), (NamedElement)property);
                    }
                }
            } else {
                if (eObject instanceof Constraint && CDACommonUtils.getParentingProperty((Constraint)eObject) != null) {
                    Property prop = CDACommonUtils.getParentingProperty((Constraint)eObject);
                    if (prop.getType() instanceof Class && CDACommonUtils.getMainSection((Class)prop.getType()) == -1) {
                        Class class1 = (Class)prop.getType();
                        step = CDACommonUtils.getPropertyStep(class1, (NamedElement)class1);
                    } else {
                        step = CDACommonUtils.getCustomizedBulletItem((Element)prop, 0);
                    }
                    eObject = prop;
                    result = String.valueOf(step) + "." + result;
                    continue;
                }
                if (eObject instanceof NamedElement && CDACommonUtils.getContainerReference((EObject)eObject) instanceof Class) {
                    NamedElement property = (NamedElement)eObject;
                    Class parentClass = (Class)CDACommonUtils.getContainerReference((EObject)eObject);
                    step = CDACommonUtils.getPropertyStep(parentClass, property);
                } else {
                    if (eObject instanceof Enumeration && CDACommonUtils.getContainerReference((EObject)eObject) instanceof Package) {
                        Package package1 = (Package)CDACommonUtils.getContainerReference((EObject)eObject);
                        Enumeration enumeration = (Enumeration)eObject;
                        return "6." + (package1.getPackagedElements().indexOf((Object)eObject) + 1) + " " + enumeration.getName();
                    }
                    if (eObject instanceof EnumerationLiteral) {
                        EnumerationLiteral enumerationLiteral = (EnumerationLiteral)eObject;
                        return enumerationLiteral.getName();
                    }
                }
            }
            if (!fullSection) {
                return String.valueOf(step) + ".";
            }
            result = String.valueOf(step) + "." + result;
            if (!fullSection) {
                return step;
            }
            eObject = CDACommonUtils.getContainerReference((EObject)eObject);
        }
        return result.endsWith(".") ? result.substring(0, result.length() - 1) : result;
    }

    private static int getMainSection_(Class class1) {
        if (CDAModelUtil.isDisplayInline(class1) || CDACommonUtils.getCDAType((Classifier)class1) == null) {
            return -1;
        }
        if (CDACommonUtils.isClinicalDocument((Type)class1)) {
            return 2;
        }
        if (CDACommonUtils.isSection((Type)class1)) {
            return 3;
        }
        if (CDACommonUtils.isClinicalStatement((Type)class1)) {
            return 4;
        }
        Resource res = class1.eResource();
        if (res != null && res.getResourceSet() != null && res.getResourceSet().getResources().get(0) == res) {
            return 5;
        }
        return 6;
    }

    public static int getMainSection(Class class1) {
        Integer result = cacheMainSection.get(class1);
        if (result == null) {
            result = CDACommonUtils.getMainSection_(class1);
            cacheMainSection.put((Classifier)class1, result);
        }
        return result;
    }

    public static Class getClassReference(EObject property) {
        if (cacheClassForProperty.get(property) instanceof Class) {
            return (Class)cacheClassForProperty.get(property);
        }
        return (Class)property.eContainer();
    }

    private static EObject getContainerReference(EObject child) {
        if (cacheClassForProperty.get(child) instanceof Class) {
            return cacheClassForProperty.get(child);
        }
        if (cachePropertyForClass.get(child) != null) {
            return CDACommonUtils.getContainerReference(cachePropertyForClass.get(child));
        }
        return child.eContainer();
    }

    public static String getPDFSection(Element element, boolean fullSection) {
        return CDACommonUtils.getPDFSection(element, fullSection, false);
    }

    public static NamedElement getMDHTRepresentative(NamedElement dataComponent) {
        Association association;
        if (dataComponent instanceof Association && (association = (Association)dataComponent).getMemberEnds().size() != 0) {
            return (NamedElement)association.getMemberEnds().get(0);
        }
        return dataComponent;
    }

    public static List<Class> getCDAContents(Class class1) {
        if (cacheCDAContents.get(class1) != null) {
            return new ArrayList<Class>((Collection)cacheCDAContents.get(class1));
        }
        return Collections.emptyList();
    }

    private static boolean checkClassReferences(Class source, Class umlClass, List<SortedSet<Class>> sets) {
        if (cacheCDAContents.containsKey(umlClass) || !CDACommonUtils.inSameModel(source, umlClass)) {
            return false;
        }
        int section = CDACommonUtils.getMainSection(umlClass) - 2;
        if (section >= 0) {
            sets.get(section).add(umlClass);
            cacheCDAContents.put((EObject)umlClass, sets.get(section));
        } else {
            cacheCDAContents.put((EObject)umlClass, null);
        }
        for (Property property : umlClass.getOwnedAttributes()) {
            if (!(property.getType() instanceof Class)) continue;
            CDACommonUtils.checkClassReferences(source, (Class)property.getType(), sets);
        }
        for (Generalization generalization : umlClass.getGeneralizations()) {
            if (!(generalization.getGeneral() instanceof Class)) continue;
            CDACommonUtils.checkClassReferences(source, (Class)generalization.getGeneral(), sets);
        }
        return true;
    }

    public static Property getPropertyReference(Class class1) {
        if (class1.eContainer() instanceof Class) {
            Class parentClass = (Class)class1.eContainer();
            for (Property property : parentClass.getAttributes()) {
                if (property.getType() != class1) continue;
                return property;
            }
        }
        return null;
    }

    public static String getPropertyStep(Class umlClass, NamedElement focusedProperty) {
        LogicalConstraint logicConstraint;
        String result = propertyStepCache.get(focusedProperty);
        if (result != null) {
            return result;
        }
        ArrayList allProperties = new ArrayList();
        int offset = 0;
        if (umlClass.eContainer() instanceof Package) {
            if (CDACommonUtils.getTemplateId(umlClass) != null) {
                ++offset;
            }
            if (!CDAModelUtil.isInlineClass(umlClass)) {
                for (Generalization generalization : umlClass.getGeneralizations()) {
                    String message;
                    Classifier general = generalization.getGeneral();
                    if (RIMModelUtil.isRIMModel((Element)general) || CDACommonUtils.isCDAModel((Element)general) || CDACommonUtils.isDatatypeModel((Element)general) || (message = CDAModelUtil.computeConformanceMessage(generalization, true)).length() <= 0) continue;
                    ++offset;
                }
            }
            allProperties = new ArrayList(umlClass.getOwnedAttributes());
            ArrayList<Property> allAttributes = new ArrayList<Property>();
            for (Property property : allProperties) {
                if (!CDAModelUtil.isXMLAttribute(property)) continue;
                allAttributes.add(property);
            }
            for (Constraint constraint : umlClass.getOwnedRules()) {
                logicConstraint = CDAProfileUtil.getLogicalConstraint(constraint);
                if (logicConstraint == null) continue;
                for (Element constrainedElement : constraint.getConstrainedElements()) {
                    if (!(constrainedElement instanceof Property)) continue;
                    allProperties.remove(constrainedElement);
                }
            }
            allProperties.removeAll(allAttributes);
            Collections.sort(allAttributes, new NamedElementComparator());
            Collections.sort(allProperties, new PropertyComparator());
            allProperties.addAll(0, allAttributes);
        } else {
            PropertyList propertyList = new PropertyList(umlClass, CDAModelUtil.isInlineClass(umlClass));
            for (Property property : propertyList.getAttributes()) {
                if (CDACommonUtils.isCDAModel((Element)umlClass) || CDACommonUtils.isCDAModel((Element)property) || CDACommonUtils.isDatatypeModel((Element)property) || !CDAModelUtil.hasOwnPDFSection(property)) continue;
                allProperties.add(property);
            }
            for (Property property : propertyList.getAssociationEnds()) {
                if (CDACommonUtils.isCDAModel((Element)umlClass) || CDACommonUtils.isCDAModel((Element)property) || CDACommonUtils.isDatatypeModel((Element)property)) continue;
                allProperties.add(property);
            }
        }
        for (Property prop : allProperties) {
            propertyStepCache.put((NamedElement)prop, CDACommonUtils.getCustomizedBulletItem((Element)umlClass, offset));
            ++offset;
        }
        for (Constraint constraint : umlClass.getOwnedRules()) {
            if ((constraint.getConstrainedElements().size() != 1 || constraint.getConstrainedElements().get(0) != umlClass || constraint.getName() == null || constraint.getName().endsWith("TemplateId")) && constraint.getConstrainedElements().size() <= 1) continue;
            String constraintItem = CDACommonUtils.getCustomizedBulletItem((Element)umlClass, offset);
            propertyStepCache.put((NamedElement)constraint, constraintItem);
            ++offset;
            logicConstraint = CDAProfileUtil.getLogicalConstraint(constraint);
            if (logicConstraint == null) continue;
            int propertyIndex = 0;
            for (Element constrainedElement : constraint.getConstrainedElements()) {
                if (!(constrainedElement instanceof Property)) continue;
                Property property = (Property)constrainedElement;
                String propertyItem = CDACommonUtils.getCustomizedBulletItem((Element)constraint, propertyIndex);
                propertyStepCache.put((NamedElement)property, String.valueOf(constraintItem) + "." + propertyItem);
                ++propertyIndex;
            }
        }
        propertyStepCache.put((NamedElement)umlClass, CDACommonUtils.getCustomizedBulletItem((Element)umlClass, offset));
        return propertyStepCache.get(focusedProperty);
    }

    public static Property getParentingProperty(Constraint constraint) {
        if (constraint.getConstrainedElements().size() == 1 && constraint.getConstrainedElements().get(0) instanceof Property) {
            Property property = (Property)constraint.getConstrainedElements().get(0);
            Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)constraint, "ConstraintValidation");
            if (stereotype != null) {
                return property;
            }
        }
        return null;
    }

    public static String getCustomizedBulletItem(Element umlClass, int index) {
        int level = 0;
        Element eObject = umlClass;
        while (eObject != null && !(eObject instanceof Package)) {
            if (eObject instanceof Class && CDACommonUtils.getMainSection((Class)eObject) != -1) break;
            EObject constrainedProperty = cachePropertyForClass.get(eObject);
            eObject = CDACommonUtils.getContainerReference((EObject)eObject);
            if (constrainedProperty instanceof Property && eObject instanceof Class) {
                Class class1 = (Class)eObject;
                for (Constraint constraint : class1.getOwnedRules()) {
                    if (!constraint.getConstrainedElements().contains((Object)constrainedProperty) || CDAProfileUtil.getLogicalConstraint(constraint) == null) continue;
                    ++level;
                    break;
                }
            }
            ++level;
        }
        if ((level %= 3) == 1) {
            String[] romans = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x"};
            return String.valueOf(StringUtils.repeat((String)"x", (int)(index / 10))) + romans[index % 10];
        }
        if (level == 2) {
            return "" + (char)(97 + index);
        }
        return "" + (index + 1);
    }

    public static void patchResourceSet(ResourceSet rset) {
        UmlPlugin.computeModelPathMapExtensions();
        rset.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
    }

    public static Property getPropertyForTypeCheck(Class clazz) {
        if (CDACommonUtils.isClinicalDocument((Type)clazz)) {
            return null;
        }
        if (CDACommonUtils.getTemplateId(clazz) != null) {
            return null;
        }
        Inline inline = CDAProfileUtil.getInline(clazz);
        if (inline != null && inline.getFilter() != null) {
            return null;
        }
        Property containerProperty = null;
        EObject predicate = null;
        for (Property property : CDACommonUtils.allAttributes(clazz)) {
            EObject oldPredicate;
            if (CDACommonUtils.getCDAProperty(property) == null || !(property.getType() instanceof Class) || property.lowerBound() == 0 || (oldPredicate = predicate) == (predicate = CDACommonUtils.getPredicateForCodeOrClasscodeCheck(predicate, (Class)property.getType()))) continue;
            containerProperty = property;
        }
        return containerProperty;
    }

    public static boolean isClinicalDocument(Type templateClass) {
        return CDACommonUtils.isCDAType(templateClass, "ClinicalDocument");
    }

    public static boolean isSection(Type templateClass) {
        return CDACommonUtils.isCDAType(templateClass, "Section");
    }

    public static boolean isOrganizer(Type templateClass) {
        return CDACommonUtils.isCDAType(templateClass, "Organizer");
    }

    public static boolean isEntry(Type templateClass) {
        return CDACommonUtils.isCDAType(templateClass, "Entry");
    }

    public static boolean isClinicalStatement(Type templateClass) {
        return CDAModelUtil.isClinicalStatement(templateClass);
    }

    public static Property getLeafPropertyForTypeCheck(Class clazz) {
        EObject predicate = CDACommonUtils.getPredicateForTypeCheck(clazz);
        if (predicate instanceof Property) {
            return (Property)predicate;
        }
        if (predicate instanceof CodeSystemConstraint) {
            return ((CodeSystemConstraint)predicate).getBase_Property();
        }
        return null;
    }

    public static EObject getPredicateForTypeCheck(Class clazz) {
        Inline inline = CDAProfileUtil.getInline(clazz);
        if (inline != null && inline.getFilter() != null) {
            return inline;
        }
        if (CDACommonUtils.isClinicalDocument((Type)clazz)) {
            return null;
        }
        if (CDACommonUtils.getTemplateId(clazz) != null) {
            return clazz;
        }
        EObject predicate = null;
        for (Property actproperty : CDACommonUtils.allAttributes(clazz)) {
            if (CDACommonUtils.getCDAProperty(actproperty) == null || !(actproperty.getType() instanceof Class) || actproperty.lowerBound() == 0) continue;
            Class class1 = (Class)actproperty.getType();
            predicate = CDACommonUtils.getPredicateForCodeOrClasscodeCheck(predicate, class1);
        }
        return predicate;
    }

    public static EObject getPredicateForCodeOrClasscodeCheck(EObject predicate, Class clazz) {
        if (CDACommonUtils.isClinicalDocument((Type)clazz)) {
            return predicate;
        }
        if (CDACommonUtils.getTemplateId(clazz) != null) {
            return clazz;
        }
        for (Property property : CDACommonUtils.allAttributes(clazz)) {
            if (property.lowerBound() == 0) continue;
            CodeSystemConstraint codeSystemConstraint = CDACommonUtils.getCodeSystemConstraint(property);
            if (codeSystemConstraint != null && codeSystemConstraint.getCode() != null) {
                predicate = codeSystemConstraint;
            }
            if (predicate != null || CDACommonUtils.getDefault(property) == null || !"classCode".equals(property.getName())) continue;
            predicate = property;
        }
        return predicate;
    }

    public static CodeSystemConstraint getCodeSystemConstraint(Property property) {
        if (!cachedCodeSystemConstraint.containsKey(property)) {
            cachedCodeSystemConstraint.put(property, TermProfileUtil.getCodeSystemConstraint((Property)property));
        }
        return cachedCodeSystemConstraint.get(property);
    }

    public static String getDefault(Property property) {
        return property.getDefaultValue() instanceof InstanceValue ? ((InstanceValue)property.getDefaultValue()).getName() : property.getDefault();
    }

    public static String getMultiplicityString(NamedElement namedElement) {
        NamedElement dataItem = CDACommonUtils.getMDHTRepresentative(namedElement);
        if (dataItem instanceof MultiplicityElement) {
            MultiplicityElement multiplicityElement = (MultiplicityElement)dataItem;
            return String.valueOf(multiplicityElement.getLower()) + ".." + (-1 == multiplicityElement.getUpper() ? "*" : Integer.valueOf(multiplicityElement.getUpper()));
        }
        return null;
    }

    public static String getMultiplicityRange(Class template) {
        String templateId = null;
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)template, "CDATemplate");
        if (hl7Template != null && template.hasValue(hl7Template, "templateMultiplicity")) {
            templateId = (String)template.getValue(hl7Template, "templateMultiplicity");
        } else {
            for (Classifier parent : template.getGenerals()) {
                templateId = CDACommonUtils.getMultiplicityRange((Class)parent);
                if (templateId != null) break;
            }
        }
        return templateId;
    }

    public static Property getCDAProperty(Property property, Collection<ModelStatus> statuses) {
        if (!cacheCDAProperty.containsKey(property)) {
            Property cdaProperty = property;
            while (!cdaProperty.getRedefinedProperties().isEmpty()) {
                cdaProperty = (Property)cdaProperty.getRedefinedProperties().get(0);
            }
            while (!cdaProperty.getSubsettedProperties().isEmpty()) {
                cdaProperty = (Property)cdaProperty.getSubsettedProperties().get(0);
            }
            if ((cdaProperty = CDAModelUtil.getCDAProperty(cdaProperty)) == null) {
                for (Classifier parent : property.getClass_().allParents()) {
                    for (Property inherited : parent.getAttributes()) {
                        if (property.getType() == null || !property.getType().conformsTo(inherited.getType()) || !CDACommonUtils.isCDAModel((Element)inherited) && !CDACommonUtils.isDatatypeModel((Element)inherited)) continue;
                        if (cdaProperty != null) {
                            if (statuses == null) continue;
                            CDACommonUtils.addStatus(statuses, 2, PLUGIN, 12, "Found ambiguous CDA base properties for " + CDACommonUtils.getUmlContext(property) + ": " + CDACommonUtils.getUmlContext(cdaProperty) + " and " + CDACommonUtils.getUmlContext(inherited), new EObject[]{property});
                            continue;
                        }
                        cdaProperty = inherited;
                    }
                }
            }
            if (cdaProperty == null && statuses != null) {
                CDACommonUtils.addStatus(statuses, 2, PLUGIN, 13, "Found no CDA base property for " + CDACommonUtils.getUmlContext(property), new EObject[]{property});
            }
            cacheCDAProperty.put(property, cdaProperty);
        }
        return cacheCDAProperty.get(property);
    }

    public static Property getCDAProperty(Property property) {
        return CDACommonUtils.getCDAProperty(property, null);
    }

    public static Type getType(NamedElement namedElement) {
        Class clazz;
        Iterator iterator;
        NamedElement dataItem = CDACommonUtils.getMDHTRepresentative(namedElement);
        if (dataItem instanceof TypedElement) {
            TypedElement typedElement = (TypedElement)dataItem;
            if (typedElement.getType() != null) {
                return typedElement.getType();
            }
        } else if (dataItem instanceof Class && (iterator = (clazz = (Class)dataItem).getSuperClasses().iterator()).hasNext()) {
            Class superclazz = (Class)iterator.next();
            return superclazz;
        }
        return null;
    }

    public static String getTypeString(NamedElement namedElement) {
        Type cellData = CDACommonUtils.getType(namedElement);
        if (cellData != null) {
            return cellData.getName();
        }
        return null;
    }

    public static Property getPropertyForCodeOrClasscodeCheck(Class clazz) {
        EObject predicate = CDACommonUtils.getPredicateForCodeOrClasscodeCheck(null, clazz);
        if (predicate instanceof Property) {
            return (Property)predicate;
        }
        if (predicate instanceof CodeSystemConstraint) {
            return ((CodeSystemConstraint)predicate).getBase_Property();
        }
        return null;
    }

    public static TextValue getTextValue(Property property) {
        if (!cacheTextValue.containsKey(property)) {
            cacheTextValue.put(property, CDAProfileUtil.getTextValue(property));
        }
        return cacheTextValue.get(property);
    }

    public static String getTemplateId(Class clazz) {
        if (!cacheTemplateId.containsKey(clazz)) {
            cacheTemplateId.put(clazz, CDAModelUtil.getTemplateId(clazz));
        }
        return cacheTemplateId.get(clazz);
    }

    public static boolean isDatatypeModel(Element element) {
        if (!cacheDatatypeModel.containsKey(element)) {
            cacheDatatypeModel.put(element, CDAModelUtil.isDatatypeModel(element));
        }
        return cacheDatatypeModel.get(element);
    }

    public static boolean isCDAModel(Element element) {
        return CDAModelUtil.isCDAModel(element);
    }

    public static Classifier getCDAType(Classifier clazz) {
        if (!cacheCDAType.containsKey(clazz)) {
            Class cdaClass = CDAModelUtil.getCDAClass(clazz);
            if (cdaClass == null) {
                cdaClass = CDAModelUtil.getCDADatatype(clazz);
            }
            cacheCDAType.put(clazz, (Classifier)cdaClass);
        }
        return cacheCDAType.get(clazz);
    }

    public static String getBusinessName(NamedElement namedElement) {
        if (!cacheBusinessName.containsKey(namedElement)) {
            cacheBusinessName.put(namedElement, NamedElementUtil.getBusinessName((NamedElement)namedElement));
        }
        return cacheBusinessName.get(namedElement);
    }

    public static boolean isCDAType(Type templateClass, String typeName) {
        Classifier cdaClass;
        return templateClass instanceof Classifier && typeName != null && (cdaClass = CDACommonUtils.getCDAType((Classifier)templateClass)) != null && typeName.equals(cdaClass.getName());
    }

    public static boolean addStatus(Collection<ModelStatus> statuses, int severity, String plugin, int errorCode, String message, Exception e, EObject ... participants) {
        ModelStatus status = new ModelStatus(severity, plugin, errorCode, message, e, participants);
        for (IStatus iStatus : statuses) {
            if (!iStatus.getMessage().equals(status.getMessage())) continue;
            return false;
        }
        statuses.add(status);
        return true;
    }

    public static boolean addStatus(Collection<ModelStatus> statuses, int severity, String plugin, int errorCode, String message, EObject ... participants) {
        return CDACommonUtils.addStatus(statuses, severity, plugin, errorCode, message, null, participants);
    }

    public static Property getOverallPropertyReference(Class class1) {
        if (cachePropertyForClass.get(class1) instanceof Property) {
            return (Property)cachePropertyForClass.get(class1);
        }
        return CDACommonUtils.getPropertyReference(class1);
    }

    public static void buildupPropertyForClinicalDocument(Class umlClinicalDocument) {
        cachePropertyForClass.put((EObject)umlClinicalDocument, null);
        CDACommonUtils.recursePropertyPaths(umlClinicalDocument);
        ArrayList<SortedSet<Class>> sets = new ArrayList<SortedSet<Class>>();
        NamedElementComparator comparator = new NamedElementComparator();
        sets.add(new TreeSet(comparator));
        sets.add(new TreeSet(comparator));
        sets.add(new TreeSet(comparator));
        sets.add(new TreeSet(comparator));
        sets.add(new TreeSet(comparator));
        for (Class umlClass : CDACommonUtils.getAllContents(umlClinicalDocument.eResource(), Class.class)) {
            CDACommonUtils.checkClassReferences(umlClinicalDocument, umlClass, sets);
        }
    }

    public static boolean hasPropertyPath(Property property) {
        return cacheClassForProperty.containsKey(property);
    }

    public static boolean inSameModel(Class a, Class b) {
        return CDACommonUtils.isCDAModel((Element)a) == CDACommonUtils.isCDAModel((Element)b) && CDACommonUtils.isDatatypeModel((Element)a) == CDACommonUtils.isDatatypeModel((Element)b);
    }

    private static void recursePropertyPaths(Class parentClass) {
        Collection<Property> allProperties = CDACommonUtils.allAttributes(parentClass);
        for (Property property : allProperties) {
            Class nestedClass;
            if (property.eContainer() instanceof Class && CDACommonUtils.inSameModel((Class)property.eContainer(), parentClass)) {
                cacheClassForProperty.put((EObject)property, (EObject)parentClass);
            }
            if (!(property.getType() instanceof Class) || !CDACommonUtils.inSameModel((Class)property.getType(), parentClass) || cachePropertyForClass.containsKey(nestedClass = (Class)property.getType())) continue;
            cachePropertyForClass.put((EObject)nestedClass, (EObject)property);
            CDACommonUtils.recursePropertyPaths(nestedClass);
        }
    }

    public static List<Property> getPropertyPath(Class clazz) {
        ArrayList<Property> propertyPath = new ArrayList<Property>();
        Class eObject = clazz;
        while (eObject instanceof Class) {
            Class class1 = eObject;
            Property childProperty = CDACommonUtils.getOverallPropertyReference(class1);
            if (childProperty == null) break;
            eObject = CDACommonUtils.getClassReference((EObject)childProperty);
            propertyPath.add(0, childProperty);
        }
        return propertyPath;
    }

    public static String getUmlContext(Property property) {
        return property.getQualifiedName();
    }

    public static String getUmlContextDoubled(Property property) {
        String result = CDACommonUtils.getUmlContext(property);
        Property cdaProperty = CDACommonUtils.getCDAProperty(property);
        if (cdaProperty != null) {
            return String.valueOf(result) + " (" + CDACommonUtils.getUmlContext(cdaProperty) + ")";
        }
        return result;
    }

    public static String getUmlContext(Class clazz) {
        return CDACommonUtils.getUmlContext(clazz, true);
    }

    public static String getUmlContext(Class clazz, boolean abbr) {
        if (CDACommonUtils.isDatatypeModel((Element)clazz)) {
            return "/datatypes:" + clazz.getName();
        }
        List<Property> propertyPath = CDACommonUtils.getPropertyPath(clazz);
        if (propertyPath.isEmpty()) {
            return "/" + clazz.getName();
        }
        EObject eContainer = propertyPath.get(0).eContainer();
        StringBuilder umlContext = new StringBuilder("/" + (eContainer instanceof Class ? ((Class)eContainer).getName() : "root"));
        for (Property property : propertyPath) {
            Class class1 = (Class)property.getType();
            umlContext.append("/" + property.getName());
            if (!abbr || class1 == null || class1.eContainer() instanceof Class) continue;
            umlContext.replace(0, umlContext.length(), "/" + class1.getName());
        }
        return umlContext.toString();
    }

    public static Property findAttribute(Class cls, String name) {
        for (Property property : CDACommonUtils.allAttributes(cls)) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    private static void addInheritedPrivateAttributes(Class cls, Collection<Property> result, Set<String> propertyNames) {
        for (Generalization gen : cls.getGeneralizations()) {
            Class general = (Class)gen.getGeneral();
            if (general == null) continue;
            for (Property prop : general.getOwnedAttributes()) {
                if (prop.getVisibility() != VisibilityKind.PRIVATE_LITERAL || !propertyNames.add(prop.getName())) continue;
                result.add(prop);
            }
            CDACommonUtils.addInheritedPrivateAttributes(general, result, propertyNames);
        }
    }

    public static Collection<Property> allAttributes(Class cls) {
        ArrayList<Property> result = new ArrayList<Property>();
        HashSet<String> propertyNames = new HashSet<String>();
        for (Property prop : cls.getAllAttributes()) {
            if (!propertyNames.add(prop.getName())) continue;
            result.add(prop);
        }
        CDACommonUtils.addInheritedPrivateAttributes(cls, result, propertyNames);
        HashSet redefinedProperties = new HashSet();
        for (Property prop : result) {
            redefinedProperties.addAll(prop.getRedefinedProperties());
        }
        result.removeAll(redefinedProperties);
        return result;
    }

    public static List<Constraint> getAllRules(Class clazz) {
        Collection<Property> allProperties = CDACommonUtils.allAttributes(clazz);
        HashSet<String> ruleNames = new HashSet<String>();
        ArrayList<Constraint> rules = new ArrayList<Constraint>((Collection<Constraint>)clazz.getOwnedRules());
        for (Constraint constraint : rules) {
            ruleNames.add(constraint.getName());
        }
        for (Classifier generalClass : clazz.allParents()) {
            if (CDACommonUtils.getCDAType(generalClass) == generalClass) continue;
            block2: for (Constraint constraint : generalClass.getOwnedRules()) {
                for (Element ele : constraint.getConstrainedElements()) {
                    Object object = ele = ele instanceof NamedElement ? CDACommonUtils.getMDHTRepresentative((NamedElement)ele) : ele;
                    if (!(ele instanceof Property) || !allProperties.contains(ele) || !ruleNames.add(constraint.getName())) continue;
                    rules.add(constraint);
                    continue block2;
                }
            }
        }
        return rules;
    }

    public static Property createTemplateIdProperty(Class umlClass) {
        Property templateIdProp;
        String templateId = CDAModelUtil.getTemplateId(umlClass);
        if (templateId != null && (templateIdProp = CDACommonUtils.createProperty3(umlClass, "templateId", SeverityKind.ERROR)) != null) {
            String templateVersion = CDAModelUtil.getTemplateVersion(umlClass);
            String assigningAuthorityName = CDAModelUtil.getAssigningAuthorityName(umlClass);
            Class nestedClass = UMLFactory.eINSTANCE.createClass();
            Generalization gen = UMLFactory.eINSTANCE.createGeneralization();
            Classifier type = (Classifier)templateIdProp.getType();
            gen.setGeneral(type);
            nestedClass.getGeneralizations().add((Object)gen);
            nestedClass.setName(String.valueOf(type.getName()) + "_for_" + templateIdProp.getName());
            umlClass.getNestedClassifiers().add((Object)nestedClass);
            templateIdProp.setType((Type)nestedClass);
            CDACommonUtils.createProperty2(nestedClass, "root", templateId, SeverityKind.ERROR);
            CDACommonUtils.createProperty2(nestedClass, "extension", templateVersion, SeverityKind.ERROR);
            CDACommonUtils.createProperty2(nestedClass, "assigningAuthorityName", assigningAuthorityName, SeverityKind.WARNING);
            return templateIdProp;
        }
        return null;
    }

    private static void createProperty2(Class cls, String name, String defaultValue, SeverityKind severity) {
        if (defaultValue == null) {
            return;
        }
        Property property = CDACommonUtils.createProperty3(cls, name, severity);
        if (property != null) {
            property.setDefault(defaultValue);
        }
    }

    private static Property createProperty3(Class cls, String name, SeverityKind severity) {
        Property existing = CDACommonUtils.findAttribute(cls, name);
        if (existing != null && existing.eContainer() != cls) {
            Property derivedProperty = UMLFactory.eINSTANCE.createProperty();
            derivedProperty.setName(existing.getName());
            derivedProperty.setType(existing.getType());
            if (severity == SeverityKind.WARNING) {
                derivedProperty.setLower(0);
            }
            cls.getOwnedAttributes().add((Object)derivedProperty);
            PropertyValidation pv = CDAFactory.eINSTANCE.createPropertyValidation();
            pv.setBase_Property(derivedProperty);
            pv.setSeverity(severity);
            cls.eResource().getContents().add((Object)pv);
            return derivedProperty;
        }
        return null;
    }

    public static Class getClinicalDocument(Element element) {
        for (NamedElement ne : element.getNearestPackage().getPackagedElements()) {
            if (!(ne instanceof Class) || !CDACommonUtils.isClinicalDocument((Type)((Class)ne))) continue;
            return (Class)ne;
        }
        return null;
    }

    public static String getCodeSystem(CodeSystemConstraint codeSystemConstraint) {
        if (codeSystemConstraint.getReference() != null) {
            return codeSystemConstraint.getReference().getIdentifier();
        }
        return codeSystemConstraint.getIdentifier();
    }

    public static void printTerminologyConstraintAsList(Class umlClass, Set<Class> alreadyHandled) {
        if (!alreadyHandled.add(umlClass)) {
            return;
        }
        if (CDAModelUtil.isCDAModel((Element)umlClass) || CDAModelUtil.isDatatypeModel((Element)umlClass)) {
            return;
        }
        for (Property property : umlClass.getOwnedAttributes()) {
            if (!(property.getType() instanceof Class)) continue;
            Class codeClass = (Class)property.getType();
            CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
            if (codeSystemConstraint != null) {
                if (codeClass.eContainer() != umlClass) {
                    Class nestedClass = UMLFactory.eINSTANCE.createClass();
                    Generalization gen = UMLFactory.eINSTANCE.createGeneralization();
                    gen.setGeneral((Classifier)codeClass);
                    nestedClass.getGeneralizations().add((Object)gen);
                    nestedClass.setName(String.valueOf(codeClass.getName()) + "_for_" + property.getName());
                    umlClass.getNestedClassifiers().add((Object)nestedClass);
                    property.setType((Type)nestedClass);
                    codeClass = nestedClass;
                }
                String codeSystem = null;
                String codeSystemName = null;
                String code = null;
                String displayName = null;
                if (codeSystemConstraint.getReference() != null) {
                    codeSystem = codeSystemConstraint.getReference().getIdentifier();
                    codeSystemName = codeSystemConstraint.getReference().getEnumerationName();
                    codeSystemConstraint.getReference().getVersion();
                } else {
                    codeSystem = codeSystemConstraint.getIdentifier();
                    codeSystemName = codeSystemConstraint.getName();
                    codeSystemConstraint.getVersion();
                }
                code = codeSystemConstraint.getCode();
                displayName = codeSystemConstraint.getDisplayName();
                CDACommonUtils.createProperty(codeClass, "code", code, SeverityKind.ERROR);
                CDACommonUtils.createProperty(codeClass, "codeSystem", codeSystem, SeverityKind.ERROR);
                CDACommonUtils.createProperty(codeClass, "codeSystemName", codeSystemName, SeverityKind.WARNING);
                CDACommonUtils.createProperty(codeClass, "displayName", displayName, SeverityKind.WARNING);
                Stereotype stereotype = TermProfileUtil.getAppliedStereotype((Element)property, (String)"CodeSystemConstraint");
                if (stereotype != null) {
                    property.unapplyStereotype(stereotype);
                }
            }
            CDACommonUtils.printTerminologyConstraintAsList(codeClass, alreadyHandled);
        }
        for (Generalization generalization : umlClass.getGeneralizations()) {
            if (!(generalization.getGeneral() instanceof Class)) continue;
            CDACommonUtils.printTerminologyConstraintAsList((Class)generalization.getGeneral(), alreadyHandled);
        }
    }

    private static void createProperty(Class cls, String name, String value, SeverityKind severity) {
        Property existing = CDACommonUtils.findAttribute(cls, name);
        if (existing != null && existing.eContainer() != cls && value != null) {
            Property derivedProperty = UMLFactory.eINSTANCE.createProperty();
            derivedProperty.setName(existing.getName());
            derivedProperty.setType(existing.getType());
            derivedProperty.setDefault(value);
            if (severity == SeverityKind.WARNING) {
                derivedProperty.setLower(0);
            }
            cls.getOwnedAttributes().add((Object)derivedProperty);
            PropertyValidation pv = CDAFactory.eINSTANCE.createPropertyValidation();
            pv.setBase_Property(derivedProperty);
            pv.setSeverity(severity);
            derivedProperty.eResource().getContents().add((Object)pv);
        }
    }

    public static void printTerminologyConstraintAsList(Collection<?> emfObjects) {
        HashSet<Class> alreadyHandledForPrintTerminologyConstraintAsList = new HashSet<Class>();
        for (Class cls : CDACommonUtils.getAllContents(emfObjects, Class.class)) {
            CDACommonUtils.printTerminologyConstraintAsList(cls, alreadyHandledForPrintTerminologyConstraintAsList);
        }
    }
}

