/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;

public class CommentSection
extends WrapperAwareModelerPropertySection {
    protected Element umlElement;
    private Text bodyText;
    private boolean bodyModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (CommentSection.this.bodyText == event.getSource()) {
                CommentSection.this.bodyModified = true;
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            CommentSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!this.bodyModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Comment comment;
                    String commentText;
                    if (CommentSection.this.bodyModified) {
                        CommentSection.this.bodyModified = false;
                        commentText = CommentSection.this.removeNonXMLCharacters(CommentSection.this.bodyText.getText().trim());
                        comment = null;
                        if (CommentSection.this.umlElement instanceof Comment) {
                            comment = (Comment)CommentSection.this.umlElement;
                        } else {
                            Iterator iterator = CommentSection.this.umlElement.getOwnedComments().iterator();
                            if (iterator.hasNext()) {
                                Comment c;
                                comment = c = (Comment)iterator.next();
                            }
                        }
                        if (comment != null && commentText.length() == 0) {
                            comment.destroy();
                            comment = null;
                            return Status.OK_STATUS;
                        }
                        if (commentText.length() == 0) {
                            return Status.CANCEL_STATUS;
                        }
                        if (comment == null) {
                            comment = CommentSection.this.umlElement.createOwnedComment();
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Set Comment Text");
                    comment.setBody(commentText);
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private String removeNonXMLCharacters(String text) {
        StringBuffer newText = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\u201d') {
                newText.append("\"");
            } else if (text.charAt(i) == '\u201c') {
                newText.append("\"");
            } else if (text.charAt(i) == '\u2019') {
                newText.append("'");
            } else if (text.charAt(i) == '\u2018') {
                newText.append("'");
            } else {
                newText.append(text.charAt(i));
            }
            ++i;
        }
        return newText.toString();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        this.bodyText = this.getWidgetFactory().createText(composite, "", 576);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.width = 300;
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.height = 50;
        data.bottom = new FormAttachment(100, 0);
        this.bodyText.setLayoutData((Object)data);
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.umlElement != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlElement)) != null && editingDomain.isReadOnly(this.umlElement.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        if (element instanceof View) {
            element = ((View)element).getElement();
        }
        Assert.isTrue((boolean)(element instanceof Element));
        this.umlElement = (Element)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        Comment comment = null;
        if (this.umlElement instanceof Comment) {
            comment = (Comment)this.umlElement;
        } else {
            Iterator iterator = this.umlElement.getOwnedComments().iterator();
            if (iterator.hasNext()) {
                Comment c;
                comment = c = (Comment)iterator.next();
            }
        }
        String commentText = null;
        if (comment != null) {
            commentText = comment.getBody();
        }
        if (commentText == null) {
            commentText = "";
        }
        this.bodyText.removeModifyListener(this.modifyListener);
        this.bodyText.removeFocusListener(this.focusListener);
        if (commentText != null) {
            this.bodyText.setText(commentText);
        }
        this.bodyText.addModifyListener(this.modifyListener);
        this.bodyText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.bodyText.setEnabled(false);
        } else {
            this.bodyText.setEnabled(true);
        }
    }

    public void update(final Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!CommentSection.this.isDisposed() && !CommentSection.this.isNotifierDeleted(notification)) {
                        CommentSection.this.refresh();
                    }
                }
            });
        }
    }
}

