/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.dialogs;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mdht.uml.common.ui.internal.l10n.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

public class ElementLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_RESOURCE_NAME_POSTFIX = 64;
    private static final AdapterFactory adapterFactory = new UMLItemProviderAdapterFactory();
    private static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    private int m_Flags;

    public ElementLabelProvider(int flags) {
        this.m_Flags = flags;
    }

    private boolean isSet(int flag) {
        return (this.m_Flags & flag) != 0;
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return Messages.ElementLabelProvider_default_package;
        }
        return packName;
    }

    private String getTypeQualifiedName(NamedElement element) {
        String qname = element.getName();
        if (element instanceof Class) {
            while (((Class)element).getNamespace() instanceof Class) {
                qname = String.valueOf(((Class)element).getNamespace().getName()) + "." + qname;
            }
        }
        return qname;
    }

    public String getText(Object element) {
        String packName;
        if (!(element instanceof NamedElement)) {
            return super.getText(element);
        }
        NamedElement namedElement = (NamedElement)element;
        StringBuffer buf = new StringBuffer();
        if (this.isSet(16)) {
            buf.append(namedElement.getName());
        } else if (this.isSet(32)) {
            String containerName = namedElement.getNamespace().getQualifiedName();
            buf.append(this.getPackageName(containerName));
        } else if (this.isSet(4)) {
            packName = namedElement.getNearestPackage().getName();
            buf.append(this.getPackageName(packName));
        } else {
            if (this.isSet(1)) {
                buf.append(namedElement.getQualifiedName());
            } else {
                buf.append(this.getTypeQualifiedName(namedElement));
            }
            if (this.isSet(2)) {
                buf.append(Messages.ElementLabelProvider_dash);
                packName = namedElement.getNearestPackage().getName();
                buf.append(this.getPackageName(packName));
            }
        }
        if (this.isSet(64)) {
            buf.append(Messages.ElementLabelProvider_dash);
            String resourceName = namedElement.eResource().getURI().lastSegment();
            buf.append(resourceName);
        }
        return buf.toString();
    }

    public Image getImage(Object element) {
        return labelProvider.getImage(element);
    }
}

