/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionParserUtility;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;

public class ExpressionHelper {
    private ExpressionParserUtility exprParser = new ExpressionParserUtility();
    private HashMap<String, CompileResult> parsedRowExprs = new HashMap();
    private HashMap<String, CompileResult> parsedDataSetExprs = new HashMap();

    public synchronized String getColumnName(String oldExpression) throws BirtException {
        if (oldExpression == null || oldExpression.trim().length() == 0) {
            return null;
        }
        CompileResult result = this.extractColumnExpressions(oldExpression, "dataSetRow");
        if (result.getColumnReference().size() != 1 || !result.isDirectColumnRef()) {
            return null;
        }
        return ((IColumnBinding)result.getColumnReference().get(0)).getResultSetColumnName();
    }

    public synchronized String getColumnBindingName(String oldExpression) throws BirtException {
        if (oldExpression == null || oldExpression.trim().length() == 0) {
            return null;
        }
        CompileResult result = this.extractColumnExpressions(oldExpression, "row");
        if (result.getColumnReference().size() != 1 || !result.isDirectColumnRef()) {
            return null;
        }
        return ((IColumnBinding)result.getColumnReference().get(0)).getResultSetColumnName();
    }

    private CompileResult extractColumnExpressions(String expression, String indicator) throws BirtException {
        CompileResult result = this.getParsedExpression(expression, indicator);
        if (result != null) {
            return result;
        }
        this.extractExpressions(expression, indicator);
        return this.getParsedExpression(expression, indicator);
    }

    private List extractExpressions(String expression, String indicator) throws BirtException {
        this.exprParser.reset();
        List result = ExpressionParserUtility.compileColumnExpression(this.exprParser, expression, indicator);
        this.cacheParsedExpression(expression, result, indicator);
        return result;
    }

    private void cacheParsedExpression(String expression, List parseResult, String indicator) {
        HashMap<String, CompileResult> cache = this.getExpressionCache(indicator);
        if (cache == null) {
            return;
        }
        cache.put(expression, new CompileResult(parseResult, this.exprParser.hasAggregation(), this.exprParser.isDirectColumnRef()));
    }

    private CompileResult getParsedExpression(String expr, String indicator) {
        HashMap<String, CompileResult> cache = this.getExpressionCache(indicator);
        return cache == null ? null : cache.get(expr);
    }

    private HashMap<String, CompileResult> getExpressionCache(String indicator) {
        if ("dataSetRow".equals(indicator)) {
            return this.parsedDataSetExprs;
        }
        if ("row".equals(indicator)) {
            return this.parsedRowExprs;
        }
        return null;
    }

    public synchronized void close() {
        this.parsedRowExprs.clear();
        this.parsedDataSetExprs.clear();
    }

    class CompileResult {
        boolean hasAggregation = false;
        boolean isDirectColumnRef = false;
        List columnRefs;

        public CompileResult(List columnRefs, boolean hasAggregation, boolean isDirectColumnRef) {
            this.columnRefs = columnRefs;
            this.hasAggregation = hasAggregation;
            this.isDirectColumnRef = isDirectColumnRef;
        }

        public boolean hasAggregation() {
            return this.hasAggregation;
        }

        public boolean isDirectColumnRef() {
            return this.isDirectColumnRef;
        }

        public List getColumnReference() {
            return this.columnRefs;
        }
    }
}

