/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.collectionextract.PairCollectionExtractor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;

public class Pair12CollectionExtractor
extends PairCollectionExtractor {
    public Pair12CollectionExtractor(String field1, String field2) {
        super(field1, field2);
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Object val2 = coll.resolveValue(this.field2);
        if (val2 instanceof IObject) {
            IObject empty;
            IObject obj2 = (IObject)val2;
            if (obj2.getClazz().getName().equals("java.lang.Object") && (empty = this.emptyValue(coll)) != null && obj2.getObjectId() == empty.getObjectId()) {
                return 1;
            }
            return 2;
        }
        return 1 + (val2 != null ? 1 : 0);
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        int id1 = ((IObject)coll.resolveValue(this.field1)).getObjectId();
        if (this.getSize(coll) == 2) {
            IObject value2 = (IObject)coll.resolveValue(this.field2);
            int id2 = value2.getObjectId();
            return new int[]{id1, id2};
        }
        return new int[]{id1};
    }

    protected IObject emptyValue(IObject coll) {
        try {
            Collection<IClass> cl = coll.getSnapshot().getClassesByName("java.util.ImmutableCollections", false);
            if (cl != null && cl.size() >= 1) {
                IClass ic = cl.iterator().next();
                return (IObject)ic.resolveValue("EMPTY");
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        return null;
    }
}

