/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.emf.common.util.EList;

public class CSSHelper {
    public static final String CURSOR_STYLE_PREFIX = "cursor:";
    public static final Map<CursorType, String> CSS_CURSOR_MAP = new HashMap<CursorType, String>();

    static {
        CSS_CURSOR_MAP.put(CursorType.AUTO, "auto");
        CSS_CURSOR_MAP.put(CursorType.CROSSHAIR, "crosshair");
        CSS_CURSOR_MAP.put(CursorType.DEFAULT, "default");
        CSS_CURSOR_MAP.put(CursorType.POINTER, "pointer");
        CSS_CURSOR_MAP.put(CursorType.MOVE, "move");
        CSS_CURSOR_MAP.put(CursorType.TEXT, "text");
        CSS_CURSOR_MAP.put(CursorType.WAIT, "wait");
        CSS_CURSOR_MAP.put(CursorType.ERESIZE, "e-resize");
        CSS_CURSOR_MAP.put(CursorType.NE_RESIZE, "ne-resize");
        CSS_CURSOR_MAP.put(CursorType.NW_RESIZE, "nw-resize");
        CSS_CURSOR_MAP.put(CursorType.NRESIZE, "n-resize");
        CSS_CURSOR_MAP.put(CursorType.SE_RESIZE, "se-resize");
        CSS_CURSOR_MAP.put(CursorType.SW_RESIZE, "sw-resize");
        CSS_CURSOR_MAP.put(CursorType.SRESIZE, "s-resize");
        CSS_CURSOR_MAP.put(CursorType.WRESIZE, "w-resize");
    }

    public static String getCSSCursorValue(Cursor cursor) {
        if (cursor == null || cursor.getType() == null) {
            return null;
        }
        StringBuilder value = new StringBuilder(CURSOR_STYLE_PREFIX);
        value.append(" ");
        if (cursor.getType() != CursorType.CUSTOM) {
            value.append(CSS_CURSOR_MAP.get(cursor.getType())).append(";");
        } else {
            EList cursorImages = cursor.getImage();
            int i = 0;
            for (Image uri : cursorImages) {
                if (uri.getURL() == null || uri.getURL().trim().length() == 0) continue;
                String sUri = uri.getURL();
                if (sUri.startsWith("\"") && sUri.endsWith("\"")) {
                    sUri = sUri.substring(1, sUri.length() - 1);
                }
                if (sUri.trim().length() == 0) continue;
                if (i != 0) {
                    value.append(",");
                }
                value.append("url(").append(sUri).append(")");
                ++i;
            }
            if (cursorImages.size() > 0) {
                value.append(",auto;");
            } else {
                value.append("auto;");
            }
        }
        return value.toString();
    }

    public static String getStylingHyphenFormat(String cssProperties) {
        if (cssProperties == null) {
            return null;
        }
        StringBuilder returnStr = new StringBuilder();
        String[] properties = cssProperties.split(";");
        if (properties == null || properties.length == 0) {
            return cssProperties;
        }
        int j = 0;
        while (j < properties.length) {
            String[] pair;
            if (j != 0) {
                returnStr.append(";");
            }
            if ((pair = properties[j].split(":")) == null || pair.length <= 1) {
                returnStr.append(properties[j]).append(";");
            } else {
                ArrayList<String> words = new ArrayList<String>(3);
                int begin = 0;
                int i = 0;
                while (i < pair[0].length()) {
                    if (Character.isUpperCase(pair[0].charAt(i)) && i != 0) {
                        words.add(pair[0].substring(begin, i).toLowerCase());
                        begin = i;
                    }
                    ++i;
                }
                if (begin != i) {
                    words.add(pair[0].substring(begin, i).toLowerCase());
                }
                StringBuilder sb = new StringBuilder();
                i = 0;
                i = 0;
                while (i < words.size()) {
                    if (i != 0) {
                        sb.append("-");
                    }
                    sb.append((String)words.get(i));
                    ++i;
                }
                returnStr.append((CharSequence)sb);
                i = 1;
                while (i < pair.length) {
                    returnStr.append(":").append(pair[i]);
                    ++i;
                }
            }
            ++j;
        }
        return returnStr.toString();
    }

    public static String getStylingNonHyphenFormat(String cssProperties) {
        if (cssProperties == null) {
            return null;
        }
        StringBuilder returnStr = new StringBuilder();
        String[] properties = cssProperties.split(";");
        if (properties == null || properties.length == 0) {
            return cssProperties;
        }
        int j = 0;
        while (j < properties.length) {
            String[] pair;
            if (j != 0) {
                returnStr.append(";");
            }
            if ((pair = properties[j].split(":")) == null || pair.length <= 1) {
                returnStr.append(properties[j]).append(";");
            } else {
                StringBuilder wordsStr = new StringBuilder();
                String[] words = pair[0].split("-");
                int i = 0;
                while (i < words.length) {
                    if (i == 0) {
                        wordsStr.append(words[i]);
                    } else {
                        wordsStr.append(Character.toUpperCase(words[i].charAt(0))).append(words[i].substring(1));
                    }
                    ++i;
                }
                returnStr.append((CharSequence)wordsStr);
                i = 1;
                while (i < pair.length) {
                    returnStr.append(":").append(pair[i]);
                    ++i;
                }
            }
            ++j;
        }
        return returnStr.toString();
    }
}

