/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.NumberFormat;
import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.FindLeaksQuery;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="find_leaks2")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/leak.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/findingmemoryleak.html")
public class FindLeaksQuery2
implements IQuery {
    private static final Set<String> REFERENCE_FIELD_SET = new HashSet<String>(Arrays.asList("referent"));
    private static final Set<String> UNFINALIZED_REFERENCE_FIELD_SET = new HashSet<String>(Arrays.asList("<" + GCRootInfo.getTypeAsString(1024) + ">"));
    private static final int MAX_DEPTH = 1000;
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.SECONDARY_SNAPSHOT)
    public ISnapshot baseline;
    @Argument(isMandatory=false)
    public int threshold_percent = 2;
    @Argument(isMandatory=false)
    public int max_paths = 10000;
    public double big_drop_ratio = 0.7;
    @Argument(isMandatory=false)
    public String options = "-prefix";
    @Argument(isMandatory=false)
    public Pattern mask = Pattern.compile("\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], ){0,100}\\[[0-9]+\\](,\\.\\.\\.)?$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])");
    @Argument(isMandatory=false, flag="x")
    public String[] extraReferences = new String[]{"java.util.HashMap$Node:key", "java.util.Hashtable$Entry:key", "java.util.WeakHashMap$Entry:referent", "java.util.concurrent.ConcurrentHashMap$Node:key"};
    @Argument(isMandatory=false, flag="xfile")
    public File extraReferencesListFile;
    static final int retainedDiffCol = 5;
    static final int simpleDiffCol = 2;

    public IResult execute(IProgressListener listener) throws Exception {
        long totalHeap = this.baseline.getSnapshotInfo().getUsedHeapSize();
        long threshold = (long)this.threshold_percent * totalHeap / 100L;
        IResultTree baseTree = this.callDominatorTree(listener, this.baseline);
        IResultTree currTree = this.callDominatorTree(listener, this.snapshot);
        String queryId = "comparetablesquery -mode DIFF_RATIO_TO_FIRST";
        if (this.options != null && this.options.length() > 0) {
            queryId = String.valueOf(queryId) + " " + this.options;
        }
        SnapshotQuery queryc = SnapshotQuery.parse(queryId, this.snapshot);
        ArrayList<IResultTree> r = new ArrayList<IResultTree>();
        r.add(baseTree);
        r.add(currTree);
        queryc.setArgument("tables", r);
        ArrayList<ISnapshot> snapshots = new ArrayList<ISnapshot>();
        snapshots.add(this.baseline);
        snapshots.add(this.snapshot);
        queryc.setArgument("snapshots", snapshots);
        if (this.mask != null && this.mask.pattern().length() > 0) {
            queryc.setArgument("mask", this.mask);
        }
        if (this.extraReferences != null && this.extraReferences.length > 0) {
            queryc.setArgument("extraReferences", Arrays.asList(this.extraReferences));
        }
        if (this.extraReferencesListFile != null) {
            queryc.setArgument("extraReferencesListFile", this.extraReferencesListFile);
        }
        RefinedResultBuilder rbc = queryc.refine(listener);
        rbc.setSortOrder(5, Column.SortDirection.DESC);
        final RefinedTree compTree = (RefinedTree)rbc.build();
        List topDominators = compTree.getElements();
        listener.subTask(Messages.FindLeaksQuery_SearchingSingleObjects);
        List provs = compTree.getResultMetaData().getContextProviders();
        ContextProvider cp = (ContextProvider)provs.get(provs.size() - 1);
        ArrayInt suspiciousObjects = new ArrayInt();
        int i = 0;
        HashMapIntObject map = new HashMapIntObject();
        HashMapIntObject rowmap = new HashMapIntObject();
        while (i < topDominators.size()) {
            int objId;
            Object row = topDominators.get(i);
            IContextObject ctx = cp.getContext(row);
            if (ctx != null && (objId = ctx.getObjectId()) >= 0) {
                long deltaRetained = this.readCol((IResultTree)compTree, row, 5);
                IClass cls = this.snapshot.getClassOf(objId);
                if (deltaRetained > threshold) {
                    suspiciousObjects.add(objId);
                    rowmap.put(objId, row);
                } else {
                    ClassRecord cr = (ClassRecord)map.get(cls.getObjectId());
                    if (cr == null) {
                        cr = new ClassRecord(cls.getName(), cls.getObjectId());
                        map.put(cls.getObjectId(), (Object)cr);
                    }
                    long deltaSimple = this.readCol((IResultTree)compTree, row, 2);
                    cr.addObj(objId, deltaSimple, deltaRetained);
                    rowmap.put(objId, row);
                }
            }
            ++i;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        listener.subTask(Messages.FindLeaksQuery_SearchingGroupsOfObjects);
        ArrayList<ClassHistogramRecord> suspiciousClasses = new ArrayList<ClassHistogramRecord>();
        Iterator it = map.values();
        while (it.hasNext()) {
            ClassRecord cr = (ClassRecord)it.next();
            if (cr.retained <= threshold) continue;
            ClassHistogramRecord chr = new ClassHistogramRecord(cr.name, cr.clsId, cr.objs.toArray(), cr.simple, cr.retained);
            suspiciousClasses.add(chr);
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        final SuspectsResultTable ret = this.buildResult(suspiciousObjects, suspiciousClasses, totalHeap, (IResultTree)compTree, (HashMapIntObject<Object>)rowmap, listener);
        compTree.setSelectionProvider(new ISelectionProvider(){

            public boolean isSelected(Object row) {
                if (row == null) {
                    return false;
                }
                List provs = compTree.getResultMetaData().getContextProviders();
                IContextObject co = ((ContextProvider)provs.get(provs.size() - 1)).getContext(row);
                if (co == null) {
                    return false;
                }
                int objId = co.getObjectId();
                if (objId < 0) {
                    return false;
                }
                FindLeaksQuery.SuspectRecord[] suspectRecordArray = ret.getData();
                int n = suspectRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FindLeaksQuery.SuspectRecord sr = suspectRecordArray[n2];
                    if (sr instanceof FindLeaksQuery.SuspectRecordGroupOfObjects) {
                        FindLeaksQuery.SuspectRecordGroupOfObjects srg = (FindLeaksQuery.SuspectRecordGroupOfObjects)sr;
                        int[] nArray = srg.getSuspectInstances();
                        int n3 = nArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int o1 = nArray[n4];
                            if (objId == o1) {
                                return true;
                            }
                            ++n4;
                        }
                    } else if (objId == sr.getSuspect().getObjectId()) {
                        return true;
                    }
                    FindLeaksQuery.AccumulationPoint accumulationPoint = sr.getAccumulationPoint();
                    if (accumulationPoint != null && objId == accumulationPoint.getObject().getObjectId()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isExpanded(Object row) {
                int MAX_EXPAND = 30;
                if (row == null) {
                    return false;
                }
                List provs = compTree.getResultMetaData().getContextProviders();
                IContextObject co = ((ContextProvider)provs.get(provs.size() - 1)).getContext(row);
                if (co == null) {
                    return false;
                }
                int objId = co.getObjectId();
                if (objId < 0) {
                    return false;
                }
                FindLeaksQuery.SuspectRecord[] suspectRecordArray = ret.getData();
                int n = suspectRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FindLeaksQuery.AccumulationPoint accumulationPoint;
                    FindLeaksQuery.SuspectRecord sr = suspectRecordArray[n2];
                    if (sr instanceof FindLeaksQuery.SuspectRecordGroupOfObjects) {
                        FindLeaksQuery.SuspectRecordGroupOfObjects srg = (FindLeaksQuery.SuspectRecordGroupOfObjects)sr;
                        int i = 0;
                        while (i < Math.min(srg.getCommonPath().length - 1, 30)) {
                            if (objId == srg.getCommonPath()[i]) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    if ((accumulationPoint = sr.getAccumulationPoint()) instanceof AccumulationPoint) {
                        AccumulationPoint ap2 = (AccumulationPoint)accumulationPoint;
                        int i = 0;
                        while (i < Math.min(ap2.getPath().length - 1, 30)) {
                            if (objId == ap2.getPath()[i]) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
                return false;
            }
        });
        CompositeResult cr = new CompositeResult(new IResult[0]);
        cr.addResult(Messages.FindLeaksQuery2_ComparedDominatorTrees, (IResult)compTree);
        cr.addResult(Messages.FindLeaksQuery2_Leaks, (IResult)ret);
        return cr;
    }

    private long readCol(IResultTree compTree, Object row, int retainedDiffCol) {
        Object colv = compTree.getColumnValue(row, retainedDiffCol);
        long deltaRetained = colv instanceof Bytes ? ((Bytes)colv).getValue() : (colv instanceof Number ? ((Number)colv).longValue() : 0L);
        return deltaRetained;
    }

    private IResultTree callDominatorTree(IProgressListener listener, ISnapshot snapshot) throws Exception {
        return (IResultTree)SnapshotQuery.lookup("dominator_tree", snapshot).execute(listener);
    }

    private FindLeaksQuery.AccumulationPoint findAccumulationPoint(int bigObjectId, IResultTree tree, Object row) throws SnapshotException {
        int dominator = bigObjectId;
        ArrayInt path = new ArrayInt();
        path.add(dominator);
        List rows = null;
        long dominatorRetainedSize = this.readCol(tree, row, 5);
        List provs = tree.getResultMetaData().getContextProviders();
        ContextProvider cp = (ContextProvider)provs.get(provs.size() - 1);
        int depth = 0;
        while (tree.hasChildren(row) && (rows = tree.getChildren(row)) != null && rows.size() != 0 && depth < 1000) {
            long dominatedRetainedSize = this.readCol(tree, rows.get(0), 5);
            if ((double)dominatedRetainedSize / (double)dominatorRetainedSize < this.big_drop_ratio) {
                return new AccumulationPoint(this.snapshot.getObject(dominator), dominatorRetainedSize, path.toArray());
            }
            dominatorRetainedSize = dominatedRetainedSize;
            row = rows.get(0);
            dominator = cp.getContext(row).getObjectId();
            path.add(dominator);
            ++depth;
        }
        if (rows == null || rows.size() == 0) {
            return new AccumulationPoint(this.snapshot.getObject(dominator), dominatorRetainedSize, path.toArray());
        }
        return null;
    }

    private FindLeaksQuery.SuspectRecord buildSuspectRecordGroupOfObjects(ClassHistogramRecord record, IResultTree tree, HashMapIntObject<Object> rowmap, IProgressListener listener) throws SnapshotException {
        int[] objectIds = this.getRandomIds(record.getObjectIds());
        IObject suspectClass = this.snapshot.getObject(record.getClassId());
        List provs = tree.getResultMetaData().getContextProviders();
        HashMap<IClass, Set<String>> excludeMap = new HashMap<IClass, Set<String>>();
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.WeakReference", true);
        if (classes != null) {
            for (IClass clazz : classes) {
                excludeMap.put(clazz, REFERENCE_FIELD_SET);
            }
        }
        if ((classes = this.snapshot.getClassesByName("java.lang.Runtime", false)) != null) {
            for (IClass clazz : classes) {
                excludeMap.put(clazz, UNFINALIZED_REFERENCE_FIELD_SET);
            }
        }
        IMultiplePathsFromGCRootsComputer comp = this.snapshot.getMultiplePathsFromGCRoots(objectIds, excludeMap);
        MultiplePathsFromGCRootsRecord[] records = comp.getPathsByGCRoot(listener);
        ArrayIntBig commonPath = new ArrayIntBig();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (records.length > 0) {
            int numPaths = comp.getAllPaths(listener).length;
            int diff = objectIds.length - numPaths;
            if (diff > 0) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.FindLeaksQuery_PathNotFound, (Object[])new Object[]{diff, objectIds.length}), null);
            }
            this.setRetainedSizesForMPaths(records, this.snapshot);
            Arrays.sort(records, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
            MultiplePathsFromGCRootsRecord parentRecord = records[0];
            int threshold = (int)(0.8 * (double)objectIds.length);
            Object row = null;
            while (parentRecord.getCount() > threshold) {
                MultiplePathsFromGCRootsRecord[] children;
                commonPath.add(parentRecord.getObjectId());
                if (row == null) {
                    row = rowmap.get(parentRecord.getObjectId());
                }
                if ((children = parentRecord.nextLevel()) == null || children.length == 0) {
                    int[] path = commonPath.toArray();
                    FindLeaksQuery.AccumulationPoint accPoint = new FindLeaksQuery.AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()));
                    if (rowmap.get(parentRecord.getObjectId()) == row) {
                        long deltaRetained = this.readCol(tree, row, 5);
                        accPoint = new AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()), deltaRetained, path);
                    }
                    FindLeaksQuery.SuspectRecordGroupOfObjects result = new FindLeaksQuery.SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), accPoint, commonPath.toArray(), comp);
                    return result;
                }
                this.setRetainedSizesForMPaths(children, this.snapshot);
                Arrays.sort(children, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
                long childReferencedRetainedSize = children[0].getReferencedRetainedSize();
                if (row != null && tree.hasChildren(row)) {
                    for (Object row2 : tree.getChildren(row)) {
                        IContextObject co = ((ContextProvider)provs.get(provs.size() - 1)).getContext(row2);
                        if (co == null || co.getObjectId() != children[0].getObjectId()) continue;
                        row = row2;
                        break;
                    }
                }
                if ((double)childReferencedRetainedSize / (double)parentRecord.getReferencedRetainedSize() < this.big_drop_ratio) {
                    int[] path = commonPath.toArray();
                    FindLeaksQuery.AccumulationPoint accPoint = new FindLeaksQuery.AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()));
                    if (rowmap.get(parentRecord.getObjectId()) == row) {
                        long deltaRetained = this.readCol(tree, row, 5);
                        accPoint = new AccumulationPoint(this.snapshot.getObject(parentRecord.getObjectId()), deltaRetained, path);
                    }
                    FindLeaksQuery.SuspectRecordGroupOfObjects result = new FindLeaksQuery.SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), accPoint, path, comp);
                    return result;
                }
                parentRecord = children[0];
            }
        }
        return new FindLeaksQuery.SuspectRecordGroupOfObjects(suspectClass, record.getObjectIds(), record.getRetainedHeapSize(), null, commonPath.toArray(), comp);
    }

    private void setRetainedSizesForMPaths(MultiplePathsFromGCRootsRecord[] records, ISnapshot snapshot) throws SnapshotException {
        MultiplePathsFromGCRootsRecord[] multiplePathsFromGCRootsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            MultiplePathsFromGCRootsRecord rec = multiplePathsFromGCRootsRecordArray[n2];
            int[] referencedObjects = rec.getReferencedObjects();
            long retained = 0L;
            int[] nArray = referencedObjects;
            int n3 = referencedObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                int objectId = nArray[n4];
                retained += snapshot.getRetainedHeapSize(objectId);
                ++n4;
            }
            rec.setReferencedRetainedSize(retained);
            ++n2;
        }
    }

    private SuspectsResultTable buildResult(ArrayInt suspiciousObjects, ArrayList<ClassHistogramRecord> suspiciousClasses, long totalHeap, IResultTree tree, HashMapIntObject<Object> rowmap, IProgressListener listener) throws SnapshotException {
        int[] suspectObjIds;
        FindLeaksQuery.SuspectRecord[] allSuspects = new FindLeaksQuery.SuspectRecord[suspiciousObjects.size() + suspiciousClasses.size()];
        int j = 0;
        int[] nArray = suspectObjIds = suspiciousObjects.toArray();
        int n = suspectObjIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deltaRetained;
            int objectId = nArray[n2];
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            IObject suspectObject = this.snapshot.getObject(objectId);
            FindLeaksQuery.AccumulationPoint accPoint = this.findAccumulationPoint(objectId, tree, rowmap.get(objectId));
            long suspectObjectRetained = suspectObject.getRetainedHeapSize();
            Object row = rowmap.get(objectId);
            suspectObjectRetained = deltaRetained = this.readCol(tree, row, 5);
            FindLeaksQuery.SuspectRecord r = new FindLeaksQuery.SuspectRecord(suspectObject, suspectObjectRetained, accPoint);
            allSuspects[j++] = r;
            ++n2;
        }
        for (ClassHistogramRecord record : suspiciousClasses) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            FindLeaksQuery.SuspectRecord r = this.buildSuspectRecordGroupOfObjects(record, tree, rowmap, listener);
            allSuspects[j++] = r;
        }
        return new SuspectsResultTable(allSuspects, totalHeap);
    }

    private int[] getRandomIds(int[] objectIds) {
        if (objectIds.length <= this.max_paths) {
            return objectIds;
        }
        MATPlugin.log((IStatus)new Status(1, "org.eclipse.mat.api", MessageUtil.format((String)Messages.FindLeaksQuery_TooManySuspects, (Object[])new Object[]{objectIds.length, this.max_paths})));
        Random random = new Random();
        int length = objectIds.length;
        BitField visited = new BitField(length);
        int[] result = new int[this.max_paths];
        int i = 0;
        while (i < this.max_paths) {
            int index = random.nextInt(length);
            while (visited.get(index)) {
                index = random.nextInt(length);
            }
            visited.set(index);
            result[i] = objectIds[index];
            ++i;
        }
        return result;
    }

    public static class AccumulationPoint
    extends FindLeaksQuery.AccumulationPoint {
        long retainedSize;
        int[] path;

        public AccumulationPoint(IObject object, long retainedSize, int[] path) {
            super(object);
            this.retainedSize = retainedSize;
            this.path = (int[])path.clone();
        }

        @Override
        public long getRetainedHeapSize() {
            return this.retainedSize;
        }

        public int[] getPath() {
            return (int[])this.path.clone();
        }
    }

    private static class ClassRecord {
        String name;
        int clsId;
        ArrayInt objs;
        long simple;
        long retained;

        public ClassRecord(String name, int id) {
            this.name = name;
            this.clsId = id;
            this.objs = new ArrayInt();
        }

        public void addObj(int obj, long simple, long retained) {
            this.objs.add(obj);
            this.simple += simple;
            this.retained += retained;
        }
    }

    public static class SuspectsResultTable
    extends FindLeaksQuery.SuspectsResultTable {
        public SuspectsResultTable(FindLeaksQuery.SuspectRecord[] data, long totalHeap) {
            super(data, totalHeap);
        }

        @Override
        public Column[] getColumns() {
            return new Column[]{new Column(Messages.FindLeaksQuery_ColumnLeakSuspect), new Column(Messages.FindLeaksQuery_Column_NumObjects, Long.class), new Column(Messages.FindLeaksQuery2_Column_SuspectRetainedHeap, Bytes.class), new Column(Messages.FindLeaksQuery_Column_SuspectPercent, Double.class).formatting((Format)NumberFormat.getPercentInstance()), new Column(Messages.FindLeaksQuery_Column_AccumulationPoint), new Column(Messages.FindLeaksQuery2_Column_AccPointRetainedHeap, Bytes.class), new Column(Messages.FindLeaksQuery_Column_AccPointPercent, Double.class).formatting((Format)NumberFormat.getPercentInstance())};
        }
    }
}

