/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.internal;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.lsp4e.internal.HumanFriendlyComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HumanFriendlyComparatorTest {
    @Test
    public void testNumericSorting() {
        List<String> input = Arrays.asList("file10.txt", "file2.txt", "file1.txt", "file100.txt");
        List<String> expected = Arrays.asList("file1.txt", "file2.txt", "file10.txt", "file100.txt");
        input.sort((Comparator<String>)HumanFriendlyComparator.DEFAULT);
        Assertions.assertEquals(expected, input);
    }

    @Test
    public void testMixedTextAndNumbers() {
        List<String> input = Arrays.asList("a10b", "a2b", "a10a", "a2a");
        List<String> expected = Arrays.asList("a2a", "a2b", "a10a", "a10b");
        input.sort((Comparator<String>)HumanFriendlyComparator.DEFAULT);
        Assertions.assertEquals(expected, input);
    }

    @Test
    public void testLocaleSpecificSorting() {
        List<String> input = Arrays.asList("\u00e42", "a10", "a2", "\u00e410", "\u00e1100", "A2");
        List<String> expected = Arrays.asList("a2", "a10", "A2", "\u00e1100", "\u00e42", "\u00e410");
        Collator collator = Collator.getInstance(Locale.GERMAN);
        collator.setStrength(2);
        HumanFriendlyComparator comparator = new HumanFriendlyComparator(collator);
        input.sort((Comparator<String>)comparator);
        Assertions.assertEquals(expected, input);
    }

    @Test
    public void testLeadingZeros() {
        List<String> input = Arrays.asList("file002.txt", "file2.txt", "file0002.txt", "file01.txt");
        List<String> expected = Arrays.asList("file01.txt", "file2.txt", "file002.txt", "file0002.txt");
        input.sort((Comparator<String>)HumanFriendlyComparator.DEFAULT);
        Assertions.assertEquals(expected, input);
    }

    @Test
    public void testEmptyStringsAndSpecialCases() {
        List<String> input = Arrays.asList("", "file", "file10", "file2", "file 10", "file 2", "file2", " ");
        List<String> expected = Arrays.asList("", " ", "file", "file2", "file2", "file10", "file 2", "file 10");
        input.sort((Comparator<String>)HumanFriendlyComparator.DEFAULT);
        Assertions.assertEquals(expected, input);
    }
}

