/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Test;

public class RunningLanguageServerTest
extends AbstractTestWithProject {
    @Test
    public void testOpenCloseLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        int i = 1;
        while (i <= 10) {
            IEditorPart editor = TestUtils.openEditor(testFile);
            Assert.assertFalse((boolean)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> true).isEmpty());
            TestUtils.waitForAndAssertCondition("MockLanguageServer should be started for iteration #" + i, 5000, () -> MockLanguageServer.INSTANCE.isRunning());
            ((AbstractTextEditor)editor).close(false);
            TestUtils.waitForAndAssertCondition("MockLanguageServer should be stopped after iteration #" + i, 5000, () -> !MockLanguageServer.INSTANCE.isRunning());
            ++i;
        }
    }

    @Test
    public void testDisabledLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(false);
        LanguageServiceAccessor.disableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition);
        TestUtils.openEditor(testFile);
        @NonNull List initializedLanguageServers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> true);
        Assert.assertNotNull((Object)initializedLanguageServers);
        Assert.assertEquals((String)"language server should not be started because it is disabled", (long)0L, (long)initializedLanguageServers.size());
        lsDefinition.setUserEnabled(true);
        LanguageServiceAccessor.enableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition, (IEditorReference[])TestUtils.getEditors());
        TestUtils.waitForAndAssertCondition("language server should be started", 5000, () -> MockLanguageServer.INSTANCE.isRunning());
    }

    @Test
    public void testBug535887DisabledWithMultipleOpenFiles() throws CoreException {
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(true);
        LanguageServiceAccessor.enableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition, (IEditorReference[])TestUtils.getEditors());
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        TestUtils.openEditor(testFile1);
        TestUtils.openEditor(testFile2);
        lsDefinition.setUserEnabled(false);
        LanguageServiceAccessor.disableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition);
    }

    @Test
    public void testDelayedStopDoesntCauseFreeze() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        IWorkbenchPage page = editor.getSite().getPage();
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(10000L);
        long before = System.currentTimeMillis();
        page.closeEditor(editor, false);
        Assert.assertTrue((System.currentTimeMillis() - before < 1000L ? 1 : 0) != 0);
    }
}

