/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.OffsetDateTime;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LoggingStreamConnectionProviderProxy
implements StreamConnectionProvider,
IAdaptable {
    private static final String FILE_KEY = "file.logging.enabled";
    private static final String STDERR_KEY = "stderr.logging.enabled";
    private final StreamConnectionProvider provider;
    private @Nullable InputStream inputStream;
    private @Nullable OutputStream outputStream;
    private @Nullable InputStream errorStream;
    private final String id;
    private final @Nullable File logFile;
    private boolean logToFile;
    private boolean logToConsole;
    private @Nullable MessageConsoleStream consoleStream;

    public static @Nullable File getLogDirectory() {
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (root == null) {
            return null;
        }
        File logFolder = new File(root.addTrailingSeparator().toPortableString(), "languageServers-log");
        if (!logFolder.exists() && !logFolder.mkdirs() || !logFolder.isDirectory() || !logFolder.canWrite()) {
            return null;
        }
        return logFolder;
    }

    public static String lsToFileLoggingId(String serverId) {
        return serverId + ".file.logging.enabled";
    }

    public static String lsToConsoleLoggingId(String serverId) {
        return serverId + ".stderr.logging.enabled";
    }

    public static boolean shouldLog(String serverId) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId)) || store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
    }

    public LoggingStreamConnectionProviderProxy(StreamConnectionProvider provider, String serverId) {
        this.id = serverId;
        this.provider = provider;
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        this.logToFile = store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId));
        this.logToConsole = store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
        store.addPropertyChangeListener(event -> {
            Object object;
            Object object2;
            if (event.getProperty().equals(FILE_KEY) && (object2 = event.getNewValue()) instanceof Boolean) {
                Boolean newValue = (Boolean)object2;
                this.logToFile = newValue;
            } else if (event.getProperty().equals(STDERR_KEY) && (object = event.getNewValue()) instanceof Boolean) {
                Boolean newValue = (Boolean)object;
                this.logToConsole = newValue;
            }
        });
        this.logFile = this.getLogFile();
    }

    private String message(Direction direction, byte[] payload) {
        String now = OffsetDateTime.now().toString();
        StringBuilder builder = new StringBuilder(payload.length + this.id.length() + direction.toString().length() + now.length() + 10);
        builder.append("\n[");
        builder.append(now);
        builder.append("] ");
        builder.append((Object)direction);
        builder.append(' ');
        builder.append(this.id);
        builder.append(":\n");
        builder.append(new String(payload, StandardCharsets.UTF_8));
        return builder.toString();
    }

    private String errorMessage(byte[] payload) {
        return this.message(Direction.ERROR_FROM_LANGUAGE_SERVER, payload);
    }

    @Override
    public @Nullable InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.provider.getInputStream() != null) {
            this.inputStream = new FilterInputStream(this.provider.getInputStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = LoggingStreamConnectionProviderProxy.this.message(Direction.LANGUAGE_SERVER_TO_LSP4E, payload);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    return bytes;
                }
            };
        }
        return this.inputStream;
    }

    public <T> @Nullable T getAdapter(@Nullable Class<T> adapter) {
        if (adapter == ProcessHandle.class) {
            return (T)Adapters.adapt((Object)this.provider, adapter);
        }
        return null;
    }

    @Override
    public @Nullable InputStream getErrorStream() {
        if (this.errorStream != null) {
            return this.errorStream;
        }
        if (this.provider.getErrorStream() != null) {
            this.errorStream = new FilterInputStream(this.provider.getErrorStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = LoggingStreamConnectionProviderProxy.this.errorMessage(payload);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    return bytes;
                }
            };
        }
        return this.errorStream;
    }

    @Override
    public @Nullable OutputStream getOutputStream() {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.provider.getOutputStream() != null) {
            this.outputStream = new FilterOutputStream(this.provider.getOutputStream()){

                @Override
                public void write(byte[] b) throws IOException {
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = LoggingStreamConnectionProviderProxy.this.message(Direction.LSP4E_TO_LANGUAGE_SERVER, b);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    super.write(b);
                }
            };
        }
        return this.outputStream;
    }

    @Override
    public void start() throws IOException {
        this.provider.start();
    }

    @Override
    public @Nullable InputStream forwardCopyTo(@Nullable InputStream input, @Nullable OutputStream output) {
        return this.provider.forwardCopyTo(input, output);
    }

    @Override
    public @Nullable Object getInitializationOptions(@Nullable URI rootUri) {
        return this.provider.getInitializationOptions(rootUri);
    }

    @Override
    public String getTrace(@Nullable URI rootUri) {
        return this.provider.getTrace(rootUri);
    }

    @Override
    public void handleMessage(Message message, LanguageServer languageServer, @Nullable URI rootURI) {
        this.provider.handleMessage(message, languageServer, rootURI);
    }

    @Override
    public void stop() {
        this.provider.stop();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private void logToConsole(String string) {
        MessageConsoleStream consoleStream = this.consoleStream;
        if (consoleStream == null || consoleStream.isClosed()) {
            consoleStream = this.consoleStream = this.findConsole().newMessageStream();
        }
        consoleStream.println(string);
    }

    private MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = conMan.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole existing = iConsoleArray[n2];
            if (Messages.LSConsoleName.equals(existing.getName())) {
                return (MessageConsole)existing;
            }
            ++n2;
        }
        MessageConsole myConsole = new MessageConsole(Messages.LSConsoleName, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void logToFile(String string) {
        File logFile = this.logFile;
        if (logFile == null) {
            return;
        }
        if (!logFile.exists()) {
            try {
                if (!logFile.createNewFile()) {
                    throw new IOException(String.format("Failed to create file %s", logFile));
                }
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        try {
            Files.write(logFile.toPath(), string.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private @Nullable File getLogFile() {
        if (this.logFile != null) {
            return this.logFile;
        }
        File logFolder = LoggingStreamConnectionProviderProxy.getLogDirectory();
        if (logFolder == null) {
            return null;
        }
        File file = new File(logFolder, this.id + ".log");
        if (!(!file.exists() || file.isFile() && file.canWrite())) {
            return null;
        }
        return file;
    }

    private static enum Direction {
        LANGUAGE_SERVER_TO_LSP4E,
        LSP4E_TO_LANGUAGE_SERVER,
        ERROR_FROM_LANGUAGE_SERVER;

    }
}

