/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.format.IFormatRegionsProvider;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSaveReason;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

final class DocumentContentSynchronizer
implements IDocumentListener {
    private final @NonNull LanguageServerWrapper languageServerWrapper;
    private final @NonNull IDocument document;
    private final @NonNull URI fileUri;
    private final TextDocumentSyncKind syncKind;
    private int version = 0;
    private DidChangeTextDocumentParams changeParams;
    private long openSaveStamp;
    private IPreferenceStore store;
    private IFormatRegionsProvider formatRegionsProvider;
    private static final String WILL_SAVE_WAIT_UNTIL_TIMEOUT__KEY = "timeout.willSaveWaitUntil";
    private static final int WILL_SAVE_WAIT_UNTIL_COUNT_THRESHOLD = 3;
    private static final Map<String, Integer> WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP = new ConcurrentHashMap<String, Integer>();

    public DocumentContentSynchronizer(@NonNull LanguageServerWrapper languageServerWrapper, @NonNull LanguageServer languageServer, @NonNull IDocument document, TextDocumentSyncKind syncKind) {
        this.languageServerWrapper = languageServerWrapper;
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            throw new NullPointerException();
        }
        this.fileUri = uri;
        try {
            IFileStore store = EFS.getStore((URI)this.fileUri);
            this.openSaveStamp = store.fetchInfo().getLastModified();
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            this.openSaveStamp = new File(this.fileUri).lastModified();
        }
        this.syncKind = syncKind != null ? syncKind : TextDocumentSyncKind.Full;
        this.document = document;
        this.store = LanguageServerPlugin.getDefault().getPreferenceStore();
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setUri(this.fileUri.toASCIIString());
        textDocument.setText(document.get());
        List<IContentType> contentTypes = LSPEclipseUtils.getDocumentContentTypes(this.document);
        String languageId = languageServerWrapper.getLanguageId(contentTypes.toArray(new IContentType[0]));
        IPath fromPortableString = Path.fromPortableString((String)this.fileUri.getPath());
        if (languageId == null && (languageId = fromPortableString.getFileExtension()) == null) {
            languageId = fromPortableString.lastSegment();
        }
        textDocument.setLanguageId(languageId);
        textDocument.setVersion(++this.version);
        languageServer.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocument));
    }

    public void documentChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Full) {
            this.createChangeEvent(event);
        }
        if (this.changeParams != null) {
            DidChangeTextDocumentParams changeParamsToSend = this.changeParams;
            this.changeParams = null;
            changeParamsToSend.getTextDocument().setVersion(Integer.valueOf(++this.version));
            this.languageServerWrapper.sendNotification(ls -> ls.getTextDocumentService().didChange(changeParamsToSend));
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Incremental) {
            this.createChangeEvent(event);
        }
    }

    private boolean createChangeEvent(DocumentEvent event) {
        Assert.isTrue((this.changeParams == null ? 1 : 0) != 0);
        this.changeParams = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(), Collections.singletonList(new TextDocumentContentChangeEvent()));
        this.changeParams.getTextDocument().setUri(this.fileUri.toASCIIString());
        IDocument document = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = null;
        TextDocumentSyncKind syncKind = this.getTextDocumentSyncKind();
        switch (syncKind) {
            case None: {
                return false;
            }
            case Full: {
                ((TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0)).setText(event.getDocument().get());
                break;
            }
            case Incremental: {
                changeEvent = (TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0);
                String newText = event.getText();
                int offset = event.getOffset();
                int length = event.getLength();
                try {
                    Range range = new Range(LSPEclipseUtils.toPosition(offset, document), LSPEclipseUtils.toPosition(offset + length, document));
                    changeEvent.setRange(range);
                    changeEvent.setText(newText);
                    changeEvent.setRangeLength(Integer.valueOf(length));
                    break;
                }
                catch (BadLocationException e) {
                    changeEvent.setText(document.get());
                }
            }
        }
        return true;
    }

    private boolean serverSupportsWillSaveWaitUntil() {
        Either textDocumentSync;
        ServerCapabilities serverCapabilities = this.languageServerWrapper.getServerCapabilities();
        if (serverCapabilities != null && (textDocumentSync = serverCapabilities.getTextDocumentSync()).isRight()) {
            TextDocumentSyncOptions saveOptions = (TextDocumentSyncOptions)textDocumentSync.getRight();
            return saveOptions != null && Boolean.TRUE.equals(saveOptions.getWillSaveWaitUntil());
        }
        return false;
    }

    private static @NonNull String lsToWillSaveWaitUntilTimeoutKey(String serverId) {
        return String.valueOf(serverId) + '.' + WILL_SAVE_WAIT_UNTIL_TIMEOUT__KEY;
    }

    private int lsToWillSaveWaitUntilTimeout() {
        int defaultWillSaveWaitUntilTimeoutInSeconds = 5;
        int willSaveWaitUntilTimeout = this.store.getInt(DocumentContentSynchronizer.lsToWillSaveWaitUntilTimeoutKey(this.languageServerWrapper.serverDefinition.id));
        return willSaveWaitUntilTimeout != 0 ? willSaveWaitUntilTimeout : defaultWillSaveWaitUntilTimeoutInSeconds;
    }

    public void documentAboutToBeSaved() {
        if (!this.serverSupportsWillSaveWaitUntil()) {
            this.formatDocument();
            return;
        }
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.fileUri);
        if (WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.getOrDefault(identifier.getUri(), 0) > 3) {
            return;
        }
        WillSaveTextDocumentParams params = new WillSaveTextDocumentParams(identifier, TextDocumentSaveReason.Manual);
        try {
            List edits = (List)this.languageServerWrapper.executeImpl(ls -> ls.getTextDocumentService().willSaveWaitUntil(params)).get(this.lsToWillSaveWaitUntilTimeout(), TimeUnit.SECONDS);
            try {
                LSPEclipseUtils.applyEdits(this.document, edits);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (TimeoutException e) {
            Integer timeoutCount = WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.compute(identifier.getUri(), (k, v) -> v == null ? 1 : Integer.valueOf(v + 1));
            String message = timeoutCount > 3 ? Messages.DocumentContentSynchronizer_TimeoutThresholdMessage : Messages.DocumentContentSynchronizer_TimeoutMessage;
            String boundMessage = NLS.bind((String)message, (Object)Integer.toString(this.lsToWillSaveWaitUntilTimeout()), (Object)identifier.getUri());
            ServerMessageHandler.showMessage(Messages.DocumentContentSynchronizer_OnSaveActionTimeout, new MessageParams(MessageType.Error, boundMessage));
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
    }

    private void formatDocument() {
        IRegion[] regions = this.getFormatRegions();
        if (regions != null && this.document != null) {
            try {
                MultiTextSelection textSelection = new MultiTextSelection(this.document, regions);
                VersionedEdits edits = this.requestFormatting(this.document, (ITextSelection)textSelection).get(this.lsToWillSaveWaitUntilTimeout(), TimeUnit.SECONDS);
                if (edits != null) {
                    try {
                        edits.apply();
                    }
                    catch (ConcurrentModificationException ex) {
                        ServerMessageHandler.showMessage(Messages.LSPFormatHandler_DiscardedFormat, new MessageParams(MessageType.Error, Messages.LSPFormatHandler_DiscardedFormatResponse));
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    private synchronized IRegion[] getFormatRegions() {
        if (this.formatRegionsProvider != null) {
            return this.formatRegionsProvider.getFormattingRegions(this.document);
        }
        String serverId = "(serverDefinitionId=" + this.languageServerWrapper.serverDefinition.id + ")";
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        if (bundleContext != null) {
            try {
                ServiceReference reference = null;
                ServiceReference[] serviceReferences = bundleContext.getAllServiceReferences(IFormatRegionsProvider.class.getName(), serverId);
                reference = serviceReferences != null ? serviceReferences[0] : bundleContext.getServiceReference(IFormatRegionsProvider.class.getName());
                if (reference != null) {
                    this.formatRegionsProvider = (IFormatRegionsProvider)bundleContext.getService(reference);
                    if (this.formatRegionsProvider != null) {
                        return this.formatRegionsProvider.getFormattingRegions(this.document);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    private CompletableFuture<VersionedEdits> requestFormatting(@NonNull IDocument document, @NonNull ITextSelection textSelection) throws BadLocationException {
        long modificationStamp = DocumentUtil.getDocumentModificationStamp(document);
        FormattingOptions formatOptions = LSPFormatter.getFormatOptions();
        TextDocumentIdentifier docId = new TextDocumentIdentifier(this.fileUri.toString());
        ServerCapabilities capabilities = this.languageServerWrapper.getServerCapabilities();
        if (LSPFormatter.isDocumentRangeFormattingSupported(capabilities) && (!LSPFormatter.isDocumentFormattingSupported(capabilities) || textSelection.getLength() != 0)) {
            DocumentRangeFormattingParams rangeParams = LSPFormatter.getRangeFormattingParams(document, textSelection, formatOptions, docId);
            return this.languageServerWrapper.executeImpl(ls -> ls.getTextDocumentService().rangeFormatting(rangeParams).thenApply(edits -> new VersionedEdits(modificationStamp, (List<? extends TextEdit>)edits, document)));
        }
        DocumentFormattingParams params = LSPFormatter.getFullFormatParams(formatOptions, docId);
        return this.languageServerWrapper.executeImpl(ls -> ls.getTextDocumentService().formatting(params).thenApply(edits -> new VersionedEdits(modificationStamp, (List<? extends TextEdit>)edits, document)));
    }

    public void documentSaved(IFileBuffer buffer) {
        Either textDocumentSync;
        if (this.openSaveStamp >= buffer.getModificationStamp()) {
            return;
        }
        this.openSaveStamp = buffer.getModificationStamp();
        ServerCapabilities serverCapabilities = this.languageServerWrapper.getServerCapabilities();
        if (serverCapabilities != null && (textDocumentSync = serverCapabilities.getTextDocumentSync()).isRight() && ((TextDocumentSyncOptions)textDocumentSync.getRight()).getSave() == null) {
            return;
        }
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.fileUri);
        DidSaveTextDocumentParams params = new DidSaveTextDocumentParams(identifier, this.document.get());
        this.languageServerWrapper.sendNotification(ls -> ls.getTextDocumentService().didSave(params));
    }

    public CompletableFuture<Void> documentClosed() {
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.fileUri);
        WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.remove(identifier.getUri());
        if (this.languageServerWrapper.isActive()) {
            DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(identifier);
            this.languageServerWrapper.sendNotification(ls -> ls.getTextDocumentService().didClose(params));
        }
        return CompletableFuture.completedFuture(null);
    }

    private TextDocumentSyncKind getTextDocumentSyncKind() {
        return this.syncKind;
    }

    public IDocument getDocument() {
        return this.document;
    }

    int getVersion() {
        return this.version;
    }

    private void checkEvent(DocumentEvent event) {
        if (this.document != event.getDocument()) {
            throw new IllegalStateException("Synchronizer should apply to only a single document, which is the one it was instantiated for");
        }
    }
}

