/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockTextDocumentService;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidChangeTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentDidChangeTest" + System.currentTimeMillis());
    }

    @Test
    public void testIncrementalSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                TextDocumentSyncKind syncKind = DocumentDidChangeTest.this.getDocumentSyncKind(t);
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)syncKind);
                return true;
            }
        });
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hello", (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " ");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)5L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)" ", (Object)change0.getText());
        viewer.getDocument().replace(0, 5, "Hallo");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(3));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(2);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)5, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hallo", (Object)change0.getText());
    }

    @Test
    public void testIncrementalSync_deleteLastLine() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        String multiLineText = "line1\nline2\nline3\n";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, multiLineText);
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        viewer.getDocument().replace("line1\nline2\n".length(), "line3\n".length(), "");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)2L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)3L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)6, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"", (Object)change0.getText());
    }

    @Test
    public void testIncrementalEditOrdering() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        StyledText text = viewer.getTextWidget();
        int i = 0;
        while (i < 500) {
            text.append(String.valueOf(i) + "\n");
            ++i;
        }
        TestUtils.waitForAndAssertCondition(10000, TestUtils.numberOfChangesIs(500));
        List changes = MockLanguageServer.INSTANCE.getDidChangeEvents();
        int i2 = 0;
        while (i2 < 500) {
            String delta = ((TextDocumentContentChangeEvent)((DidChangeTextDocumentParams)changes.get(i2)).getContentChanges().get(0)).getText();
            Assert.assertEquals((Object)(String.valueOf(i2) + "\n"), (Object)delta);
            ++i2;
        }
    }

    @Test
    @Ignore(value="This test is currently failing because of synchronization issues.\nSee various discussion at\n* https://github.com/eclipse/lsp4e/pull/251\n* https://github.com/eclipse/lsp4e/pull/318#issuecomment-1330738521\n* ...\nAbout ensuring the order to requests performed by the client is respected\ndespite usage of `then...Async` to avoid blocking UI Thread.\n")
    public void editInterleavingTortureTest() throws Exception {
        final Vector<Integer> tooEarlyHover = new Vector<Integer>();
        final Vector<Integer> tooLateHover = new Vector<Integer>();
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){
            int changeVersion;
            {
                super($anonymous0);
                this.changeVersion = 0;
            }

            public synchronized void didChange(DidChangeTextDocumentParams params) {
                super.didChange(params);
                ++this.changeVersion;
            }

            public synchronized CompletableFuture<Hover> hover(HoverParams position) {
                int targetVersionForRequest = position.getPosition().getCharacter();
                if (targetVersionForRequest < this.changeVersion) {
                    tooLateHover.add(targetVersionForRequest);
                } else if (targetVersionForRequest > this.changeVersion) {
                    tooEarlyHover.add(targetVersionForRequest);
                }
                return super.hover(position);
            }
        });
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setHover(hoverResponse);
        CompletableFuture<Object> initial = CompletableFuture.completedFuture(null);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        IDocument document = viewer.getDocument();
        URI uri = LSPEclipseUtils.toUri((IDocument)document);
        StyledText text = viewer.getTextWidget();
        Thread.sleep(1000L);
        int i2 = 0;
        while (i2 < 5000) {
            int current = i2 + 1;
            text.append(String.valueOf(i2) + "\n");
            HoverParams params = new HoverParams();
            Position position = new Position();
            position.setCharacter(current);
            position.setLine(0);
            params.setPosition(position);
            CompletionStage hoverFuture = LanguageServiceAccessor.getLanguageServers((IDocument)document, capabilities -> LSPEclipseUtils.hasCapability((Either)capabilities.getHoverProvider())).thenApply(languageServers -> languageServers.stream().map(languageServer -> {
                try {
                    return languageServer.getTextDocumentService().hover(params);
                }
                catch (Exception exception) {
                    return CompletableFuture.completedFuture(null);
                }
            }).collect(Collectors.toList()));
            initial = CompletableFuture.allOf(new CompletableFuture[]{initial, hoverFuture});
            ++i2;
        }
        initial.join();
        StringBuilder message = new StringBuilder();
        message.append("Too Early hover requests: ");
        message.append(tooEarlyHover.size());
        message.append(System.lineSeparator());
        tooEarlyHover.forEach(i -> {
            message.append("  Too Early ");
            message.append(i);
            message.append(System.lineSeparator());
        });
        message.append("Too Late hover requests: ");
        message.append(tooLateHover.size());
        message.append(System.lineSeparator());
        tooLateHover.forEach(i -> {
            message.append("  Too Late ");
            message.append(i);
            message.append(System.lineSeparator());
        });
        Assert.assertTrue((String)message.toString(), (tooEarlyHover.isEmpty() && tooLateHover.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testFullSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        String text = "Hello";
        viewer.getDocument().replace(0, 0, text);
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)text, (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    @Test
    public void testFullSyncExternalFile() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        File file = TestUtils.createTempFile("testFullSyncExternalFile", ".lspt");
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        String text = "Hello";
        viewer.getDocument().replace(0, 0, text);
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)text, (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    private TextDocumentSyncKind getDocumentSyncKind(ServerCapabilities t) {
        TextDocumentSyncKind syncKind = null;
        if (t.getTextDocumentSync().isLeft()) {
            syncKind = (TextDocumentSyncKind)t.getTextDocumentSync().getLeft();
        } else if (t.getTextDocumentSync().isRight()) {
            syncKind = ((TextDocumentSyncOptions)t.getTextDocumentSync().getRight()).getChange();
        }
        return syncKind;
    }
}

