/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Test;

public class CompletionOrderingTests
extends AbstractCompletionTest {
    private static final String CHARACTERS = "abcdefghABCDEFGH.-_";

    @Test
    public void testItemOrdering() throws Exception {
        this.confirmCompletionResults(new String[]{"AA", "AB", "BA", "BB", "CB", "CC"}, "B", (Integer)1, new String[]{"BA", "BB", "AB", "CB"});
    }

    @Test
    public void testOrderByCategory() throws Exception {
        String[] completions = new String[]{"testa", "test.a", "a.test.a", "a.testa", "test"};
        String[] orderedResults = new String[]{"test", "testa", "a.testa", "test.a", "a.test.a"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"testa", "atest", "a.testa"};
        orderedResults = new String[]{"testa", "a.testa", "atest"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"atesta", "tZesZt", "atest"};
        orderedResults = new String[]{"atest", "atesta", "tZesZt"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"qwerty", "tZesZt", "t.e.s.t"};
        orderedResults = new String[]{"tZesZt", "t.e.s.t", "qwerty"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
    }

    @Test
    public void testOrderByRank() throws Exception {
        String[] completions = new String[]{"prefix.test", "alongprefix.test", "test", "test.test", "pretest.test"};
        String[] orderedResults = new String[]{"test", "test.test", "pretest.test", "prefix.test", "alongprefix.test"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"testa", "alongprefix.testa", "testatest", "prefix.testa"};
        orderedResults = new String[]{"testa", "prefix.testa", "alongprefix.testa", "testatest"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"atesta", "teteteststst", "long.prefixtest.suffix"};
        orderedResults = new String[]{"atesta", "teteteststst", "long.prefixtest.suffix"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"tlongbreakbetweenest", "tZesZt", "t.e.s.t", "tes.tst"};
        orderedResults = new String[]{"tes.tst", "tZesZt", "t.e.s.t", "tlongbreakbetweenest"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
    }

    @Test
    public void testOrderWithCapitalization() throws Exception {
        String[] completions = new String[]{"prefiX.Test", "alongprefix.test", "tEsT", "teSt.teST", "preTEst.test"};
        String[] orderedResults = new String[]{"tEsT", "teSt.teST", "preTEst.test", "prefiX.Test", "alongprefix.test"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
        completions = new String[]{"teSTa", "alonGPrefix.TESTA", "tEStatest", "prefix.testa"};
        orderedResults = new String[]{"teSTa", "prefix.testa", "alonGPrefix.TESTA", "tEStatest"};
        this.confirmCompletionResults(completions, "tESt", (Integer)4, orderedResults);
        completions = new String[]{"ATesta", "teTETesTSTst", "long.prefixtest.suffix"};
        orderedResults = new String[]{"ATesta", "teTETesTSTst", "long.prefixtest.suffix"};
        this.confirmCompletionResults(completions, "TEST", (Integer)4, orderedResults);
        completions = new String[]{"TlongbreakbetweenEST", "TZesZT", "t.e.s.t", "teS.tst"};
        orderedResults = new String[]{"teS.tst", "TZesZT", "t.e.s.t", "TlongbreakbetweenEST"};
        this.confirmCompletionResults(completions, "test", (Integer)4, orderedResults);
    }

    @Test
    public void testOrderWithLongInsert() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("server.address");
        item.setFilterText("server.address");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(1, 12), new Position(5, 7)), "  address: $1\nspring:\n  application:\n    name: f\n")));
        items.add(item);
        item = new CompletionItem("management.server.address");
        item.setFilterText("management.server.address");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(5, 0), new Position(5, 7)), "management:\n  server:\n    address: $1\n")));
        items.add(item);
        item = new CompletionItem("\u2192 spring.jta.atomikos.datasource.xa-data-source-class-name");
        item.setFilterText("spring.jta.atomikos.datasource.xa-data-source-class-name");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(5, 0), new Position(0, 12)), item.getFilterText())));
        items.add(item);
        String[] orderedResults = new String[]{"server.address", "management.server.address", "\u2192 spring.jta.atomikos.datasource.xa-data-source-class-name"};
        this.confirmCompletionResults(items, "server:\n  port: 555\nspring:\n  application:\n    name: f\naddress", (Integer)62, orderedResults);
    }

    @Test
    public void testMovingOffset() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 4));
        IDocument document = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "test")).getDocument();
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem completionItem = this.createCompletionItem("test", CompletionItemKind.Class, range);
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, completionItem, info.getLanguageClient());
        Assert.assertEquals((Object)"", (Object)completionProposal.getDocumentFilter());
        Assert.assertEquals((long)0L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)5L, (long)completionProposal.getRankCategory());
        Assert.assertEquals((Object)"test", (Object)completionProposal.getDocumentFilter(4));
        Assert.assertEquals((long)0L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)1L, (long)completionProposal.getRankCategory());
        Assert.assertEquals((Object)"t", (Object)completionProposal.getDocumentFilter(1));
        Assert.assertEquals((long)0L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)2L, (long)completionProposal.getRankCategory());
        document.set("prefix:pnd");
        completionItem = this.createCompletionItem("append", CompletionItemKind.Class);
        completionProposal = new LSCompletionProposal(document, 7, completionItem, info.getLanguageClient());
        Assert.assertEquals((Object)"", (Object)completionProposal.getDocumentFilter());
        Assert.assertEquals((long)0L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)5L, (long)completionProposal.getRankCategory());
        Assert.assertEquals((Object)"pnd", (Object)completionProposal.getDocumentFilter(10));
        Assert.assertEquals((long)5L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)4L, (long)completionProposal.getRankCategory());
        Assert.assertEquals((Object)"p", (Object)completionProposal.getDocumentFilter(8));
        Assert.assertEquals((long)1L, (long)completionProposal.getRankScore());
        Assert.assertEquals((long)3L, (long)completionProposal.getRankCategory());
    }

    @Test
    public void testPerformance() throws Exception {
        int[] batchSizes = new int[]{10, 100, 1000, 10000};
        int[] resultAverages = new int[batchSizes.length];
        int repeat = 5;
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "abcdefgh"));
        int i = 0;
        while (i < batchSizes.length) {
            long resultSum = 0L;
            int j = 0;
            while (j < 5) {
                resultSum += this.timeToDisplayCompletionList(viewer, batchSizes[i]);
                ++j;
            }
            resultAverages[i] = (int)(resultSum / 5L);
            ++i;
        }
        double pearsonCorrelation = this.isLinearCorelation(batchSizes, resultAverages);
        Assert.assertTrue((pearsonCorrelation > 0.99 ? 1 : 0) != 0);
    }

    private double isLinearCorelation(int[] batchSizes, int[] resultAverages) {
        int n = batchSizes.length;
        long batchSum = 0L;
        long resulthSum = 0L;
        long batchSumSquared = 0L;
        long resulthSumSquared = 0L;
        long productSum = 0L;
        int i = 0;
        while (i < n) {
            batchSum += (long)batchSizes[i];
            resulthSum += (long)resultAverages[i];
            batchSumSquared = (long)((double)batchSumSquared + Math.pow(batchSizes[i], 2.0));
            resulthSumSquared = (long)((double)resulthSumSquared + Math.pow(resultAverages[i], 2.0));
            productSum += (long)(batchSizes[i] * resultAverages[i]);
            ++i;
        }
        double numerator = productSum - batchSum * resulthSum / (long)n;
        double denominator = Math.sqrt(((double)batchSumSquared - Math.pow(batchSum, 2.0) / (double)n) * ((double)resulthSumSquared - Math.pow(resulthSum, 2.0) / (double)n));
        return denominator == 0.0 ? 0.0 : numerator / denominator;
    }

    private long timeToDisplayCompletionList(ITextViewer viewer, int size) throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 8));
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        int i = 0;
        while (i < size) {
            items.add(this.createCompletionItem(this.randomString(), CompletionItemKind.Class, range));
            ++i;
        }
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        long startTimeControl = System.currentTimeMillis();
        this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        long endTimeControl = System.currentTimeMillis();
        return endTimeControl - startTimeControl;
    }

    private String randomString() {
        int count = 50;
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)CHARACTERS.length());
            builder.append(CHARACTERS.charAt(character));
        }
        return builder.toString();
    }
}

