/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package distributions;

import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

import distributions.math.ModeDistribution;

public final class ModeDistributionsFactory {
    private static final RandomGenerator DEFAULT_RANDOM = new JDKRandomGenerator();

    private ModeDistributionsFactory() {
        /* Empty */
    }

    public static ModeDistribution createDistribution(Distribution distribution) {
        return createDistribution(distribution, DEFAULT_RANDOM);
    }

    public static ModeDistribution createDistribution(Distribution distribution, RandomGenerator random) {
        return distribution.createModeDistribution(random);
    }
}
