/*
 * Decompiled with CFR 0.152.
 */
package setting;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import setting.Settings;

public class SettingActivator
implements BundleActivator {
    public static final String PREFERENCE_SETTINGS = Settings.class.getName();
    public static final String PLUGIN_ID = "org.eclipse.lsat.setting.dsl";
    private static SettingActivator plugin;

    public void start(BundleContext context) throws Exception {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
    }

    public static SettingActivator getDefault() {
        return plugin;
    }

    public Preferences getProjectPreferences(IProject project) {
        return new ProjectScope(project).getNode(PLUGIN_ID);
    }

    public IResource getSettingIResource(IResource resource) throws CoreException, FileNotFoundException {
        IResource settingIResource;
        IFile settingIFile;
        if ("setting".equals(resource.getFileExtension())) {
            return resource;
        }
        if (".intermediate".equals(resource.getParent().getName()) && (settingIFile = resource.getProject().getFile(resource.getProjectRelativePath().removeFileExtension().addFileExtension("setting"))).exists()) {
            return settingIFile;
        }
        IProject project = resource.getProject();
        String physicalSettingsPath = this.getProjectPreferences(project).get(PREFERENCE_SETTINGS, null);
        if (physicalSettingsPath != null && (settingIResource = project.findMember(physicalSettingsPath)) != null) {
            return settingIResource;
        }
        return this.findSettingIResource(project);
    }

    public Collection<IResource> getSettingIResources(IResource resource) throws CoreException, FileNotFoundException {
        return Stream.of(resource.getProject().members()).filter(r -> "setting".equals(r.getFileExtension())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private IResource findSettingIResource(IProject project) throws CoreException, FileNotFoundException {
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if ("setting".equals(resource.getFileExtension())) {
                return resource;
            }
            ++n2;
        }
        throw new FileNotFoundException("No setting file found in project");
    }
}

