/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class SelectFilterWizardPage
extends WizardPage {
    private Button[] btnFilters;
    private Label lblDesc;
    private String filterID;
    private SelectFilterWizard wizard;
    private ButtonSelectionListener buttonListener;

    public SelectFilterWizardPage() {
        super("selectFilter");
        this.setTitle(Localization.getString("SelectFilterWizardPage.SelectFilter"));
        this.filterID = "";
        this.btnFilters = null;
        this.buttonListener = new ButtonSelectionListener();
    }

    public void createControl(Composite parent) {
        this.wizard = (SelectFilterWizard)super.getWizard();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        this.btnFilters = new Button[AvailableFilterTypes.FILTER_IDS.length];
        for (int i = 0; i < this.btnFilters.length; ++i) {
            this.btnFilters[i] = new Button(cmpFilterOpts, 0);
            this.btnFilters[i].setText(AvailableFilterTypes.getFilterName(AvailableFilterTypes.FILTER_IDS[i]));
            this.btnFilters[i].addSelectionListener((SelectionListener)this.buttonListener);
            this.btnFilters[i].setData((Object)AvailableFilterTypes.FILTER_IDS[i]);
        }
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)cmpFilterOpts);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        this.lblDesc = new Label(comp, 64);
        this.lblDesc.setLayoutData((Object)data2);
        this.setControl((Control)comp);
    }

    public IWizardPage getNextPage() {
        return AvailableFilterTypes.getFilterWizardPage(this.filterID);
    }

    public boolean canFlipToNextPage() {
        return this.filterID.length() > 0;
    }

    public void dispose() {
        super.dispose();
        if (null != this.btnFilters) {
            for (int i = 0; i < this.btnFilters.length; ++i) {
                this.btnFilters[i].removeSelectionListener((SelectionListener)this.buttonListener);
                this.btnFilters[i].dispose();
                this.btnFilters[i] = null;
            }
        }
        this.btnFilters = null;
        this.lblDesc = null;
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget instanceof Button) {
                Button target = (Button)widget;
                for (int i = 0; i < SelectFilterWizardPage.this.btnFilters.length; ++i) {
                    if (target != SelectFilterWizardPage.this.btnFilters[i]) continue;
                    SelectFilterWizardPage.this.filterID = SelectFilterWizardPage.this.btnFilters[i].getData().toString();
                    SelectFilterWizardPage.this.lblDesc.setText(AvailableFilterTypes.getFilterName(SelectFilterWizardPage.this.filterID) + "\n\n" + AvailableFilterTypes.getFilterDescription(SelectFilterWizardPage.this.filterID));
                    SelectFilterWizardPage.this.wizard.getContainer().updateButtons();
                }
            }
        }
    }
}

