package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link TaskDefaults}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTaskDefaults.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableTaskDefaults implements TaskDefaults {
  private final @Nullable Driver logDriver;

  private ImmutableTaskDefaults(@Nullable Driver logDriver) {
    this.logDriver = logDriver;
  }

  /**
   * @return The value of the {@code logDriver} attribute
   */
  @JsonProperty("LogDriver")
  @Override
  public @Nullable Driver logDriver() {
    return logDriver;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskDefaults#logDriver() logDriver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logDriver (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTaskDefaults withLogDriver(@Nullable Driver value) {
    if (this.logDriver == value) return this;
    return new ImmutableTaskDefaults(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTaskDefaults} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTaskDefaults
        && equalsByValue((ImmutableTaskDefaults) another);
  }

  private boolean equalsByValue(ImmutableTaskDefaults another) {
    return Objects.equals(logDriver, another.logDriver);
  }

  /**
   * Computes a hash code from attributes: {@code logDriver}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(logDriver);
    return h;
  }

  /**
   * Prints the immutable value {@code TaskDefaults} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TaskDefaults{"
        + "logDriver=" + logDriver
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TaskDefaults} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TaskDefaults instance
   */
  public static ImmutableTaskDefaults copyOf(TaskDefaults instance) {
    if (instance instanceof ImmutableTaskDefaults) {
      return (ImmutableTaskDefaults) instance;
    }
    return ImmutableTaskDefaults.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTaskDefaults ImmutableTaskDefaults}.
   * <pre>
   * ImmutableTaskDefaults.builder()
   *    .logDriver(org.mandas.docker.client.messages.swarm.Driver | null) // nullable {@link TaskDefaults#logDriver() logDriver}
   *    .build();
   * </pre>
   * @return A new ImmutableTaskDefaults builder
   */
  public static ImmutableTaskDefaults.Builder builder() {
    return new ImmutableTaskDefaults.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTaskDefaults ImmutableTaskDefaults}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements TaskDefaults.Builder {
    private Driver logDriver;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TaskDefaults} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TaskDefaults instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Driver logDriverValue = instance.logDriver();
      if (logDriverValue != null) {
        logDriver(logDriverValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TaskDefaults#logDriver() logDriver} attribute.
     * @param logDriver The value for logDriver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LogDriver")
    public final Builder logDriver(@Nullable Driver logDriver) {
      this.logDriver = logDriver;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTaskDefaults ImmutableTaskDefaults}.
     * @return An immutable instance of TaskDefaults
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTaskDefaults build() {
      return new ImmutableTaskDefaults(logDriver);
    }
  }
}
