/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.internal.ssh.proxy.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SSHPasswordDialog
extends Dialog {
    private String password;
    private Text passwordField;
    private String user;
    private String host;

    public SSHPasswordDialog(Shell parent, String user, String host) {
        super(parent);
        this.user = user;
        this.host = host;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SSHPasswordDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Layout layout = comp.getLayout();
        if (!(layout instanceof GridLayout)) {
            layout = new GridLayout();
            comp.setLayout(layout);
        }
        ((GridLayout)layout).numColumns = 2;
        Label passwordTitle = new Label(comp, 131072);
        Label passwordLabel = new Label(comp, 131072);
        GridData gridData = new GridData(8);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        passwordTitle.setLayoutData((Object)gridData);
        if (this.host != null && this.user != null) {
            passwordTitle.setText(MessageFormat.format(Messages.SSHPasswordDialog_Password_Title, this.user, this.host));
        }
        passwordLabel.setText(Messages.SSHPasswordDialog_Password);
        this.passwordField = new Text(comp, 0x400004);
        GridData data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        return comp;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }
}

