/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerIpam;
import org.eclipse.linuxtools.docker.core.IDockerNetwork;
import org.eclipse.linuxtools.docker.core.IDockerNetworkContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerNetworkContainer;
import org.mandas.docker.client.messages.Network;

public class DockerNetwork
implements IDockerNetwork {
    private String name;
    private String id;
    private String scope;
    private String driver;
    private Map<String, String> options;
    private Map<String, IDockerNetworkContainer> containers;
    private IDockerIpam ipam;

    public DockerNetwork(Network network) {
        this.name = network.name();
        this.id = network.id();
        this.scope = network.scope();
        this.driver = network.driver();
        this.options = network.options();
        this.containers = new HashMap<String, IDockerNetworkContainer>();
        for (String key : network.containers().keySet()) {
            this.containers.put(key, new DockerNetworkContainer((Network.Container)network.containers().get(key)));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public String driver() {
        return this.driver;
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Map<String, IDockerNetworkContainer> containers() {
        return this.containers;
    }

    @Override
    public IDockerIpam ipam() {
        return this.ipam;
    }
}

