/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class RNGRenameExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void renameOnDefineName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardContent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardCo|ntent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        XMLAssert.assertRename(xml, "card-content", RNGRenameExtensionsTest.edits("card-content", RNGRenameExtensionsTest.r(11, 18, 29), RNGRenameExtensionsTest.r(6, 31, 42)));
    }

    private static Range r(int line, int startCharacter, int endCharacter) {
        return new Range(new Position(line, startCharacter), new Position(line, endCharacter));
    }

    private static List<TextEdit> edits(String newText, Range ... ranges) {
        return Stream.of(ranges).map(r -> new TextEdit(r, newText)).collect(Collectors.toList());
    }
}

