/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.commands.AssociateGrammarCommand;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssociateGrammarCommandTest
extends AbstractCacheBasedTest {
    @Test
    public void associateWithXSDNoNamespaceSchemaLocation() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/xsd/tag.xsd");
        String bindingType = AssociateGrammarCommand.GrammarBindingType.STANDARD.getName();
        TextDocumentEdit actual = (TextDocumentEdit)languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, xsdPath, bindingType).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)XMLAssert.tde(xmlPath, 1, XMLAssert.te(1, 4, 1, 4, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\"")));
    }

    @Test
    public void associateWithXSDSchemaLocation() throws Exception {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/xsd/team.xsd");
        String bindingType = AssociateGrammarCommand.GrammarBindingType.STANDARD.getName();
        TextDocumentEdit actual = (TextDocumentEdit)languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, xsdPath, bindingType).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)XMLAssert.tde(xmlPath, 1, XMLAssert.te(1, 4, 1, 4, " xmlns=\"team_namespace\"\r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"team_namespace xsd/team.xsd\"")));
    }

    @Test
    public void associateWithDTD() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String dtdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/dtd/tag.dtd");
        String bindingType = AssociateGrammarCommand.GrammarBindingType.STANDARD.getName();
        TextDocumentEdit actual = (TextDocumentEdit)languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, dtdPath, bindingType).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)XMLAssert.tde(xmlPath, 1, XMLAssert.te(1, 0, 1, 0, "<!DOCTYPE foo SYSTEM \"dtd/tag.dtd\">\r\n")));
    }

    @Test
    public void associateWithXMLModel() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String dtdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/dtd/tag.dtd");
        String bindingType = AssociateGrammarCommand.GrammarBindingType.XML_MODEL.getName();
        TextDocumentEdit actual = (TextDocumentEdit)languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, dtdPath, bindingType).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)XMLAssert.tde(xmlPath, 1, XMLAssert.te(1, 0, 1, 0, "<?xml-model href=\"dtd/tag.dtd\"?>\r\n")));
    }

    @Test
    public void associateWithXMLModelAXSDWithTargetNamespace() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/xsd/team.xsd");
        String bindingType = AssociateGrammarCommand.GrammarBindingType.XML_MODEL.getName();
        TextDocumentEdit actual = (TextDocumentEdit)languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, xsdPath, bindingType).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)XMLAssert.tde(xmlPath, 1, XMLAssert.te(1, 0, 1, 0, "<?xml-model href=\"xsd/team.xsd\"?>\r\n"), XMLAssert.te(1, 4, 1, 4, " xmlns=\"team_namespace\" ")));
    }

    @Test
    public void unknownBindingTypeException() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml version=\"1.0\" ?>\r\n<foo/>";
        String xmlPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String dtdPath = AssociateGrammarCommandTest.getFileURI("src/test/resources/dtd/tag.dtd");
        String bindingType = "BAD";
        try {
            languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, dtdPath, bindingType).get();
            Assertions.fail((String)"Unknown binding type should throw an exception.");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Unknown binding type 'BAD'. Allowed values are [standard, xml-model]", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void unknownFileUri() throws InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xmlPath = "tag.xml";
        TextDocumentIdentifier xmlIdentifier = new TextDocumentIdentifier(xmlPath);
        String xsdPath = "tag.xsd";
        String bindingType = AssociateGrammarCommand.GrammarBindingType.STANDARD.getName();
        try {
            languageServer.executeCommand("xml.associate.grammar.insert", xmlIdentifier, xsdPath, bindingType).get();
            Assertions.fail((String)"Unknown file URI should throw an exception.");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Command 'xml.associate.grammar.insert' cannot find the DOM document with the URI 'tag.xml'.", (Object)e.getCause().getMessage());
        }
    }

    private static String getFileURI(String fileName) {
        String uri = new File(fileName).toURI().toString();
        if (Platform.isWindows && !uri.startsWith("file://")) {
            uri = uri.replace("file:/", "file:///");
        }
        return uri;
    }
}

