/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import java.io.File;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckBoundGrammarCommandTest {
    @Test
    public void checkDocumentWithoutBoundGrammar() throws Exception {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<foo/>";
        String xmlPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/xsd/tag.xsd");
        Boolean actual = (Boolean)languageServer.executeCommand("xml.check.bound.grammar", xmlIdentifier, xsdPath).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void checkDocumentWithXSIDocTypeBoundGrammar() throws Exception {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<foo xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"tag.xsd\"/>";
        String xmlPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/xsd/tag.xsd");
        Boolean actual = (Boolean)languageServer.executeCommand("xml.check.bound.grammar", xmlIdentifier, xsdPath).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)false, (Object)actual);
    }

    @Test
    public void checkDocumentWithXMLModelBoundGrammar() throws Exception {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xml = "<?xml-model href=\"tag1.xsd\"?>\r\n<foo/>";
        String xmlPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/tag.xml");
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(xmlPath, xml);
        String xsdPath = CheckBoundGrammarCommandTest.getFileURI("src/test/resources/xsd/tag.xsd");
        Boolean actual = (Boolean)languageServer.executeCommand("xml.check.bound.grammar", xmlIdentifier, xsdPath).get();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)false, (Object)actual);
    }

    private static String getFileURI(String fileName) {
        String uri = new File(fileName).toURI().toString();
        if (Platform.isWindows && !uri.startsWith("file://")) {
            uri = uri.replace("file:/", "file:///");
        }
        return uri;
    }
}

