/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CodeLens;
import org.junit.jupiter.api.Test;

public class AssociateGrammarCodeLensExtensionsTest {
    @Test
    public void noGrammarWithAssociationSupportInXML() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("association"), XMLAssert.cl(XMLAssert.r(1, 1, 1, 4), "Bind to grammar/schema...", "xml.open.binding.wizard"));
    }

    @Test
    public void noGrammarWithAssociationSupportInXSD() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<schema />";
        XMLAssert.testCodeLensFor(xml, "test.xsd", Collections.singletonList("association"), new CodeLens[0]);
    }

    @Test
    public void noGrammarWithAssociationSupportInDTD() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.dtd", Collections.singletonList("association"), new CodeLens[0]);
    }

    @Test
    public void noGrammarWithoutAssociationSupport() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.emptyList(), new CodeLens[0]);
    }

    @Test
    public void withGrammar() throws BadLocationException {
        String xml = "<?xml-model href='test.dtd' ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.dtd (xml-model)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarWithXMlModel() throws BadLocationException {
        String xml = "<?xml-model href='test.dtd' ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.dtd (xml-model)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarWithXMlModelWithoutOpenUriSupport() throws BadLocationException {
        String xml = "<?xml-model href='test.dtd' ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.emptyList(), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.dtd (xml-model)", ""));
    }

    @Test
    public void referencedGrammarWith2XMlModel() throws BadLocationException {
        String xml = "<?xml-model href='test.dtd' ?>\r\n<?xml-model href='test2.dtd' ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.dtd (xml-model)", "xml.open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test2.dtd (xml-model)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarWithXSINoNamespaceSchemaLocation() throws BadLocationException {
        String xml = "<foo\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"test.xsd\">\r\n</root>";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.xsd (xsi:noNamespaceSchemaLocation)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarWithXSISchemaLocation() throws BadLocationException {
        String xml = "<foo\r\n    xmlns=\"http://foo\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"http://foo test.xsd\">\r\n</root>";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.xsd (xsi:schemaLocation)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarWithDOCTYPE() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"test.dtd\">\r\n<foo>\r\n</foo>";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "test.dtd (doctype)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarInXSDSchema() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n</xs:schema>";
        XMLAssert.testCodeLensFor(xsd, "test.xsd", Collections.singletonList("open.uri"), XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "http://www.w3.org/2001/XMLSchema (with embedded xml.xsd)", "xml.open.uri"));
    }

    @Test
    public void referencedGrammarUsingFileAssociation() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd/");
            contentModelManager.setFileAssociations(AssociateGrammarCodeLensExtensionsTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <Bad-Root></Bad-Root>";
        XMLAssert.testCodeLensFor(xml, "file:///test/resources.xml", new XMLLanguageService(), Collections.singletonList("open.uri"), configuration, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), " (with file association)", "xml.open.uri"));
    }

    private static XMLFileAssociation[] createXSDAssociationsNoNamespaceSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation resources = new XMLFileAssociation();
        resources.setPattern("**/*resources*.xml");
        resources.setSystemId(baseSystemId + "resources.xsd");
        return new XMLFileAssociation[]{resources};
    }
}

