/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientPreferencesTest {
    private ClientPreferences prefs;
    @Mock
    private ClientCapabilities cap;
    @Mock
    private TextDocumentClientCapabilities text;

    @Before
    public void setup() {
        Mockito.when((Object)this.cap.getTextDocument()).thenReturn((Object)this.text);
        this.prefs = new ClientPreferences(this.cap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClientPreferences() {
        new ClientPreferences(null);
    }

    @Test
    public void testIsV3Supported() throws Exception {
        Assert.assertTrue((boolean)this.prefs.isV3Supported());
        this.prefs = new ClientPreferences(new ClientCapabilities());
        Assert.assertFalse((boolean)this.prefs.isV3Supported());
    }

    @Test
    public void testIsSignatureHelpSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isSignatureHelpSupported());
        Mockito.when((Object)this.text.getSignatureHelp()).thenReturn((Object)new SignatureHelpCapabilities());
        Assert.assertTrue((boolean)this.prefs.isSignatureHelpSupported());
    }

    @Test
    public void testIsCompletionSnippetsSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isCompletionSnippetsSupported());
        Mockito.when((Object)this.text.getCompletion()).thenReturn((Object)new CompletionCapabilities());
        Assert.assertFalse((boolean)this.prefs.isCompletionSnippetsSupported());
        Mockito.when((Object)this.text.getCompletion()).thenReturn((Object)new CompletionCapabilities(new CompletionItemCapabilities(Boolean.valueOf(true))));
        Assert.assertTrue((boolean)this.prefs.isCompletionSnippetsSupported());
    }

    @Test
    public void testIsFormattingDynamicRegistrationSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isFormattingDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getFormatting()).thenReturn((Object)new FormattingCapabilities());
        Assert.assertFalse((boolean)this.prefs.isFormattingDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getFormatting()).thenReturn((Object)new FormattingCapabilities(Boolean.valueOf(true)));
        Assert.assertTrue((boolean)this.prefs.isFormattingDynamicRegistrationSupported());
    }

    @Test
    public void testIsRangeFormattingDynamicRegistrationSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isRangeFormattingDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getRangeFormatting()).thenReturn((Object)new RangeFormattingCapabilities());
        Assert.assertFalse((boolean)this.prefs.isRangeFormattingDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getRangeFormatting()).thenReturn((Object)new RangeFormattingCapabilities(Boolean.valueOf(true)));
        Assert.assertTrue((boolean)this.prefs.isRangeFormattingDynamicRegistrationSupported());
    }

    @Test
    public void testIsCodeLensDynamicRegistrationSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isCodeLensDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getCodeLens()).thenReturn((Object)new CodeLensCapabilities());
        Assert.assertFalse((boolean)this.prefs.isCodeLensDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getCodeLens()).thenReturn((Object)new CodeLensCapabilities(Boolean.valueOf(true)));
        Assert.assertTrue((boolean)this.prefs.isCodeLensDynamicRegistrationSupported());
    }

    @Test
    public void testIsSignatureHelpDynamicRegistrationSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isSignatureHelpDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getSignatureHelp()).thenReturn((Object)new SignatureHelpCapabilities());
        Assert.assertFalse((boolean)this.prefs.isSignatureHelpDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getSignatureHelp()).thenReturn((Object)new SignatureHelpCapabilities(Boolean.valueOf(true)));
        Assert.assertTrue((boolean)this.prefs.isSignatureHelpDynamicRegistrationSupported());
    }

    @Test
    public void testIsRenameDynamicRegistrationSupported() throws Exception {
        Assert.assertFalse((boolean)this.prefs.isRenameDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getRename()).thenReturn((Object)new RenameCapabilities());
        Assert.assertFalse((boolean)this.prefs.isRenameDynamicRegistrationSupported());
        Mockito.when((Object)this.text.getRename()).thenReturn((Object)new RenameCapabilities(Boolean.valueOf(true)));
        Assert.assertTrue((boolean)this.prefs.isRenameDynamicRegistrationSupported());
    }
}

