/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractMavenBasedTest;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MavenClasspathTest
extends AbstractMavenBasedTest {
    private SharedASTProvider sharedASTProvider;
    private DocumentLifeCycleHandler lifeCycleHandler;
    private JavaClientConnection javaClient;

    @Before
    public void setup() throws Exception {
        this.sharedASTProvider = SharedASTProvider.getInstance();
        this.sharedASTProvider.invalidateAll();
        this.sharedASTProvider.clearASTCreationCount();
        this.javaClient = new JavaClientConnection(this.client);
        this.lifeCycleHandler = new DocumentLifeCycleHandler(this.javaClient, this.preferenceManager, this.projectsManager, false);
    }

    @After
    public void tearDown() throws Exception {
        this.sharedASTProvider.invalidateAll();
        this.javaClient.disconnect();
        ICompilationUnit[] iCompilationUnitArray = JavaCore.getWorkingCopies(null);
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            cu.discardWorkingCopy();
            ++n2;
        }
    }

    @Test
    public void testMain() throws Exception {
        IProject project = this.importMavenProject("classpathtest");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType type = javaProject.findType("main.App");
        ICompilationUnit cu = type.getCompilationUnit();
        this.openDocument(cu, cu.getSource(), 1);
        DiagnosticsHandler handler = new DiagnosticsHandler(this.javaClient, cu);
        WorkingCopyOwner wcOwner = this.getWorkingCopy((IProblemRequestor)handler);
        cu.reconcile(0, true, wcOwner, null);
        Assert.assertTrue((String)"There aren't any problems", (handler.getProblems().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTest() throws Exception {
        IProject project = this.importMavenProject("classpathtest");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType type = javaProject.findType("test.AppTest");
        ICompilationUnit cu = type.getCompilationUnit();
        this.openDocument(cu, cu.getSource(), 1);
        DiagnosticsHandler handler = new DiagnosticsHandler(this.javaClient, cu);
        WorkingCopyOwner wcOwner = this.getWorkingCopy((IProblemRequestor)handler);
        cu.reconcile(0, true, wcOwner, null);
        Assert.assertTrue((String)"There is a problem", (handler.getProblems().size() == 0 ? 1 : 0) != 0);
    }

    private void openDocument(ICompilationUnit cu, String content, int version) {
        DidOpenTextDocumentParams openParms = new DidOpenTextDocumentParams();
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setLanguageId("java");
        textDocument.setText(content);
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)cu));
        textDocument.setVersion(version);
        openParms.setTextDocument(textDocument);
        this.lifeCycleHandler.didOpen(openParms);
    }

    private WorkingCopyOwner getWorkingCopy(final IProblemRequestor handler) {
        return new WorkingCopyOwner(){

            public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                return handler;
            }
        };
    }
}

