/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.List;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceSymbolHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspaceSymbolHandlerTest
extends AbstractProjectsManagerBasedTest {
    private WorkspaceSymbolHandler handler;

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.handler = new WorkspaceSymbolHandler();
    }

    @Test
    public void testSearchWithEmptyResults() {
        List results = this.handler.search(null, this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.size());
        results = this.handler.search("  ", this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.size());
        results = this.handler.search("Abracadabra", this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testWorkspaceSearch() {
        String query = "Array";
        List results = this.handler.search(query, this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((String)"Unexpected results", (long)11L, (long)results.size());
        Range defaultRange = JDTUtils.newRange();
        for (SymbolInformation symbol : results) {
            Assert.assertNotNull((String)"Kind is missing", (Object)symbol.getKind());
            Assert.assertNotNull((String)"ContainerName is missing", (Object)symbol.getContainerName());
            Assert.assertTrue((boolean)symbol.getName().startsWith(query));
            Location location = symbol.getLocation();
            Assert.assertEquals((Object)defaultRange, (Object)location.getRange());
            Assert.assertTrue((String)("Unexpected uri " + location.getUri()), (boolean)location.getUri().startsWith("jdt://"));
        }
    }

    @Test
    public void testProjectSearch() {
        String query = "IFoo";
        List results = this.handler.search(query, this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((String)("Found " + results.size() + " results"), (long)1L, (long)results.size());
        SymbolInformation symbol = (SymbolInformation)results.get(0);
        Assert.assertEquals((Object)SymbolKind.Interface, (Object)symbol.getKind());
        Assert.assertEquals((Object)"java", (Object)symbol.getContainerName());
        Assert.assertEquals((Object)query, (Object)symbol.getName());
        Location location = symbol.getLocation();
        Assert.assertEquals((Object)JDTUtils.newRange(), (Object)location.getRange());
        Assert.assertTrue((String)("Unexpected uri " + location.getUri()), (boolean)location.getUri().endsWith("Foo.java"));
    }

    @Test
    public void testCamelCaseSearch() {
        List results = this.handler.search("NPE", this.monitor);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)"NullPointerException", (Object)((SymbolInformation)results.get(0)).getName());
        results = this.handler.search("HaMa", this.monitor);
        String className = "HashMap";
        boolean foundClass = results.stream().filter(s -> className.equals(s.getName())).findFirst().isPresent();
        Assert.assertTrue((String)("Did not find " + className), (boolean)foundClass);
    }
}

