/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.AbstractCompilationUnitBasedTest;
import org.eclipse.jdt.ls.core.internal.handlers.SaveActionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.Document;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SaveActionHandlerTest
extends AbstractCompilationUnitBasedTest {
    private SaveActionHandler handler;
    private PreferenceManager preferenceManager;
    private IProgressMonitor monitor;

    @Override
    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Preferences preferences = (Preferences)Mockito.mock(Preferences.class);
        Mockito.when((Object)preferences.isJavaSaveActionsOrganizeImportsEnabled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)preferences);
        this.monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        Mockito.when((Object)this.monitor.isCanceled()).thenReturn((Object)false);
        this.handler = new SaveActionHandler(this.preferenceManager);
    }

    @Test
    public void testWillSaveWaitUntil() throws Exception {
        URI srcUri = this.project.getFile("src/java/Foo4.java").getRawLocationURI();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((URI)srcUri);
        StringBuilder buf = new StringBuilder();
        buf.append("package java;\n");
        buf.append("\n");
        buf.append("public class Foo4 {\n");
        buf.append("}\n");
        WillSaveTextDocumentParams params = new WillSaveTextDocumentParams();
        TextDocumentIdentifier document = new TextDocumentIdentifier();
        document.setUri(srcUri.toString());
        params.setTextDocument(document);
        List result = this.handler.willSaveWaitUntil(params, this.monitor);
        Document doc = new Document();
        doc.set(cu.getSource());
        Assert.assertEquals((Object)TextEditUtil.apply(doc, (Collection<? extends TextEdit>)result), (Object)buf.toString());
    }
}

