/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.TestVMType;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class JDTLanguageServerTest {
    private JDTLanguageServer server;
    @Spy
    private PreferenceManager prefManager;
    @Mock
    private ProjectsManager projManager;
    @Mock
    private JavaClientConnection.JavaLanguageClient client;
    @Mock
    private ClientPreferences clientPreferences;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.prefManager.getClientPreferences()).thenReturn((Object)this.clientPreferences);
        Mockito.when((Object)this.clientPreferences.isWorkspaceSymbolDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isDocumentSymbolDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isCodeActionDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isDefinitionDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isHoverDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isReferencesDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.clientPreferences.isDocumentHighlightDynamicRegistered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.projManager.setAutoBuilding(false)).thenCallRealMethod();
        Mockito.when((Object)this.projManager.setAutoBuilding(true)).thenCallRealMethod();
        this.projManager.setAutoBuilding(true);
        this.server = new JDTLanguageServer(this.projManager, this.prefManager);
        this.server.connectClient(this.client);
    }

    @After
    public void tearDown() {
        this.server.disconnectClient();
    }

    @Test
    public void testDefaultVM() throws CoreException {
        String oldJavaHome = this.prefManager.getPreferences().getJavaHome();
        IVMInstall oldVm = JavaRuntime.getDefaultVMInstall();
        Assert.assertNotNull((Object)oldVm);
        try {
            IVMInstall[] installs;
            IVMInstall vm = null;
            IVMInstallType type = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.ls.core.internal.TestVMType");
            IVMInstall[] iVMInstallArray = installs = type.getVMInstalls();
            int n = installs.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall install = iVMInstallArray[n2];
                if (!install.equals(oldVm)) {
                    vm = install;
                    break;
                }
                ++n2;
            }
            Assert.assertNotNull(vm);
            Assert.assertNotEquals(vm, (Object)oldVm);
            String javaHome = new File(TestVMType.getFakeJDKsLocation(), "9").getAbsolutePath();
            this.prefManager.getPreferences().setJavaHome(javaHome);
            boolean changed = this.server.configureVM();
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            Assert.assertTrue((String)"A VM hasn't been changed", (boolean)changed);
            Assert.assertEquals((Object)vm, (Object)defaultVM);
            Assert.assertNotEquals((Object)oldVm, (Object)defaultVM);
        }
        finally {
            this.prefManager.getPreferences().setJavaHome(oldJavaHome);
            TestVMType.setTestJREAsDefault();
        }
    }

    @Test
    public void testAutobuilding() throws Exception {
        boolean enabled = this.isAutoBuilding();
        try {
            Assert.assertTrue((String)"Autobuilding is off", (boolean)this.isAutoBuilding());
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("java.autobuild.enabled", false);
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(map);
            this.server.didChangeConfiguration(params);
            Assert.assertFalse((String)"Autobuilding is on", (boolean)this.isAutoBuilding());
        }
        finally {
            this.projManager.setAutoBuilding(enabled);
        }
    }

    private boolean isAutoBuilding() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        return description.isAutoBuilding();
    }

    @Test
    public void testRegisterDynamicCapabilities() throws Exception {
        this.setDynamicCapabilities(true);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("java.referencesCodeLens.enabled", true);
        map.put("java.format.enabled", true);
        map.put("java.signatureHelp.enabled", true);
        map.put("java.executeCommand.enabled", true);
        DidChangeConfigurationParams params = new DidChangeConfigurationParams(map);
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)5))).registerCapability((RegistrationParams)Matchers.any());
        Mockito.reset((Object[])new JavaClientConnection.JavaLanguageClient[]{this.client});
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).registerCapability((RegistrationParams)Matchers.any());
        Mockito.reset((Object[])new JavaClientConnection.JavaLanguageClient[]{this.client});
        map.put("java.referencesCodeLens.enabled", false);
        map.put("java.format.enabled", false);
        map.put("java.signatureHelp.enabled", false);
        map.put("java.executeCommand.enabled", false);
        params = new DidChangeConfigurationParams(map);
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)5))).unregisterCapability((UnregistrationParams)Matchers.any());
        Mockito.reset((Object[])new JavaClientConnection.JavaLanguageClient[]{this.client});
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).unregisterCapability((UnregistrationParams)Matchers.any());
    }

    @Test
    public void testNoDynamicCapabilities() throws Exception {
        this.setDynamicCapabilities(false);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("java.referencesCodeLens.enabled", true);
        map.put("java.format.enabled", true);
        map.put("java.signatureHelp.enabled", true);
        map.put("java.executeCommand.enabled", true);
        DidChangeConfigurationParams params = new DidChangeConfigurationParams(map);
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).registerCapability((RegistrationParams)Matchers.any());
        map.put("java.referencesCodeLens.enabled", false);
        map.put("java.format.enabled", false);
        map.put("java.signatureHelp.enabled", false);
        map.put("java.executeCommand.enabled", false);
        params = new DidChangeConfigurationParams(map);
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).unregisterCapability((UnregistrationParams)Matchers.any());
    }

    private void setDynamicCapabilities(boolean enable) {
        Mockito.when((Object)this.clientPreferences.isCodeLensDynamicRegistrationSupported()).thenReturn((Object)enable);
        Mockito.when((Object)this.clientPreferences.isFormattingDynamicRegistrationSupported()).thenReturn((Object)enable);
        Mockito.when((Object)this.clientPreferences.isRangeFormattingDynamicRegistrationSupported()).thenReturn((Object)enable);
        Mockito.when((Object)this.clientPreferences.isSignatureHelpDynamicRegistrationSupported()).thenReturn((Object)enable);
        Mockito.when((Object)this.clientPreferences.isExecuteCommandDynamicRegistrationSupported()).thenReturn((Object)enable);
    }
}

