/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JsonMessageHelper;
import org.eclipse.jdt.ls.core.internal.Lsp4jAssertions;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.AbstractCompilationUnitBasedTest;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CompletionHandlerTest
extends AbstractCompilationUnitBasedTest {
    private DocumentLifeCycleHandler lifeCycleHandler;
    private JavaClientConnection javaClient;
    private static String COMPLETION_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"textDocument/hover\",\n    \"params\": {\n        \"textDocument\": {\n            \"uri\": \"${file}\"\n        },\n        \"position\": {\n            \"line\": ${line},\n            \"character\": ${char}\n        }\n    },\n    \"jsonrpc\": \"2.0\"\n}";

    @Before
    public void setUp() {
        this.mockLSP3Client();
        SharedASTProvider sharedASTProvider = SharedASTProvider.getInstance();
        sharedASTProvider.invalidateAll();
        sharedASTProvider.clearASTCreationCount();
        this.javaClient = new JavaClientConnection(this.client);
        this.lifeCycleHandler = new DocumentLifeCycleHandler(this.javaClient, this.preferenceManager, this.projectsManager, true);
    }

    @After
    public void tearDown() throws Exception {
        this.javaClient.disconnect();
    }

    @Test
    public void testCompletion_javadoc() throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        ICompilationUnit unit = (ICompilationUnit)javaProject.findElement((IPath)new Path("org/sample/TestJavadoc.java"));
        unit.becomeWorkingCopy(null);
        String joinOnCompletion = System.getProperty("java.lsp.joinOnCompletion");
        try {
            System.setProperty("java.lsp.joinOnCompletion", "true");
            int[] loc = this.findCompletionLocation(unit, "inner.");
            TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]));
            String source = unit.getSource();
            this.changeDocument(unit, source, 3);
            Job.getJobManager().join((Object)"DocumentLifeCycleJobs", (IProgressMonitor)new NullProgressMonitor());
            this.changeDocument(unit, source, 4);
            CompletionList list = (CompletionList)((Either)this.server.completion(position).join()).getRight();
            for (CompletionItem item : list.getItems()) {
                this.server.resolveCompletionItem(item);
            }
            CompletionItem resolved = (CompletionItem)list.getItems().get(0);
            Assert.assertEquals((Object)"Test ", (Object)resolved.getDocumentation());
        }
        finally {
            unit.discardWorkingCopy();
            if (joinOnCompletion == null) {
                System.clearProperty("java.lsp.joinOnCompletion");
            } else {
                System.setProperty("java.lsp.joinOnCompletion", joinOnCompletion);
            }
        }
    }

    private void changeDocument(ICompilationUnit unit, String content, int version) throws JavaModelException {
        DidChangeTextDocumentParams changeParms = new DidChangeTextDocumentParams();
        VersionedTextDocumentIdentifier textDocument = new VersionedTextDocumentIdentifier();
        textDocument.setUri(JDTUtils.toURI((ICompilationUnit)unit));
        textDocument.setVersion(version);
        changeParms.setTextDocument(textDocument);
        TextDocumentContentChangeEvent event = new TextDocumentContentChangeEvent();
        event.setText(content);
        ArrayList<TextDocumentContentChangeEvent> contentChanges = new ArrayList<TextDocumentContentChangeEvent>();
        contentChanges.add(event);
        changeParms.setContentChanges(contentChanges);
        this.lifeCycleHandler.didChange(changeParms);
    }

    @Test
    public void testCompletion_object() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\n\t\tObjec\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "Objec");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((String)"No proposals were found", (boolean)list.getItems().isEmpty());
        List items = list.getItems();
        for (CompletionItem item : items) {
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getLabel()));
            Assert.assertNotNull((Object)item.getKind());
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getSortText()));
            Assert.assertNull((Object)item.getTextEdit());
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getInsertText()));
            Assert.assertNotNull((Object)item.getFilterText());
            Assert.assertFalse((boolean)item.getFilterText().contains(" "));
            Assert.assertTrue((boolean)item.getLabel().startsWith(item.getFilterText()));
            Map data = (Map)item.getData();
            Assert.assertNotNull((Object)data);
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("uri"))));
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("pid"))));
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("rid"))));
        }
    }

    @Test
    public void testCompletion_constructor() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\n\t\tObject o = new O\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "new O");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((String)"No proposals were found", (boolean)list.getItems().isEmpty());
        ArrayList items = new ArrayList(list.getItems());
        Comparator comparator = (a, b) -> a.getSortText().compareTo(b.getSortText());
        Collections.sort(items, comparator);
        CompletionItem ctor = (CompletionItem)items.get(0);
        Assert.assertEquals((Object)"Object()", (Object)ctor.getLabel());
        Assert.assertEquals((Object)"Object", (Object)ctor.getInsertText());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ctor).join();
        Assert.assertNotNull((Object)resolvedItem);
        TextEdit te = resolvedItem.getTextEdit();
        Assert.assertNotNull((Object)te);
        Assert.assertEquals((Object)"Object()", (Object)te.getNewText());
        Assert.assertNotNull((Object)te.getRange());
        Range range = te.getRange();
        Assert.assertEquals((long)2L, (long)range.getStart().getLine());
        Assert.assertEquals((long)17L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)2L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)18L, (long)range.getEnd().getCharacter());
    }

    @Test
    public void testCompletion_import_package() throws JavaModelException {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import java.sq \npublic class Foo {\n\tvoid foo() {\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "java.sq");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getItems().size());
        CompletionItem item = (CompletionItem)list.getItems().get(0);
        Assert.assertNull((Object)item.getInsertText());
        Assert.assertEquals((Object)"java.sql", (Object)item.getLabel());
        Assert.assertEquals((Object)CompletionItemKind.Module, (Object)item.getKind());
        Assert.assertEquals((Object)"999999215", (Object)item.getSortText());
        Assert.assertNull((Object)item.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(item).join();
        Assert.assertNotNull((Object)resolvedItem);
        TextEdit te = item.getTextEdit();
        Assert.assertNotNull((Object)te);
        Assert.assertEquals((Object)"java.sql.*;", (Object)te.getNewText());
        Assert.assertNotNull((Object)te.getRange());
        Range range = te.getRange();
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)7L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
    }

    @Test
    public void testCompletion_import_static() throws JavaModelException {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import static java.util.concurrent.TimeUnit. \npublic class Foo {\n\tvoid foo() {\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "java.util.concurrent.TimeUnit.");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)9L, (long)list.getItems().size());
        CompletionItem secondsFieldItem = (CompletionItem)list.getItems().get(0);
        Assert.assertEquals((Object)"SECONDS", (Object)secondsFieldItem.getInsertText());
        Assert.assertEquals((Object)"SECONDS : TimeUnit", (Object)secondsFieldItem.getLabel());
        Assert.assertEquals((Object)CompletionItemKind.Field, (Object)secondsFieldItem.getKind());
        Assert.assertEquals((Object)"999999210", (Object)secondsFieldItem.getSortText());
        Assert.assertNull((Object)secondsFieldItem.getTextEdit());
        Assert.assertNotNull(this.server.resolveCompletionItem(secondsFieldItem).join());
        TextEdit teSeconds = secondsFieldItem.getTextEdit();
        Assert.assertNotNull((Object)teSeconds);
        Assert.assertEquals((Object)"SECONDS;", (Object)teSeconds.getNewText());
        Assert.assertNotNull((Object)teSeconds.getRange());
        Range secondsRange = teSeconds.getRange();
        Assert.assertEquals((long)0L, (long)secondsRange.getStart().getLine());
        Assert.assertEquals((long)44L, (long)secondsRange.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)secondsRange.getEnd().getLine());
        CompletionItem valuesMethodItem = (CompletionItem)list.getItems().get(7);
        Assert.assertEquals((Object)"values", (Object)valuesMethodItem.getInsertText());
        Assert.assertEquals((Object)"values() : TimeUnit[]", (Object)valuesMethodItem.getLabel());
        Assert.assertEquals((Object)CompletionItemKind.Module, (Object)valuesMethodItem.getKind());
        Assert.assertEquals((Object)"999999211", (Object)valuesMethodItem.getSortText());
        Assert.assertNull((Object)valuesMethodItem.getTextEdit());
        Assert.assertNotNull(this.server.resolveCompletionItem(valuesMethodItem).join());
        TextEdit teValues = valuesMethodItem.getTextEdit();
        Assert.assertNotNull((Object)teValues);
        Assert.assertEquals((Object)"values;", (Object)teValues.getNewText());
        Assert.assertNotNull((Object)teValues.getRange());
        Range valuesRange = teValues.getRange();
        Assert.assertEquals((long)0L, (long)valuesRange.getStart().getLine());
        Assert.assertEquals((long)44L, (long)valuesRange.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)valuesRange.getEnd().getLine());
    }

    @Test
    public void testCompletion_method_withLSPV2() throws JavaModelException {
        this.mockLSP2Client();
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\nSystem.out.print(\"Hello\");\nSystem.out.println(\" World!\");\nHashMap<String, String> map = new HashMap<>();\nmap.pu\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "map.pu");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().matches("put\\(String \\w+, String \\w+\\) : String")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"put", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Function, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999019", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(5, 4, 6, "put", resolvedItem.getTextEdit());
        Assert.assertNotNull((Object)resolvedItem.getAdditionalTextEdits());
        List edits = resolvedItem.getAdditionalTextEdits();
        Assert.assertEquals((long)3L, (long)edits.size());
    }

    @Test
    public void testCompletion_method_withLSPV3() throws JavaModelException {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\nSystem.out.print(\"Hello\");\nSystem.out.println(\" World!\");\nHashMap<String, String> map = new HashMap<>();\nmap.pu\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "map.pu");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().matches("put\\(String \\w+, String \\w+\\) : String")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"put", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Function, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999019", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        try {
            Lsp4jAssertions.assertTextEdit(5, 4, 6, "put(${1:key}, ${2:value})", resolvedItem.getTextEdit());
        }
        catch (ComparisonFailure e) {
            Lsp4jAssertions.assertTextEdit(5, 4, 6, "put(${1:arg0}, ${2:arg1})", resolvedItem.getTextEdit());
        }
        Assert.assertNotNull((Object)resolvedItem.getAdditionalTextEdits());
        List edits = resolvedItem.getAdditionalTextEdits();
        Assert.assertEquals((long)3L, (long)edits.size());
    }

    private ClientPreferences mockClientPreferences(boolean supportCompletionSnippets, boolean supportSignatureHelp) {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        Mockito.when((Object)mockCapabilies.isCompletionSnippetsSupported()).thenReturn((Object)supportCompletionSnippets);
        Mockito.when((Object)mockCapabilies.isSignatureHelpSupported()).thenReturn((Object)supportSignatureHelp);
        return mockCapabilies;
    }

    @Test
    public void testCompletion_field() throws JavaModelException {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import java.sq \npublic class Foo {\nprivate String myTestString;\n\tvoid foo() {\n   this.myTestS\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "this.myTestS");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getItems().size());
        CompletionItem item = (CompletionItem)list.getItems().get(0);
        Assert.assertEquals((Object)CompletionItemKind.Field, (Object)item.getKind());
        Assert.assertEquals((Object)"myTestString", (Object)item.getInsertText());
        Assert.assertNull((Object)item.getAdditionalTextEdits());
        Assert.assertNull((Object)item.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(item).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(4, 8, 15, "myTestString", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_import_type() throws JavaModelException {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import java.sq \npublic class Foo {\n\tvoid foo() {\n   java.util.Ma\n\t}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "java.util.Ma");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getItems().size());
        CompletionItem item = (CompletionItem)list.getItems().get(0);
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)item.getKind());
        Assert.assertEquals((Object)"Map", (Object)item.getInsertText());
        Assert.assertNull((Object)item.getAdditionalTextEdits());
        Assert.assertNull((Object)item.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(item).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(3, 3, 15, "java.util.Map", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_noPackage() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/NoPackage.java", "public class NoPackage {\n    NoP}\n");
        int[] loc = this.findCompletionLocation(unit, "    NoP");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((String)"No proposals were found", (boolean)list.getItems().isEmpty());
        Assert.assertEquals((Object)"NoPackage", (Object)((CompletionItem)list.getItems().get(0)).getLabel());
    }

    @Test
    public void testCompletion_package() throws JavaModelException {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Baz.java", "package opublic class Baz {\n}\n");
        int[] loc = this.findCompletionLocation(unit, "package o");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        ArrayList items = new ArrayList(list.getItems());
        Assert.assertTrue((items.size() > 1 ? 1 : 0) != 0);
        items.sort((i1, i2) -> i1.getSortText().compareTo(i2.getSortText()));
        CompletionItem item = (CompletionItem)items.get(0);
        Assert.assertEquals((Object)"org.sample", (Object)item.getLabel());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(item).join();
        Assert.assertNotNull((Object)resolvedItem);
        TextEdit te = item.getTextEdit();
        Assert.assertNotNull((Object)te);
        Assert.assertEquals((Object)"org.sample", (Object)te.getNewText());
        Assert.assertNotNull((Object)te.getRange());
        Range range = te.getRange();
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)8L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)15L, (long)range.getEnd().getCharacter());
    }

    @Test
    public void testCompletion_methodOverride() throws Exception {
        this.testCompletion_classMethodOverride("hello", true, true);
    }

    @Test
    public void testCompletion_interfaceMethodOverride() throws Exception {
        this.testCompletion_interfaceMethodOverride("hello", true, true);
    }

    @Test
    public void testCompletion_classMethodOverrideNoSnippet() throws Exception {
        this.testCompletion_classMethodOverride("hello", false, true);
    }

    @Test
    public void testCompletion_interfaceMethodOverrideNoSnippet() throws Exception {
        this.testCompletion_interfaceMethodOverride("hello", false, true);
    }

    @Test
    public void testCompletion_classMethodOverrideJava4() throws Exception {
        this.testCompletion_classMethodOverride("java4", true, false);
    }

    @Test
    public void testCompletion_interfaceMethodOverrideJava4() throws Exception {
        this.testCompletion_interfaceMethodOverride("java4", true, false);
    }

    @Test
    public void testCompletion_classMethodOverrideJava5() throws Exception {
        this.testCompletion_classMethodOverride("java5", true, true);
    }

    @Test
    public void testCompletion_interfaceMethodOverrideJava5() throws Exception {
        this.testCompletion_interfaceMethodOverride("java5", true, false);
    }

    private void testCompletion_classMethodOverride(String projectName, boolean supportSnippets, boolean overridesSuperClass) throws Exception {
        if (this.project == null || !projectName.equals(this.project.getName())) {
            this.importProjects("eclipse/" + projectName);
            this.project = WorkspaceHelper.getProject(projectName);
        }
        this.mockClientPreferences(supportSnippets, true);
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    toStr}\n");
        int[] loc = this.findCompletionLocation(unit, " toStr");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        List filtered = list.getItems().stream().filter(item -> item.getDetail() != null && item.getDetail().startsWith("Override method in")).collect(Collectors.toList());
        Assert.assertFalse((String)"No override proposals", (boolean)filtered.isEmpty());
        CompletionItem oride = (CompletionItem)filtered.get(0);
        Assert.assertEquals((Object)"toString", (Object)oride.getInsertText());
        Assert.assertNull((Object)oride.getTextEdit());
        oride = (CompletionItem)this.server.resolveCompletionItem(oride).join();
        Assert.assertNotNull((Object)oride.getTextEdit());
        String text = oride.getTextEdit().getNewText();
        StringBuilder expectedText = new StringBuilder();
        if (overridesSuperClass) {
            expectedText.append("@Override\n");
        }
        expectedText.append("public String toString() {\n\t");
        if (supportSnippets) {
            expectedText.append("${0:");
        }
        expectedText.append("return super.toString();");
        if (supportSnippets) {
            expectedText.append("}");
        }
        expectedText.append("\n}");
        Assert.assertEquals((Object)expectedText.toString(), (Object)text);
    }

    private void testCompletion_interfaceMethodOverride(String projectName, boolean supportSnippets, boolean overridesInterface) throws Exception {
        if (this.project == null || !projectName.equals(this.project.getName())) {
            this.importProjects("eclipse/" + projectName);
            this.project = WorkspaceHelper.getProject(projectName);
        }
        this.mockClientPreferences(supportSnippets, true);
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo implements Runnable{\n    ru}\n");
        int[] loc = this.findCompletionLocation(unit, " ru");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        List filtered = list.getItems().stream().filter(item -> item.getDetail() != null && item.getDetail().startsWith("Override method in")).collect(Collectors.toList());
        Assert.assertFalse((String)"No override proposals", (boolean)filtered.isEmpty());
        CompletionItem oride = (CompletionItem)filtered.get(0);
        Assert.assertEquals((Object)"run", (Object)oride.getInsertText());
        Assert.assertNull((Object)oride.getTextEdit());
        oride = (CompletionItem)this.server.resolveCompletionItem(oride).join();
        Assert.assertNotNull((Object)oride.getTextEdit());
        String text = oride.getTextEdit().getNewText();
        StringBuilder expectedText = new StringBuilder();
        if (overridesInterface) {
            expectedText.append("@Override\n");
        }
        expectedText.append("public void run() {\n\t");
        if (supportSnippets) {
            expectedText.append("${0}");
        }
        expectedText.append("\n}");
        Assert.assertEquals((Object)expectedText.toString(), (Object)text);
    }

    @Test
    public void testCompletion_methodOverrideWithParams() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Test.java", "package org.sample;\n\npublic class Test extends Baz {\n    getP}\n");
        int[] loc = this.findCompletionLocation(unit, " getP");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        List filtered = list.getItems().stream().filter(item -> item.getDetail() != null && item.getDetail().startsWith("Override method in")).collect(Collectors.toList());
        Assert.assertEquals((String)"No override proposals", (long)filtered.size(), (long)1L);
        CompletionItem oride = (CompletionItem)filtered.get(0);
        Assert.assertEquals((Object)"getParent", (Object)oride.getInsertText());
        Assert.assertNull((Object)oride.getTextEdit());
        oride = (CompletionItem)this.server.resolveCompletionItem(oride).join();
        Assert.assertNotNull((Object)oride.getTextEdit());
        String text = oride.getTextEdit().getNewText();
        String expectedText = "@Override\nprotected File getParent(File file, int depth) {\n\t${0:return super.getParent(file, depth);}\n}";
        Assert.assertEquals((Object)expectedText, (Object)text);
        Assert.assertEquals((String)"Missing required imports", (long)4L, (long)oride.getAdditionalTextEdits().size());
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "\n\n", (TextEdit)oride.getAdditionalTextEdits().get(0));
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "import java.io.File;", (TextEdit)oride.getAdditionalTextEdits().get(1));
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "\n\n", (TextEdit)oride.getAdditionalTextEdits().get(2));
    }

    @Test
    public void testCompletion_methodOverrideWithException() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Test.java", "package org.sample;\n\npublic class Test extends Baz {\n    dele}\n");
        int[] loc = this.findCompletionLocation(unit, " dele");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        List filtered = list.getItems().stream().filter(item -> item.getDetail() != null && item.getDetail().startsWith("Override method in")).collect(Collectors.toList());
        Assert.assertEquals((String)"No override proposals", (long)filtered.size(), (long)1L);
        CompletionItem oride = (CompletionItem)filtered.get(0);
        Assert.assertEquals((Object)"deleteSomething", (Object)oride.getInsertText());
        Assert.assertNull((Object)oride.getTextEdit());
        oride = (CompletionItem)this.server.resolveCompletionItem(oride).join();
        Assert.assertNotNull((Object)oride.getTextEdit());
        String text = oride.getTextEdit().getNewText();
        String expectedText = "@Override\nprotected void deleteSomething() throws IOException {\n\t${0:super.deleteSomething();}\n}";
        Assert.assertEquals((Object)expectedText, (Object)text);
        Assert.assertEquals((String)"Missing required imports", (long)4L, (long)oride.getAdditionalTextEdits().size());
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "\n\n", (TextEdit)oride.getAdditionalTextEdits().get(0));
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "import java.io.IOException;", (TextEdit)oride.getAdditionalTextEdits().get(1));
        Lsp4jAssertions.assertTextEdit(0, 19, 19, "\n\n", (TextEdit)oride.getAdditionalTextEdits().get(2));
    }

    public void testCompletion_plainTextDoc() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import java.sq \npublic class Foo {\n\tvoid foo() {\n      zz\n\t}\n\"\t}\\n\"+\n/** This should be <bold>plain</bold>.*/\n\tvoid zzz() {}\n}\n");
        int[] loc = this.findCompletionLocation(unit, "   zz");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((String)"No proposals were found", (boolean)list.getItems().isEmpty());
        CompletionItem item = (CompletionItem)list.getItems().get(0);
        Assert.assertEquals((Object)"zzz() : void", (Object)item.getLabel());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(item).join();
        Assert.assertEquals((Object)"This should be plain.", (Object)resolvedItem.getDocumentation());
    }

    @Test
    public void testCompletion_getter() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    private String strField;\n    get}\n");
        int[] loc = this.findCompletionLocation(unit, "get");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("getStrField() : String")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"getStrField", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Function, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999979", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 4, 7, "/**\n * @return the strField\n */\npublic String getStrField() {\n\treturn strField;\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_booleangetter() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    private boolean boolField;\n    is\n}\n");
        int[] loc = this.findCompletionLocation(unit, "is");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("isBoolField() : boolean")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"isBoolField", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Function, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999979", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 4, 6, "/**\n * @return the boolField\n */\npublic boolean isBoolField() {\n\treturn boolField;\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_setter() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    private String strField;\n    set}\n");
        int[] loc = this.findCompletionLocation(unit, "set");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("setStrField(String strField) : void")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"setStrField", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Function, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999979", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 4, 7, "/**\n * @param strField the strField to set\n */\npublic void setStrField(String strField) {\n\tthis.strField = strField;\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousType() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        IFoo foo = new \n    } \n    interface IFoo {\n        String getName();\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "new ");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Foo.IFoo()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Foo.IFoo", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Constructor, (Object)ci.getKind());
        Assert.assertEquals((Object)"999998684", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 23, 23, "IFoo(){\n\n\t\t@Override\n\t\tpublic String getName() {\n\t\t\t${0:return null;}\n\t\t}\n};", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousTypeMoreMethods() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        IFoo foo = new \n    } \n    interface IFoo {\n        String getName();\n        void setName(String name);\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "new ");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Foo.IFoo()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Foo.IFoo", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Constructor, (Object)ci.getKind());
        Assert.assertEquals((Object)"999998684", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 23, 23, "IFoo(){\n\n\t\t@Override\n\t\tpublic void setName(String name) {\n\t\t\t${0}\n\t\t}\n\n\t\t@Override\n\t\tpublic String getName() {\n\t\t\treturn null;\n\t\t}\n};", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousDeclarationType() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        new Runnable()\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "Runnable(");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Runnable()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Runnable", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999372", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 20, 22, "(){\n\n\t@Override\n\tpublic void run() {\n\t\t${0}\n\t}\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousDeclarationType2() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        new Runnable(  )\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "Runnable( ");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Runnable()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Runnable", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999372", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 20, 24, "(){\n\n\t@Override\n\tpublic void run() {\n\t\t${0}\n\t}\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousDeclarationType3() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        run(\"name\", new Runnable(, 1);\n    }\n    void run(String name, Runnable runnable, int i) {\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "Runnable(");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Runnable()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Runnable", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999372", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 32, 33, "(){\n\n\t@Override\n\tpublic void run() {\n\t\t${0}\n\t}\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousDeclarationType4() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        run(\"name\", new Runnable(\n        , 1);\n    }\n    void run(String name, Runnable runnable, int i) {\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "Runnable(");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Runnable()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Runnable", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999372", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 32, 33, "(){\n\n\t@Override\n\tpublic void run() {\n\t\t${0}\n\t}\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_AnonymousDeclarationType5() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n    public static void main(String[] args) {\n        run(\"name\", new Runnable(");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "Runnable(");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Runnable()  Anonymous Inner Type")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Runnable", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Class, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999372", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 33, 33, "(){\n\n\t@Override\n\tpublic void run() {\n\t\t${0}\n\t}\n}", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_class_name_contains_$() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Foo$Bar.java", "public class Foo$Bar {\n    public static void main(String[] args) {\n        new Foo\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "new Foo");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Foo$Bar")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Foo$Bar", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Constructor, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999115", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 12, 15, "Foo\\$Bar()", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_class_name_contains_$withoutSnippetSupport() throws Exception {
        this.mockLSPClient(false, true);
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Foo$Bar.java", "public class Foo$Bar {\n    public static void main(String[] args) {\n        new Foo\n    }\n}\n");
        this.waitForBackgroundJobs();
        int[] loc = this.findCompletionLocation(unit, "new Foo");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        CompletionItem ci = list.getItems().stream().filter(item -> item.getLabel().startsWith("Foo$Bar")).findFirst().orElse(null);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"Foo$Bar", (Object)ci.getInsertText());
        Assert.assertEquals((Object)CompletionItemKind.Constructor, (Object)ci.getKind());
        Assert.assertEquals((Object)"999999115", (Object)ci.getSortText());
        Assert.assertNull((Object)ci.getTextEdit());
        CompletionItem resolvedItem = (CompletionItem)this.server.resolveCompletionItem(ci).join();
        Assert.assertNotNull((Object)resolvedItem.getTextEdit());
        Lsp4jAssertions.assertTextEdit(2, 12, 15, "Foo$Bar", resolvedItem.getTextEdit());
    }

    @Test
    public void testCompletion_testClassesDontLeakIntoMainCode() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/org/sample/Test.java", "package org.sample;\n\npublic class Test extends AbstractTe {\n}\n");
        int[] loc = this.findCompletionLocation(unit, " AbstractTe");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertEquals((String)("Test proposals leaked:\n" + list.getItems()), (long)0L, (long)list.getItems().size());
    }

    @Test
    public void testCompletion_testClassesAvailableIntoTestCode() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("test/foo/bar/BaseTest.java", "package foo.bar;\n\npublic class BaseTest extends AbstractTe {\n}\n");
        int[] loc = this.findCompletionLocation(unit, " AbstractTe");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((String)("Test proposals missing from :\n" + list), (long)1L, (long)list.getItems().size());
        Assert.assertEquals((Object)"AbstractTest - foo.bar", (Object)((CompletionItem)list.getItems().get(0)).getLabel());
    }

    @Test
    public void testStaticImports1() throws Exception {
        ArrayList<String> favorites = new ArrayList<String>();
        favorites.add("test1.A.foo");
        PreferenceManager.getPrefs(null).setJavaCompletionFavoriteMembers(favorites);
        try {
            ICompilationUnit unit = this.getWorkingCopy("src/test1/B.java", "package test1;\n\npublic class B {\n    public void bar() {\n        fo\n    }\n}\n");
            int[] loc = this.findCompletionLocation(unit, "fo");
            CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
            Assert.assertNotNull((Object)list);
            Assert.assertTrue((list.getItems().size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"no proposal for foo()", (boolean)"foo() : void".equals(((CompletionItem)list.getItems().get(0)).getLabel()));
        }
        finally {
            PreferenceManager.getPrefs(null).setJavaCompletionFavoriteMembers(Collections.emptyList());
        }
    }

    @Test
    public void testStaticImports2() throws Exception {
        PreferenceManager.getPrefs(null).setJavaCompletionFavoriteMembers(Collections.emptyList());
        ICompilationUnit unit = this.getWorkingCopy("src/test1/B.java", "package test1;\n\npublic class B {\n    public void bar() {\n        /* */fo\n    }\n    public void foo(int x) {\n    }\n}\n");
        int[] loc = this.findCompletionLocation(unit, "/* */fo");
        CompletionList list = (CompletionList)((Either)this.server.completion((TextDocumentPositionParams)JsonMessageHelper.getParams(this.createCompletionRequest(unit, loc[0], loc[1]))).join()).getRight();
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((list.getItems().size() > 0 ? 1 : 0) != 0);
        for (CompletionItem it : list.getItems()) {
            if (!"foo() : void".equals(it.getLabel())) continue;
            Assert.fail((String)"there is a proposal for foo()");
        }
    }

    private String createCompletionRequest(ICompilationUnit unit, int line, int kar) {
        return COMPLETION_TEMPLATE.replace("${file}", JDTUtils.toURI((ICompilationUnit)unit)).replace("${line}", String.valueOf(line)).replace("${char}", String.valueOf(kar));
    }

    private void mockLSP3Client() {
        this.mockLSPClient(true, true);
    }

    private void mockLSP2Client() {
        this.mockLSPClient(false, false);
    }

    private void mockLSPClient(boolean isSnippetSupported, boolean isSignatureHelpSuported) {
        Mockito.reset((Object[])new PreferenceManager[]{this.preferenceManager});
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        Mockito.when((Object)mockCapabilies.isCompletionSnippetsSupported()).thenReturn((Object)isSnippetSupported);
        Mockito.when((Object)mockCapabilies.isSignatureHelpSupported()).thenReturn((Object)isSignatureHelpSuported);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
    }
}

