/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.correction.AbstractQuickFixTest;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.junit.Before;
import org.junit.Test;

public class ReorgQuickFixTest
extends AbstractQuickFixTest {
    private IJavaProject fJProject1;
    private IPackageFragmentRoot fSourceFolder;

    @Before
    public void setup() throws Exception {
        this.fJProject1 = this.newEmptyProject();
        this.fJProject1.setOptions(TestOptions.getDefaultOptions());
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src"));
    }

    @Test
    public void testUnusedImports() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove unused import", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Organize imports", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testUnusedImportsInDefaultPackage() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("import java.util.Vector;\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove unused import", buf.toString());
        buf = new StringBuilder();
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Organize imports", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testUnusedImportOnDemand() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.net.*;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append(" Vector v;\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append(" Vector v;\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove unused import", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Organize imports", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testCollidingImports() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.security.Permission;\n");
        buf.append("import java.security.acl.Permission;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append(" Permission p;\n");
        buf.append(" Vector v;\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.security.Permission;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append(" Permission p;\n");
        buf.append(" Vector v;\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove unused import", buf.toString());
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Organize imports", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testWrongPackageStatement() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Change package declaration to 'test1'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongPackageStatementInEnum() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("public enum E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public enum E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Change package declaration to 'test1'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongPackageStatementFromDefault() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Remove package declaration 'package test2'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongDefaultPackageStatement() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test2", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add package declaration 'test2;'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongPackageStatementButColliding() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Change package declaration to 'test1'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeName() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("X.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'X'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeName_bug180330() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("p", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package p;\n");
        buf.append("public class \\u0042 {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("C.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package p;\n");
        buf.append("public class C {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'C'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeNameButColliding() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        pack1.createCompilationUnit("X.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'E'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeNameWithConstructor() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append(" public X() {\n");
        buf.append(" X other;\n");
        buf.append(" }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        pack1.createCompilationUnit("X.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append(" public E() {\n");
        buf.append(" E other;\n");
        buf.append(" }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'E'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeNameInEnum() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public enum X {\n");
        buf.append(" A;\n");
        buf.append(" X() {\n");
        buf.append(" }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        pack1.createCompilationUnit("X.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public enum E {\n");
        buf.append(" A;\n");
        buf.append(" E() {\n");
        buf.append(" }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'E'", buf.toString());
        this.assertCodeActions(cu, e1);
    }

    @Test
    public void testWrongTypeNameInAnnot() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public @interface X {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public @interface X {\n");
        buf.append("}\n");
        pack1.createCompilationUnit("X.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public @interface E {\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Rename type to 'E'", buf.toString());
        this.assertCodeActions(cu, e1);
    }
}

