/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.commands.OrganizeImportsCommand;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrganizeImportsCommandTest
extends AbstractProjectsManagerBasedTest {
    private IJavaProject fJProject1;
    private IPackageFragmentRoot fSourceFolder;
    private OrganizeImportsCommand command = new OrganizeImportsCommand();

    @Before
    public void setup() throws Exception {
        this.fJProject1 = this.newEmptyProject();
        Hashtable<String, String> options = TestOptions.getDefaultOptions();
        this.fJProject1.setOptions(options);
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src"));
    }

    public void setupJava9() throws Exception {
        this.importExistingProjects("eclipse/java9");
        IProject project = WorkspaceHelper.getProject("java9");
        this.fJProject1 = JavaCore.create((IProject)project);
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src/main/java"));
    }

    @Test
    public void testOrganizeImportsModuleInfo() throws Exception {
        this.setupJava9();
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("import foo.bar.MyDriverAction;\n");
        buf.append("import java.sql.DriverAction;\n");
        buf.append("import java.sql.SQLException;\n");
        buf.append("\n");
        buf.append("module mymodule.nine {\n");
        buf.append("\trequires java.sql;\n");
        buf.append("\texports foo.bar;\n");
        buf.append("\tprovides DriverAction with MyDriverAction;\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("module-info.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("import java.sql.DriverAction;\n");
        buf.append("\n");
        buf.append("import foo.bar.MyDriverAction;\n");
        buf.append("\n");
        buf.append("module mymodule.nine {\n");
        buf.append("\trequires java.sql;\n");
        buf.append("\texports foo.bar;\n");
        buf.append("\tprovides DriverAction with MyDriverAction;\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        this.command.organizeImportsInCompilationUnit(cu, rootEdit);
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu, rootEdit));
    }

    @Test
    public void testOrganizeImportsUnused() throws CoreException, BadLocationException {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        this.command.organizeImportsInCompilationUnit(cu, rootEdit);
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu, rootEdit));
    }

    @Test
    public void testOrganizeImportsSort() throws CoreException, BadLocationException {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public E() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public E() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        this.command.organizeImportsInCompilationUnit(cu, rootEdit);
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu, rootEdit));
    }

    @Test
    public void testOrganizeImportsAutomaticallyResolve() throws CoreException, BadLocationException {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public E() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public E() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        this.command.organizeImportsInCompilationUnit(cu, rootEdit);
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu, rootEdit));
    }

    @Test
    public void testOrganizeImportsInPackage() throws CoreException, BadLocationException {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu1 = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class F {\n");
        buf.append("\n");
        buf.append("    public F() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu2 = pack1.createCompilationUnit("F.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        this.command.organizeImportsInPackageFragment(pack1, rootEdit);
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu1, rootEdit));
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("\n");
        buf.append("public class F {\n");
        buf.append("\n");
        buf.append("    public F() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu2, rootEdit));
    }

    @Test
    public void testOrganizeImportsInProject() throws CoreException, BadLocationException {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ICompilationUnit cu1 = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("\n");
        buf.append("public class F {\n");
        buf.append("\n");
        buf.append("    public F() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu2 = pack1.createCompilationUnit("F.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        WorkspaceEdit rootEdit = this.command.organizeImportsInProject(pack1.getJavaProject().getProject());
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu1, rootEdit));
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("\n");
        buf.append("import java.util.ArrayList;\n");
        buf.append("import java.util.HashMap;\n");
        buf.append("\n");
        buf.append("public class F {\n");
        buf.append("\n");
        buf.append("    public F() {\n");
        buf.append("        ArrayList list = new ArrayList();\n");
        buf.append("        HashMap<String, String> map = new HashMap<String, String>();\n");
        buf.append("    }\n");
        buf.append("}\n");
        Assert.assertEquals((Object)buf.toString(), (Object)this.getOrganizeImportResult(cu2, rootEdit));
    }

    private String getOrganizeImportResult(ICompilationUnit cu, WorkspaceEdit we) throws BadLocationException, CoreException {
        List change = (List)we.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu));
        Document doc = new Document();
        doc.set(cu.getSource());
        return TextEditUtil.apply(doc, (Collection<? extends TextEdit>)change);
    }
}

