/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Date;
import java.util.List;
import org.eclipse.january.dataset.AbstractCompoundDataset;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DateDataset;
import org.eclipse.january.dataset.DateDatasetImpl;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ObjectDataset;
import org.eclipse.january.dataset.RGBByteDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.StringDataset;

public class DatasetFactory {
    @Deprecated
    public static Dataset createRange(double stop, int dtype) {
        return DatasetFactory.createRange(0.0, stop, 1.0, dtype);
    }

    @Deprecated
    public static Dataset createRange(double start, double stop, double step, int dtype) {
        return DatasetFactory.createRange(DTypeUtils.getInterface(dtype), start, stop, step);
    }

    @Deprecated
    public static CompoundDataset createRange(int itemSize, double stop, int dtype) {
        return DatasetFactory.createRange(itemSize, 0.0, stop, 1.0, dtype);
    }

    @Deprecated
    public static CompoundDataset createRange(int itemSize, double start, double stop, double step, int dtype) {
        Class<? extends CompoundDataset> clazz = InterfaceUtils.getCompoundInterface(DTypeUtils.getInterface(dtype));
        return DatasetFactory.createRange(itemSize, clazz, start, stop, step);
    }

    @Deprecated
    public static Dataset createFromObject(int dtype, Object obj) {
        return DatasetFactory.createFromObject(dtype, obj, null);
    }

    @Deprecated
    public static Dataset createFromObject(int dtype, Object obj, int ... shape) {
        return DatasetFactory.createFromObject(1, dtype, obj, shape);
    }

    @Deprecated
    public static Dataset createFromObject(int itemSize, int dtype, Object obj, int ... shape) {
        return DatasetFactory.createFromObject(itemSize, DTypeUtils.getInterface(dtype), obj, shape);
    }

    @Deprecated
    public static Dataset createFromList(int dtype, List<?> objectList) {
        return DatasetFactory.createFromList(DTypeUtils.getInterface(dtype), objectList);
    }

    @Deprecated
    public static CompoundDataset createCompoundDataset(int dtype, Object ... objects) {
        return DatasetFactory.createCompoundDataset(new Object[]{DTypeUtils.getInterface(dtype), objects});
    }

    @Deprecated
    public static CompoundDataset createComplexDataset(int dtype, Object real, Object imag) {
        return DatasetFactory.createComplexDataset(DTypeUtils.getInterface(dtype), real, imag);
    }

    @Deprecated
    public static Dataset zeros(int[] shape, int dtype) {
        return DatasetFactory.zeros(DTypeUtils.getInterface(dtype), shape);
    }

    @Deprecated
    public static Dataset zeros(int itemSize, int[] shape, int dtype) {
        if (itemSize == 1) {
            return DatasetFactory.zeros(shape, dtype);
        }
        return DatasetFactory.compoundZeros(itemSize, shape, dtype);
    }

    @Deprecated
    public static CompoundDataset compoundZeros(int itemSize, int[] shape, int dtype) {
        return DatasetFactory.compoundZeros(itemSize, InterfaceUtils.getCompoundInterface(DTypeUtils.getInterface(dtype)), shape);
    }

    @Deprecated
    public static Dataset zeros(Dataset dataset, int dtype) {
        Class<? extends Dataset> clazz = DTypeUtils.getInterface(dtype);
        int isize = InterfaceUtils.isElemental(clazz) ? 1 : dataset.getElementsPerItem();
        return DatasetFactory.zeros(isize, clazz, dataset.getShapeRef());
    }

    @Deprecated
    public static Dataset ones(Dataset dataset, int dtype) {
        Class<? extends Dataset> clazz = DTypeUtils.getInterface(dtype);
        int isize = InterfaceUtils.isElemental(clazz) ? 1 : dataset.getElementsPerItem();
        return DatasetFactory.ones(isize, clazz, dataset.getShapeRef());
    }

    @Deprecated
    public static Dataset ones(int[] shape, int dtype) {
        return DatasetFactory.ones(DTypeUtils.getInterface(dtype), shape);
    }

    @Deprecated
    public static Dataset ones(int itemSize, int[] shape, int dtype) {
        return DatasetFactory.ones(itemSize, DTypeUtils.getInterface(dtype), shape);
    }

    @Deprecated
    public static Dataset createLinearSpace(double start, double stop, int length, int dtype) {
        return DatasetFactory.createLinearSpace(DTypeUtils.getInterface(dtype), start, stop, length);
    }

    @Deprecated
    public static Dataset createLogSpace(double start, double stop, int length, double base, int dtype) {
        return DatasetFactory.createLogSpace(DTypeUtils.getInterface(dtype), start, stop, length, base);
    }

    public static <T extends Dataset> T createLinearSpace(Class<T> clazz, double start, double stop, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one");
        }
        if (length == 1) {
            return DatasetFactory.createFromObject(clazz, (Object)start);
        }
        T ds = DatasetFactory.zeros(clazz, length);
        double num = stop - start;
        double den = length - 1;
        int i = 0;
        while (i < length) {
            double value = start + num * (double)i / den;
            ds.setObjectAbs(i, value);
            ++i;
        }
        return ds;
    }

    public static <T extends Dataset> T createLogSpace(Class<T> clazz, double start, double stop, int length, double base) {
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one");
        }
        if (length == 1) {
            return DatasetFactory.createFromObject(clazz, (Object)Math.pow(base, start));
        }
        T ds = DatasetFactory.zeros(clazz, length);
        double step = (stop - start) / (double)(length - 1);
        int i = 0;
        while (i < length) {
            double value = start + (double)i * step;
            ds.setObjectAbs(i, Math.pow(base, value));
            ++i;
        }
        return ds;
    }

    public static DoubleDataset createRange(double stop) {
        return DatasetFactory.createRange(DoubleDataset.class, 0.0, stop, 1.0);
    }

    public static DoubleDataset createRange(double start, double stop, double step) {
        return DatasetFactory.createRange(DoubleDataset.class, start, stop, step);
    }

    public static <T extends Dataset> T createRange(Class<T> clazz, double stop) {
        return DatasetFactory.createRange(clazz, 0.0, stop, 1.0);
    }

    public static <T extends Dataset> T createRange(Class<T> clazz, double start, double stop, double step) {
        if (step > 0.0 != start <= stop) {
            throw new IllegalArgumentException("Invalid parameters: start and stop must be in correct order for step");
        }
        AbstractDataset d = null;
        if (ByteDataset.class.isAssignableFrom(clazz)) {
            d = ByteDataset.createRange(start, stop, step);
        } else if (ShortDataset.class.isAssignableFrom(clazz)) {
            d = ShortDataset.createRange(start, stop, step);
        } else if (IntegerDataset.class.isAssignableFrom(clazz)) {
            d = IntegerDataset.createRange(start, stop, step);
        } else if (LongDataset.class.isAssignableFrom(clazz)) {
            d = LongDataset.createRange(start, stop, step);
        } else if (FloatDataset.class.isAssignableFrom(clazz)) {
            d = FloatDataset.createRange(start, stop, step);
        } else if (DoubleDataset.class.isAssignableFrom(clazz)) {
            d = DoubleDataset.createRange(start, stop, step);
        } else if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            d = ComplexFloatDataset.createRange(start, stop, step);
        } else if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            d = ComplexDoubleDataset.createRange(start, stop, step);
        } else {
            throw new IllegalArgumentException("Dataset interface not supported");
        }
        return (T)d;
    }

    public static <T extends CompoundDataset> T createRange(int itemSize, Class<T> clazz, double stop) {
        return DatasetFactory.createRange(itemSize, clazz, 0.0, stop, 1.0);
    }

    public static <T extends CompoundDataset> T createRange(int itemSize, Class<T> clazz, double start, double stop, double step) {
        if (itemSize < 1) {
            throw new IllegalArgumentException("Item size must be greater or equal to 1");
        }
        if (step > 0.0 != start <= stop) {
            throw new IllegalArgumentException("Invalid parameters: start and stop must be in correct order for step");
        }
        AbstractCompoundDataset c = null;
        if (CompoundByteDataset.class.isAssignableFrom(clazz)) {
            c = CompoundIntegerDataset.createRange(itemSize, start, stop, step);
        } else if (CompoundShortDataset.class.isAssignableFrom(clazz)) {
            c = CompoundShortDataset.createRange(itemSize, start, stop, step);
        } else if (CompoundIntegerDataset.class.isAssignableFrom(clazz)) {
            c = CompoundIntegerDataset.createRange(itemSize, start, stop, step);
        } else if (CompoundLongDataset.class.isAssignableFrom(clazz)) {
            c = CompoundLongDataset.createRange(itemSize, start, stop, step);
        } else if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 2) {
                throw new IllegalArgumentException("Item size must be equal to 2");
            }
            c = ComplexFloatDataset.createRange(start, stop, step);
        } else if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 2) {
                throw new IllegalArgumentException("Item size must be equal to 2");
            }
            c = ComplexDoubleDataset.createRange(start, stop, step);
        } else if (CompoundFloatDataset.class.isAssignableFrom(clazz)) {
            c = CompoundFloatDataset.createRange(itemSize, start, stop, step);
        } else if (CompoundDoubleDataset.class.isAssignableFrom(clazz)) {
            c = CompoundDoubleDataset.createRange(itemSize, start, stop, step);
        } else {
            throw new IllegalArgumentException("dtype not known");
        }
        return (T)c;
    }

    public static Dataset createFromObject(Object obj) {
        return DatasetFactory.createFromObject(obj, null);
    }

    public static Dataset createFromObject(Object obj, int ... shape) {
        if (obj instanceof IDataset) {
            Dataset d = DatasetUtils.convertToDataset((IDataset)obj);
            if (shape != null) {
                d.setShape(shape);
            }
            return d;
        }
        return DatasetFactory.createFromObject(InterfaceUtils.getInterface(obj), obj, shape);
    }

    public static Dataset createFromObject(boolean isUnsigned, Object obj) {
        Dataset a = DatasetFactory.createFromObject(obj);
        if (isUnsigned) {
            a = DatasetUtils.makeUnsigned(a, true);
        }
        return a;
    }

    public static Dataset createFromList(List<?> objectList) {
        if (objectList == null || objectList.size() == 0) {
            throw new IllegalArgumentException("No list or zero-length list given");
        }
        Object obj = null;
        for (Object o : objectList) {
            if (o == null) continue;
            obj = o;
            break;
        }
        if (obj == null) {
            return DatasetFactory.zeros(ObjectDataset.class, objectList.size());
        }
        Class<?> clazz = obj.getClass();
        if (InterfaceUtils.isElementSupported(clazz)) {
            return DatasetFactory.createFromList(InterfaceUtils.getInterface(obj), objectList);
        }
        return DatasetFactory.createFromObject(objectList);
    }

    public static CompoundDataset createCompoundDataset(Object ... objects) {
        Dataset[] datasets = new Dataset[objects.length];
        int i = 0;
        while (i < objects.length) {
            datasets[i] = DatasetFactory.createFromObject(objects[i]);
            ++i;
        }
        return DatasetUtils.createCompoundDataset(datasets);
    }

    public static <T extends Dataset> T createFromObject(Class<T> clazz, Object obj) {
        return DatasetFactory.createFromObject(1, clazz, obj, null);
    }

    public static <T extends Dataset> T createFromObject(Class<T> clazz, Object obj, int ... shape) {
        return DatasetFactory.createFromObject(1, clazz, obj, shape);
    }

    public static <T extends Dataset> T createFromObject(int itemSize, Class<T> clazz, Object obj, int ... shape) {
        Dataset d = null;
        if (obj instanceof IDataset) {
            d = (Dataset)(itemSize == 1 ? DatasetUtils.cast(clazz, (IDataset)obj) : DatasetUtils.cast(itemSize, clazz, (IDataset)obj, false));
        } else {
            Class<?> ca;
            Class<?> clazz2 = ca = obj == null ? null : obj.getClass().getComponentType();
            if (ca != null && (ca.isPrimitive() || ca.equals(String.class))) {
                if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
                    return (T)new ComplexFloatDataset(DTypeUtils.toFloatArray(obj, DTypeUtils.getLength(obj)), shape);
                }
                if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
                    return (T)new ComplexDoubleDataset(DTypeUtils.toDoubleArray(obj, DTypeUtils.getLength(obj)), shape);
                }
                d = DatasetFactory.createFromPrimitiveArray(InterfaceUtils.getInterfaceFromClass(1, ca), obj);
                if (!InterfaceUtils.isElemental(clazz)) {
                    if (RGBByteDataset.class.isAssignableFrom(clazz) || RGBDataset.class.isAssignableFrom(clazz)) {
                        if ((d = DatasetUtils.createCompoundDataset(d, 3)).getSize() == 1) {
                            d.setShape(new int[0]);
                        }
                    } else {
                        d = DatasetUtils.createCompoundDataset(d, itemSize);
                    }
                }
                d = d.cast(clazz);
            } else if (BooleanDataset.class.isAssignableFrom(clazz)) {
                d = BooleanDataset.createFromObject(obj);
            } else if (ByteDataset.class.isAssignableFrom(clazz)) {
                d = ByteDataset.createFromObject(obj);
            } else if (ShortDataset.class.isAssignableFrom(clazz)) {
                d = ShortDataset.createFromObject(obj);
            } else if (IntegerDataset.class.isAssignableFrom(clazz)) {
                d = IntegerDataset.createFromObject(obj);
            } else if (LongDataset.class.isAssignableFrom(clazz)) {
                d = LongDataset.createFromObject(obj);
            } else if (RGBByteDataset.class.isAssignableFrom(clazz)) {
                d = RGBByteDataset.createFromObject(obj);
            } else if (CompoundByteDataset.class.isAssignableFrom(clazz)) {
                d = CompoundByteDataset.createFromObject(itemSize, obj);
            } else if (RGBDataset.class.isAssignableFrom(clazz)) {
                d = RGBDataset.createFromObject(obj);
            } else if (CompoundShortDataset.class.isAssignableFrom(clazz)) {
                d = CompoundShortDataset.createFromObject(itemSize, obj);
            } else if (CompoundIntegerDataset.class.isAssignableFrom(clazz)) {
                d = CompoundIntegerDataset.createFromObject(itemSize, obj);
            } else if (CompoundLongDataset.class.isAssignableFrom(clazz)) {
                d = CompoundLongDataset.createFromObject(itemSize, obj);
            } else if (FloatDataset.class.isAssignableFrom(clazz)) {
                d = FloatDataset.createFromObject(obj);
            } else if (DoubleDataset.class.isAssignableFrom(clazz)) {
                d = DoubleDataset.createFromObject(obj);
            } else if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
                d = ComplexFloatDataset.createFromObject(obj);
            } else if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
                d = ComplexDoubleDataset.createFromObject(obj);
            } else if (CompoundFloatDataset.class.isAssignableFrom(clazz)) {
                d = CompoundFloatDataset.createFromObject(itemSize, obj);
            } else if (CompoundDoubleDataset.class.isAssignableFrom(clazz)) {
                d = CompoundDoubleDataset.createFromObject(itemSize, obj);
            } else if (DateDataset.class.isAssignableFrom(clazz)) {
                d = DateDatasetImpl.createFromObject(obj);
            } else if (StringDataset.class.isAssignableFrom(clazz)) {
                d = StringDataset.createFromObject(obj);
            } else if (ObjectDataset.class.isAssignableFrom(clazz)) {
                d = ObjectDataset.createFromObject(obj);
            } else {
                throw new IllegalArgumentException("Dataset interface is not unsupported");
            }
        }
        if (shape != null && (shape.length != 0 || d.getSize() <= 1)) {
            d.setShape(shape);
        }
        return (T)d;
    }

    private static Dataset createFromPrimitiveArray(Class<? extends Dataset> clazz, Object array) {
        if (BooleanDataset.class.isAssignableFrom(clazz)) {
            return new BooleanDataset((boolean[])array, new int[0]);
        }
        if (ByteDataset.class.isAssignableFrom(clazz)) {
            return new ByteDataset((byte[])array, new int[0]);
        }
        if (ShortDataset.class.isAssignableFrom(clazz)) {
            return new ShortDataset((short[])array, new int[0]);
        }
        if (IntegerDataset.class.isAssignableFrom(clazz)) {
            return new IntegerDataset((int[])array, null);
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return new LongDataset((long[])array, new int[0]);
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return new FloatDataset((float[])array, new int[0]);
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return new DoubleDataset((double[])array, new int[0]);
        }
        if (StringDataset.class.isAssignableFrom(clazz)) {
            return new StringDataset((String[])array, new int[0]);
        }
        if (DateDataset.class.isAssignableFrom(clazz)) {
            return new DateDatasetImpl((Date[])array, new int[0]);
        }
        return null;
    }

    public static <T extends Dataset> T createFromList(Class<T> clazz, List<?> objectList) {
        int len = objectList.size();
        T result = DatasetFactory.zeros(clazz, len);
        int i = 0;
        while (i < len) {
            result.setObjectAbs(i, objectList.get(i));
            ++i;
        }
        return result;
    }

    public static <T extends CompoundDataset> T createCompoundDataset(Class<T> clazz, Object ... objects) {
        Dataset[] datasets = new Dataset[objects.length];
        int i = 0;
        while (i < objects.length) {
            datasets[i] = DatasetFactory.createFromObject(objects[i]);
            ++i;
        }
        return DatasetUtils.createCompoundDataset(clazz, datasets);
    }

    public static <T extends CompoundDataset> T createComplexDataset(Class<? extends Dataset> clazz, Object real, Object imag) {
        if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            return (T)new ComplexFloatDataset(DatasetFactory.createFromObject(real), DatasetFactory.createFromObject(imag));
        }
        if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)new ComplexDoubleDataset(DatasetFactory.createFromObject(real), DatasetFactory.createFromObject(imag));
        }
        throw new IllegalArgumentException("Dataset class must be a complex one");
    }

    public static DoubleDataset zeros(int ... shape) {
        return DatasetFactory.zeros(DoubleDataset.class, shape);
    }

    public static <T extends Dataset> T zeros(T dataset) {
        return DatasetFactory.zeros(dataset, dataset.getShapeRef());
    }

    public static <T extends Dataset> T zeros(T dataset, int ... shape) {
        Class<?> clazz = dataset.getClass();
        return (T)(InterfaceUtils.isElemental(dataset.getClass()) ? DatasetFactory.zeros(clazz, shape) : DatasetFactory.compoundZeros(dataset.getElementsPerItem(), InterfaceUtils.getCompoundInterface(clazz), shape));
    }

    public static <T extends Dataset> T zeros(Class<T> clazz, int ... shape) {
        if (BooleanDataset.class.isAssignableFrom(clazz)) {
            return (T)new BooleanDataset(shape);
        }
        if (ByteDataset.class.isAssignableFrom(clazz)) {
            return (T)new ByteDataset(shape);
        }
        if (ShortDataset.class.isAssignableFrom(clazz)) {
            return (T)new ShortDataset(shape);
        }
        if (IntegerDataset.class.isAssignableFrom(clazz)) {
            return (T)new IntegerDataset(shape);
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return (T)new LongDataset(shape);
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return (T)new FloatDataset(shape);
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)new DoubleDataset(shape);
        }
        if (RGBByteDataset.class.isAssignableFrom(clazz)) {
            return (T)new RGBByteDataset(shape);
        }
        if (RGBDataset.class.isAssignableFrom(clazz)) {
            return (T)new RGBDataset(shape);
        }
        if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            return (T)new ComplexFloatDataset(shape);
        }
        if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)new ComplexDoubleDataset(shape);
        }
        if (StringDataset.class.isAssignableFrom(clazz)) {
            return (T)new StringDataset(shape);
        }
        if (DateDataset.class.isAssignableFrom(clazz)) {
            return (T)new DateDatasetImpl(shape);
        }
        if (ObjectDataset.class.isAssignableFrom(clazz)) {
            return (T)new ObjectDataset(shape);
        }
        throw new IllegalArgumentException("Interface not known or unsupported");
    }

    public static <T extends Dataset> T zeros(int itemSize, Class<T> clazz, int ... shape) {
        if (itemSize == 1 && InterfaceUtils.isElemental(clazz)) {
            return DatasetFactory.zeros(clazz, shape);
        }
        return (T)DatasetFactory.compoundZeros(itemSize, InterfaceUtils.getCompoundInterface(clazz), shape);
    }

    public static <T extends Dataset> T zeros(Dataset dataset, Class<T> clazz) {
        return DatasetFactory.zeros(dataset.getElementsPerItem(), clazz, dataset.getShapeRef());
    }

    public static <T extends CompoundDataset> T compoundZeros(int itemSize, Class<T> clazz, int ... shape) {
        if (RGBByteDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 3) {
                throw new IllegalArgumentException("Number of elements not compatible with RGB type");
            }
            return (T)new RGBByteDataset(shape);
        }
        if (CompoundByteDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundByteDataset(itemSize, shape);
        }
        if (RGBDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 3) {
                throw new IllegalArgumentException("Number of elements not compatible with RGB type");
            }
            return (T)new RGBDataset(shape);
        }
        if (CompoundShortDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundShortDataset(itemSize, shape);
        }
        if (CompoundIntegerDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundIntegerDataset(itemSize, shape);
        }
        if (CompoundLongDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundLongDataset(itemSize, shape);
        }
        if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 2) {
                throw new IllegalArgumentException("Number of elements not compatible with complex type");
            }
            return (T)new ComplexFloatDataset(shape);
        }
        if (CompoundFloatDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundFloatDataset(itemSize, shape);
        }
        if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 2) {
                throw new IllegalArgumentException("Number of elements not compatible with complex type");
            }
            return (T)new ComplexDoubleDataset(shape);
        }
        if (CompoundDoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)new CompoundDoubleDataset(itemSize, shape);
        }
        throw new IllegalArgumentException("Class not a known compound interface");
    }

    public static DoubleDataset ones(int ... shape) {
        return DatasetFactory.ones(DoubleDataset.class, shape);
    }

    public static <T extends Dataset> T ones(T dataset) {
        return (T)DatasetFactory.ones(dataset, dataset.getClass());
    }

    public static <T extends Dataset> T ones(Class<T> clazz, int ... shape) {
        if (BooleanDataset.class.isAssignableFrom(clazz)) {
            return (T)BooleanDataset.ones(shape);
        }
        if (ByteDataset.class.isAssignableFrom(clazz)) {
            return (T)ByteDataset.ones(shape);
        }
        if (ShortDataset.class.isAssignableFrom(clazz)) {
            return (T)ShortDataset.ones(shape);
        }
        if (IntegerDataset.class.isAssignableFrom(clazz)) {
            return (T)IntegerDataset.ones(shape);
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return (T)LongDataset.ones(shape);
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return (T)FloatDataset.ones(shape);
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)DoubleDataset.ones(shape);
        }
        if (RGBByteDataset.class.isAssignableFrom(clazz)) {
            return (T)new RGBByteDataset(shape).fill(1);
        }
        if (RGBDataset.class.isAssignableFrom(clazz)) {
            return (T)new RGBDataset(shape).fill(1);
        }
        if (ComplexFloatDataset.class.isAssignableFrom(clazz)) {
            return (T)ComplexFloatDataset.ones(shape);
        }
        if (ComplexDoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)ComplexDoubleDataset.ones(shape);
        }
        if (StringDataset.class.isAssignableFrom(clazz)) {
            return (T)StringDataset.ones(shape);
        }
        if (DateDataset.class.isAssignableFrom(clazz)) {
            return (T)DateDatasetImpl.ones(shape);
        }
        if (ObjectDataset.class.isAssignableFrom(clazz)) {
            return (T)ObjectDataset.ones(shape);
        }
        throw new IllegalArgumentException("Interface not known or unsupported");
    }

    public static <T extends Dataset> T ones(int itemSize, Class<T> clazz, int ... shape) {
        if (InterfaceUtils.isElemental(clazz)) {
            return DatasetFactory.ones(clazz, shape);
        }
        if (RGBByteDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 3) {
                throw new IllegalArgumentException("Number of elements not compatible with RGB type");
            }
            return (T)new RGBByteDataset(shape).fill(1);
        }
        if (CompoundByteDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundByteDataset.ones(itemSize, shape);
        }
        if (RGBDataset.class.isAssignableFrom(clazz)) {
            if (itemSize != 3) {
                throw new IllegalArgumentException("Number of elements not compatible with RGB type");
            }
            return (T)new RGBDataset(shape).fill(1);
        }
        if (CompoundShortDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundShortDataset.ones(itemSize, shape);
        }
        if (CompoundIntegerDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundIntegerDataset.ones(itemSize, shape);
        }
        if (CompoundLongDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundLongDataset.ones(itemSize, shape);
        }
        if (CompoundFloatDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundFloatDataset.ones(itemSize, shape);
        }
        if (CompoundDoubleDataset.class.isAssignableFrom(clazz)) {
            return (T)CompoundDoubleDataset.ones(itemSize, shape);
        }
        throw new IllegalArgumentException("Class not a known compound interface");
    }

    public static <T extends Dataset> T ones(Dataset dataset, Class<T> clazz) {
        return DatasetFactory.ones(dataset.getElementsPerItem(), clazz, dataset.getShapeRef());
    }
}

