/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class DoubleDatasetTest {
    @Test
    public void testConstructor() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
        DoubleDataset b = new DoubleDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        DoubleDataset c = new DoubleDataset(a.getSliceView(new int[]{1}, null, new int[]{2}));
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(2 * i3 + 1), (double)c.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i3));
            ++i3;
        }
        a.hashCode();
        b.hashCode();
        c.hashCode();
    }

    @Test
    public void testGetter() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        int l = da.length;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((double)i, (double)a.getDouble(i), (double)(1.0E-5 * (double)i));
            ++i;
        }
        i = 0;
        while (i < l) {
            int r = l - 1 - i;
            Assert.assertEquals((double)r, (double)a.getDouble(-(i + 1)), (double)(1.0E-5 * (double)r));
            ++i;
        }
        Dataset sv = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        Dataset sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        l = sc.getSize();
        int i2 = 0;
        while (i2 < l) {
            double r = sc.getDouble(-(i2 + 1));
            Assert.assertEquals((double)r, (double)sv.getDouble(-(i2 + 1)), (double)(1.0E-5 * r));
            ++i2;
        }
        Assert.assertEquals((double)0.0, (double)a.getDouble(), (double)1.0E-16);
        try {
            a.getDouble(null);
            Assert.fail((String)"Should have thrown an NPE");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            a.getDouble(new int[2]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            a.getDouble(0, 0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(7), Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0}), (Dataset)sc);
        Dataset b = a.reshape(new int[]{4, 3});
        try {
            b.getDouble(new int[1]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            b.getDouble(0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        sc = b.getSlice(new Slice[]{new Slice(Integer.valueOf(7), Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0, 3}), (Dataset)sc);
        sc = b.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(-1))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0, 3}), (Dataset)sc);
    }

    @Test
    public void testCreators() {
        double dz = 0.5;
        DoubleDataset z = DoubleDataset.createFromObject((Object)dz);
        Assert.assertEquals((long)0L, (long)z.getRank());
        Assert.assertEquals((long)1L, (long)z.getSize());
        Assert.assertEquals((double)dz, (double)z.getElementDoubleAbs(0), (double)1.0E-14);
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DoubleDataset a = DoubleDataset.createFromObject((Object)da);
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)6L, (long)a.getSize());
        Assert.assertEquals((long)6L, (long)a.getShape()[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i));
            ++i;
        }
        double[][] db = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset b = DoubleDataset.createFromObject((Object)db);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertEquals((long)6L, (long)b.getSize());
        Assert.assertEquals((long)2L, (long)b.getShape()[0]);
        Assert.assertEquals((long)3L, (long)b.getShape()[1]);
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i2));
            ++i2;
        }
        double[][] dc = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        DoubleDataset c = DoubleDataset.createFromObject((Object)dc);
        Assert.assertEquals((long)2L, (long)c.getRank());
        Assert.assertEquals((long)8L, (long)c.getSize());
        Assert.assertEquals((long)2L, (long)c.getShape()[0]);
        Assert.assertEquals((long)4L, (long)c.getShape()[1]);
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            if (i3 < 7) {
                Assert.assertEquals((double)i3, (double)c.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i3));
            } else {
                Assert.assertEquals((double)0.0, (double)c.getElementDoubleAbs(it.index), (double)1.0E-15);
            }
            ++i3;
        }
        double[][] dd = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        DoubleDataset d = DoubleDataset.createFromObject((Object)dd);
        Assert.assertEquals((long)2L, (long)d.getRank());
        Assert.assertEquals((long)8L, (long)d.getSize());
        Assert.assertEquals((long)2L, (long)d.getShape()[0]);
        Assert.assertEquals((long)4L, (long)d.getShape()[1]);
        it = d.getIterator();
        int i4 = 0;
        while (it.hasNext()) {
            if (i4 != 3) {
                Assert.assertEquals((double)i4, (double)d.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i4));
            } else {
                Assert.assertEquals((double)0.0, (double)d.getElementDoubleAbs(it.index), (double)1.0E-15);
            }
            ++i4;
        }
    }

    @Test
    public void testRange() {
        DoubleDataset a = DoubleDataset.createRange((double)2.0, (double)12.4, (double)4.3);
        DoubleDataset e = new DoubleDataset(new double[]{2.0, 6.3, 10.6}, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)12.4, (double)2.0, (double)-4.3);
        e = new DoubleDataset(new double[]{12.4, 8.1, 3.8}, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)2.0, (double)12.4, (double)-4.3);
        e = new DoubleDataset(new int[]{0});
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)12.4, (double)2.0, (double)4.3);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange((double)12.0, (int)6);
        Assert.assertEquals((double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
        a.setShape(new int[]{3, 1, 4});
        Dataset b = a.sum(0, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{1, 4}, (int[])b.getShape());
        Assert.assertEquals((double)12.0, (double)b.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((double)15.0, (double)b.getDouble(0, 1), (double)1.0E-6);
        Assert.assertEquals((double)18.0, (double)b.getDouble(0, 2), (double)1.0E-6);
        Assert.assertEquals((double)21.0, (double)b.getDouble(0, 3), (double)1.0E-6);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{16.0, 16.0, 16.0, 16.0}, (int[])new int[]{1, 4}), (Dataset)a.variance(0));
        b = a.sum(1, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])b.getShape());
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{3, 4}), (Dataset)a.variance(1));
        Assert.assertEquals((Object)a.squeeze(), (Object)b);
        a.setShape(new int[]{3, 1, 4});
        b = a.sum(2, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 1}, (int[])b.getShape());
        Assert.assertEquals((double)6.0, (double)b.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((double)22.0, (double)b.getDouble(1, 0), (double)1.0E-6);
        Assert.assertEquals((double)38.0, (double)b.getDouble(2, 0), (double)1.0E-6);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.666666666667, 1.666666666667, 1.666666666667}, (int[])new int[]{3, 1}), (Dataset)a.variance(2));
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.25, 1.25, 1.25}, (int[])new int[]{3, 1}), (Dataset)a.variance(2, true, new boolean[0]));
        a.setShape(new int[]{12});
        a.set((Object)-1, 0);
        Assert.assertEquals((double)-1.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.41666667, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.75277675, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)14.0833333, (double)a.variance(), (double)1.0E-6);
    }

    @Test
    public void testMaths() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Dataset r = Maths.add((Object)a, (Object)a);
        IndexIterator it = r.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(2.0 * (double)i), (double)r.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
    }

    @Test
    public void testPosition() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Assert.assertEquals((long)6L, (long)a.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)a.minPos(new boolean[0])[0]);
        Dataset b = DatasetFactory.zeros((int[])new int[]{100, 200}, (int)6);
        b.set((Object)100.0, new int[]{50, 100});
        b.set((Object)-100.0, new int[]{51, 101});
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)51L, (long)b.minPos(new boolean[0])[0]);
        Assert.assertEquals((long)101L, (long)b.minPos(new boolean[0])[1]);
        b.set((Object)Double.NaN, new int[]{52, 53});
        Assert.assertEquals((long)52L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)53L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[]{true})[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[]{true})[1]);
        Dataset c = DatasetFactory.zeros((int[])new int[]{100, 200}, (int)6);
        c.set((Object)100.0, new int[]{99, 50});
        c.set((Object)99.99, new int[]{50, 50});
        Assert.assertEquals((long)99L, (long)c.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)50L, (long)c.maxPos(new boolean[0])[1]);
        c.set((Object)101, new int[2]);
        Assert.assertEquals((long)0L, (long)c.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)c.maxPos(new boolean[0])[1]);
    }
}

